/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling;

import com.github.mkopylec.errorest.handling.utils.HttpUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestAttributeSettingFilter
extends OncePerRequestFilter
implements Ordered {
    public static final String REQUEST_METHOD_ERROR_ATTRIBUTE = RequestAttributeSettingFilter.class.getName() + ".method";
    public static final String REQUEST_HEADERS_ERROR_ATTRIBUTE = RequestAttributeSettingFilter.class.getName() + ".headers";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable ex) {
            request.setAttribute(REQUEST_METHOD_ERROR_ATTRIBUTE, (Object)request.getMethod());
            request.setAttribute(REQUEST_HEADERS_ERROR_ATTRIBUTE, (Object)HttpUtils.getHeadersAsText(request));
            throw ex;
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

