/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling;

import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProviderContext;
import com.github.mkopylec.errorest.response.Errors;
import com.github.mkopylec.errorest.response.ErrorsFactory;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerErrorHandler {
    public static final String CONTROLLER_ERROR_HANDLING_ATTRIBUTE = ControllerErrorHandler.class.getName() + ".controllerHandling";
    protected final ErrorsFactory errorsFactory;
    protected final ErrorDataProviderContext providerContext;

    public ControllerErrorHandler(ErrorsFactory errorsFactory, ErrorDataProviderContext providerContext) {
        this.errorsFactory = errorsFactory;
        this.providerContext = providerContext;
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<Errors> handleThrowable(Throwable ex, HttpServletRequest request) {
        ErrorData errorData = this.getErrorData(ex, request);
        Errors errors = this.errorsFactory.logAndCreateErrors(errorData);
        return ResponseEntity.status((HttpStatus)errorData.getResponseStatus()).body((Object)errors);
    }

    protected ErrorData getErrorData(Throwable ex, HttpServletRequest request) {
        request.setAttribute(CONTROLLER_ERROR_HANDLING_ATTRIBUTE, (Object)true);
        ErrorDataProvider provider = this.providerContext.getErrorDataProvider(ex);
        return provider.getErrorData(ex, request);
    }
}

