/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.exceptions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.github.mkopylec.errorest.response.Errors;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.client.HttpStatusCodeException;

public class ExternalHttpRequestException
extends HttpStatusCodeException {
    private static final Logger log = LoggerFactory.getLogger(ExternalHttpRequestException.class);
    protected final HttpMethod method;
    protected final String url;
    protected final ObjectMapper jsonMapper;
    protected final XmlMapper xmlMapper;
    protected Errors errors;

    public ExternalHttpRequestException(HttpMethod method, String url, HttpStatus statusCode, String statusText, HttpHeaders responseHeaders, byte[] responseBody, Charset responseCharset, ObjectMapper jsonMapper, XmlMapper xmlMapper) {
        super(statusCode, statusText, responseHeaders, responseBody, responseCharset);
        this.method = method;
        this.url = url;
        this.jsonMapper = jsonMapper;
        this.xmlMapper = xmlMapper;
    }

    public Errors getResponseBodyAsErrors() {
        if (this.errors != null) {
            return this.errors;
        }
        this.errors = this.parseResponseBody();
        if (this.errors == null) {
            return Errors.emptyErrors();
        }
        return this.errors;
    }

    public String getMessage() {
        return "An external HTTP request has failed: " + this.method + " " + this.url + " " + this.getStatusCode() + ". Response body: " + this.getResponseBodyAsString();
    }

    protected Errors parseResponseBody() {
        try {
            if (this.hasContentType(MediaType.APPLICATION_JSON)) {
                return (Errors)this.jsonMapper.readValue(this.getResponseBodyAsString(), Errors.class);
            }
            if (this.hasContentType(MediaType.APPLICATION_XML)) {
                return (Errors)this.xmlMapper.readValue(this.getResponseBodyAsString(), Errors.class);
            }
            throw new IOException("Incompatible HTTP response Content-Type header: " + this.getResponseHeaders().getContentType());
        }
        catch (IOException e) {
            log.warn("Cannot convert HTTP response body to {}: {}", (Object)Errors.class.getName(), (Object)e.getMessage());
            return null;
        }
    }

    protected boolean hasContentType(MediaType mediaType) {
        MediaType contentType = this.getResponseHeaders().getContentType();
        return contentType != null && contentType.includes(mediaType);
    }
}

