/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.exceptions;

import com.github.mkopylec.errorest.exceptions.ApplicationExceptionConfiguration;
import com.github.mkopylec.errorest.logging.LoggingLevel;
import com.github.mkopylec.errorest.response.Error;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public abstract class ApplicationException
extends RuntimeException {
    protected final List<Error> errors;
    protected final HttpStatus responseHttpStatus;
    protected final LoggingLevel loggingLevel;

    public ApplicationException(ApplicationExceptionConfiguration configuration) {
        this(configuration.getErrors(), configuration.getResponseHttpStatus(), configuration.getLoggingLevel(), configuration.getCause());
    }

    private ApplicationException(List<Error> errors, HttpStatus responseHttpStatus, LoggingLevel loggingLevel, Throwable cause) {
        super(cause);
        Assert.notEmpty(errors, (String)"Empty errors");
        errors.forEach(error -> {
            Assert.notNull((Object)error, (String)"Empty error");
            Assert.hasText((String)error.getCode(), (String)"Empty error code");
            Assert.hasText((String)error.getDescription(), (String)"Empty error description");
        });
        Assert.notNull((Object)responseHttpStatus, (String)"Empty response HTTP status");
        Assert.notNull((Object)((Object)loggingLevel), (String)"Empty logging level");
        this.errors = errors;
        this.responseHttpStatus = responseHttpStatus;
        this.loggingLevel = loggingLevel;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public HttpStatus getResponseHttpStatus() {
        return this.responseHttpStatus;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public String getMessage() {
        return "An application error has occurred. Status: " + this.responseHttpStatus + " | " + this.errors;
    }
}

