package demo;

import com.github.metalloid.pagefactory.controls.Control;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

public class TextField extends Control {

    public TextField(WebDriver driver, SearchContext searchContext, By locatorValue) {
        super(driver, searchContext, locatorValue);
    }

    public TextField(WebDriver driver, SearchContext searchContext, By locatorValue, Integer i) {
        super(driver, searchContext, locatorValue, i);
    }

    public void setText(String value) {
        this.element().sendKeys(value);
    }

    @Override
    public String getText() {
        return this.element().getAttribute("value");
    }

    public void clear() {
        this.element().clear();
    }
}
