/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.quickboot.mybatis.page;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Pager<T>
extends Page<T> {
    private static final long serialVersionUID = -5428777368936766478L;
    public static final long CURRENT = 1L;
    public static final long SIZE = 10L;
    public static final long TOTAL = 0L;
    private long current = 1L;
    private long size = 10L;
    private long total = 0L;
    private List<T> dataList = Collections.emptyList();

    public static <E> IPage<E> handPage(IPage<E> page, List<E> list) {
        if (list == null) {
            list = Collections.EMPTY_LIST;
        } else {
            page.setTotal((long)list.size());
        }
        int current = (int)page.getCurrent();
        int size = (int)page.getSize();
        int startIndex = (current - 1) * size;
        int endIndex = current * size;
        endIndex = list.size() > endIndex ? endIndex : list.size() % size + startIndex;
        list = list.subList(startIndex, endIndex);
        page.setRecords(list);
        return page;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getSize() {
        return this.size;
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public Pager<T> setCurrent(long current) {
        this.current = current;
        return this;
    }

    public Pager<T> setSize(long size) {
        this.size = size;
        return this;
    }

    public Pager<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public Pager<T> setDataList(List<T> dataList) {
        this.dataList = dataList;
        return this;
    }

    public String toString() {
        return "Pager(current=" + this.getCurrent() + ", size=" + this.getSize() + ", total=" + this.getTotal() + ", dataList=" + this.getDataList() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pager)) {
            return false;
        }
        Pager other = (Pager)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$dataList = this.getDataList();
        List<T> other$dataList = other.getDataList();
        return !(this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $current = this.getCurrent();
        result = result * 59 + (int)($current >>> 32 ^ $current);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        return result;
    }
}

