/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import com.github.mengweijin.generator.entity.ProjectInfo;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtils.class);

    public static void copyTemplateFolderToJavaTmp(String classPathResource) {
        JarFile jarFile = null;
        InputStream inputStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(classPathResource);
        try {
            if (URLUtil.isJarURL((URL)url)) {
                jarFile = URLUtil.getJarFile((URL)url);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String jarEntryName = enumeration.nextElement().getName();
                    if (!jarEntryName.startsWith(classPathResource) || jarEntryName.endsWith("/")) continue;
                    inputStream = classLoader.getResource(jarEntryName).openConnection().getInputStream();
                    File tmpFile = FileUtil.file((String)(ProjectInfo.TMP_DIR + jarEntryName));
                    FileUtil.writeFromStream((InputStream)inputStream, (File)tmpFile);
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            IoUtil.close(inputStream);
            IoUtil.close((Closeable)jarFile);
        }
    }
}

