/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.reader;

import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.dialect.Props;
import com.github.mengweijin.generator.entity.DbInfo;
import com.github.mengweijin.generator.reader.BootFileReader;
import java.io.File;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;

public class PropertiesBootFileReader
implements BootFileReader {
    @Override
    public String getActiveProfilesEnv(File file) {
        try {
            Props props = new Props(file.toURI().toURL(), StandardCharsets.UTF_8);
            return props.getStr("spring.profiles.active");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public DbInfo getDbInfo(File file) {
        try {
            Props props = new Props(file.toURI().toURL(), StandardCharsets.UTF_8);
            String url = props.getStr("spring.datasource.url");
            if (StrUtil.isBlank((CharSequence)url)) {
                return null;
            }
            DbInfo dbInfo = new DbInfo();
            dbInfo.setUrl(url);
            dbInfo.setUsername(props.getStr("spring.datasource.username"));
            dbInfo.setPassword(props.getStr("spring.datasource.password"));
            return dbInfo;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

