/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.reader;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.EnumUtil;
import com.github.mengweijin.generator.entity.DbInfo;
import com.github.mengweijin.generator.reader.BootFileReader;
import com.github.mengweijin.generator.reader.BootFileType;
import com.github.mengweijin.generator.reader.PropertiesBootFileReader;
import com.github.mengweijin.generator.reader.YamlBootFileReader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class BootFileReaderFactory {
    private static final Map<BootFileType, Class> map = new HashMap<BootFileType, Class>();

    public static String getActiveProfilesEnv(File file) {
        return BootFileReaderFactory.getBootFileReader(file).getActiveProfilesEnv(file);
    }

    public static DbInfo getDbInfo(File file) {
        return BootFileReaderFactory.getBootFileReader(file).getDbInfo(file);
    }

    private static BootFileReader getBootFileReader(File file) {
        try {
            String suffix = FileNameUtil.getSuffix((File)file);
            BootFileType bootFileType = (BootFileType)EnumUtil.fromString(BootFileType.class, (String)suffix);
            Class cls = map.get((Object)bootFileType);
            return (BootFileReader)cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static {
        map.put(BootFileType.yml, YamlBootFileReader.class);
        map.put(BootFileType.yaml, YamlBootFileReader.class);
        map.put(BootFileType.properties, PropertiesBootFileReader.class);
    }
}

