/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.mojo;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.JarClassLoader;
import com.github.mengweijin.generator.DefaultAutoGenerator;
import com.github.mengweijin.generator.entity.Parameters;
import com.github.mengweijin.generator.entity.ProjectInfo;
import com.github.mengweijin.generator.util.TemplateUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    @Parameter
    private Parameters parameters;
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${basedir}")
    private File baseDir;
    @Parameter(defaultValue="${project.build.resources}", readonly=true, required=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true, readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.testResources}", readonly=true, required=true)
    private List<Resource> testResources;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", readonly=true, required=true)
    private File testSourceDir;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            FileUtil.del((File)FileUtil.file((String)ProjectInfo.TMP_DIR));
            this.loadParentProjectClassToJarClassLoader();
            TemplateUtils.copyTemplateFolderToJavaTmp("templates/");
            this.parameters = Optional.ofNullable(this.parameters).orElse(new Parameters());
            this.setDefaultFixedParameters(this.parameters);
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setParameters(this.parameters);
            projectInfo.setResourceList(this.getResources());
            projectInfo.setBaseDir(this.baseDir);
            projectInfo.setSourceDir(this.sourceDir);
            new DefaultAutoGenerator(projectInfo).execute();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract void setDefaultFixedParameters(Parameters var1);

    private void loadParentProjectClassToJarClassLoader() {
        try {
            List runtimeElements = this.project.getRuntimeClasspathElements();
            URL[] urls = new URL[runtimeElements.size()];
            for (int i = 0; i < runtimeElements.size(); ++i) {
                urls[i] = new File((String)runtimeElements.get(i)).toURI().toURL();
            }
            JarClassLoader jarClassLoader = new JarClassLoader(urls);
            Thread.currentThread().setContextClassLoader((ClassLoader)jarClassLoader);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void loadParentProjectClassToApplicationClassLoader() {
        URLClassLoader urlLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            List classpathElements = this.project.getCompileClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
                method.invoke((Object)urlLoader, urls[i]);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public List<Resource> getTestResources() {
        return this.testResources;
    }

    public File getTestSourceDir() {
        return this.testSourceDir;
    }

    public List<String> getCompilePath() {
        return this.compilePath;
    }

    public MavenSession getSession() {
        return this.session;
    }
}

