/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.mojo;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import com.github.mengweijin.generator.engine.BeetlStringTemplateEngine;
import com.github.mengweijin.generator.entity.Docker;
import com.github.mengweijin.generator.entity.ProjectInfo;
import com.github.mengweijin.generator.util.TemplateUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDockerMojo
extends AbstractMojo {
    @Parameter
    private Docker docker;
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${basedir}")
    private File baseDir;
    @Parameter(defaultValue="${project.build.resources}", readonly=true, required=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true, readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.testResources}", readonly=true, required=true)
    private List<Resource> testResources;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", readonly=true, required=true)
    private File testSourceDir;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    protected void generate() throws Exception {
        FileUtil.del((File)FileUtil.file((String)ProjectInfo.TMP_DIR));
        TemplateUtils.copyTemplateFolderToJavaTmp("templates/");
        HashMap<String, Object> objectMap = new HashMap<String, Object>(2);
        objectMap.put("ARTIFACT_ID", this.project.getArtifactId());
        objectMap.put("VERSION", this.project.getVersion());
        BeetlStringTemplateEngine templateEngine = new BeetlStringTemplateEngine();
        templateEngine.init(null);
        this.generateDockerScript(templateEngine, objectMap);
    }

    protected void execBash(String bashName) throws Exception {
        this.generate();
        String currentFileSystemMount = StrUtil.subPre((CharSequence)this.dockerfileDirector(), (int)2).toUpperCase(Locale.ROOT);
        StringBuilder builder = new StringBuilder("cmd /c ").append(currentFileSystemMount).append(" && ").append("cd ").append(this.dockerfileDirector()).append(" && ").append(bashName);
        String cmdOutput = RuntimeUtil.execForStr((String[])new String[]{builder.toString()});
        this.getLog().info((CharSequence)cmdOutput);
    }

    private void generateDockerScript(BeetlStringTemplateEngine templateEngine, Map<String, Object> objectMap) throws Exception {
        String templatePath = ProjectInfo.TMP_DIR + "templates/docker";
        List templateFileList = FileUtil.loopFiles((String)templatePath, file -> file.isFile() && file.getName().toLowerCase().endsWith(".btl"));
        for (File templateFile : templateFileList) {
            String outputFilePath = this.dockerfileDirector() + StrUtil.subBefore((CharSequence)templateFile.getName(), (CharSequence)".", (boolean)true);
            this.getLog().info((CharSequence)("Template " + templateFile.getAbsolutePath() + "--->" + outputFilePath));
            this.render(templateFile.getAbsolutePath(), outputFilePath, templateEngine, objectMap);
        }
    }

    protected String dockerfileDirector() {
        return this.baseDir.getAbsolutePath() + File.separator + "target" + File.separator;
    }

    private File render(String templatePath, String outputFilePath, BeetlStringTemplateEngine templateEngine, Map<String, Object> objectMap) throws Exception {
        File outputFile = FileUtil.file((String)outputFilePath);
        FileUtil.mkParentDirs((File)outputFile);
        templateEngine.writer(objectMap, templatePath, outputFile);
        return outputFile;
    }

    public Docker getDocker() {
        return this.docker;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public List<Resource> getTestResources() {
        return this.testResources;
    }

    public File getTestSourceDir() {
        return this.testSourceDir;
    }

    public List<String> getCompilePath() {
        return this.compilePath;
    }

    public MavenSession getSession() {
        return this.session;
    }
}

