/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.config;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.github.mengweijin.generator.entity.Parameters;
import com.github.mengweijin.generator.entity.ProjectInfo;
import com.github.mengweijin.generator.factory.TemplateEngineFactory;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOutput {
    private static final Logger log = LoggerFactory.getLogger(FileOutput.class);

    public static void outputFile(TableInfo tableInfo, Map<String, Object> objectMap, ProjectInfo projectInfo, String outputDir) {
        Parameters parameters = projectInfo.getParameters();
        AbstractTemplateEngine templateEngine = TemplateEngineFactory.getTemplateEngine(parameters.getTemplateType());
        String outputPackage = parameters.getOutputPackage();
        List templateFileList = FileUtil.loopFiles((String)parameters.getTemplateLocation(), file -> file.isFile() && file.getName().toLowerCase().endsWith(parameters.getTemplateType().getSuffix()));
        if (CollectionUtil.isEmpty((Collection)templateFileList)) {
            throw new RuntimeException("No template files found in location " + parameters.getTemplateLocation());
        }
        String message = "Found " + templateFileList.size() + " template files in location " + parameters.getTemplateLocation();
        log.info(message);
        try {
            for (File templateFile : templateFileList) {
                File outputFile = FileOutput.buildOutputFile(tableInfo, templateFile.getAbsolutePath(), outputDir, outputPackage);
                FileUtil.mkParentDirs((File)outputFile);
                templateEngine.writer(objectMap, templateFile.getAbsolutePath(), outputFile);
            }
        }
        catch (Exception e) {
            log.error("Template engine writer error!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static File buildOutputFile(TableInfo tableInfo, String templatePath, String outputDir, String outputPackage) {
        StringBuilder outputPath = new StringBuilder(outputDir);
        if (!outputDir.endsWith("/") && !outputDir.endsWith("\\")) {
            outputPath.append(File.separator);
        }
        if (!StrUtil.isBlank((CharSequence)outputPackage)) {
            outputPath.append(outputPackage).append(File.separator);
        }
        StringBuilder componentName = new StringBuilder();
        File templateFile = FileUtil.file((String)templatePath);
        String[] packageHierarchy = templateFile.getName().split("\\.");
        if ("entity".equalsIgnoreCase(packageHierarchy[0])) {
            outputPath.append(packageHierarchy[0]).append(File.separator);
        } else {
            for (int i = 0; i < packageHierarchy.length - 2; ++i) {
                componentName.append(NamingStrategy.capitalFirst((String)packageHierarchy[i]));
                outputPath.append(packageHierarchy[i].toLowerCase()).append(File.separator);
            }
        }
        outputPath.append(tableInfo.getEntityName()).append((CharSequence)componentName);
        String path = StrUtil.replace((CharSequence)outputPath.toString(), (CharSequence)".", (CharSequence)"/");
        return new File(path + "." + packageHierarchy[packageHierarchy.length - 2]);
    }
}

