/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.github.mengweijin.generator.config.CustomerDataSource;
import com.github.mengweijin.generator.config.FileOutput;
import com.github.mengweijin.generator.entity.DbInfo;
import com.github.mengweijin.generator.entity.IdField;
import com.github.mengweijin.generator.entity.Parameters;
import com.github.mengweijin.generator.entity.ProjectInfo;
import com.github.mengweijin.generator.factory.TemplateEngineFactory;
import com.github.mengweijin.generator.util.DbInfoUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutoGenerator {
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoGenerator.class);
    private ProjectInfo projectInfo;

    public DefaultAutoGenerator(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public void execute() {
        Parameters parameters = this.projectInfo.getParameters();
        String outputDir = FileUtil.file((File)this.projectInfo.getBaseDir(), (String)"target/code-generator/").getAbsolutePath();
        FileUtil.del((String)outputDir);
        FastAutoGenerator fastAutoGenerator = FastAutoGenerator.create((DataSourceConfig.Builder)this.dataSourceConfigBuilder()).globalConfig(builder -> builder.fileOverride().author(parameters.getAuthor()).enableSwagger().disableOpenDir().outputDir(outputDir).dateType(DateType.TIME_PACK).commentDate("yyyy-MM-dd")).packageConfig(builder -> builder.parent(parameters.getOutputPackage())).templateConfig(TemplateConfig.Builder::disable).strategyConfig(builder -> builder.addInclude(this.trimItemName(parameters.getTables())).addTablePrefix(this.trimItemName(parameters.getTablePrefix())).entityBuilder().superClass(parameters.getSuperEntityClass()).enableChainModel().enableLombok().enableTableFieldAnnotation().versionColumnName("version").versionPropertyName("version").logicDeleteColumnName("deleted").logicDeletePropertyName("deleted").naming(NamingStrategy.underline_to_camel).addSuperEntityColumns(this.generateDefaultSuperEntityColumns()).controllerBuilder().superClass(parameters.getSuperControllerClass()).enableHyphenStyle().enableRestStyle().serviceBuilder().superServiceClass(parameters.getSuperServiceClass()).superServiceImplClass(parameters.getSuperServiceImplClass()).mapperBuilder().superClass(parameters.getSuperDaoClass()).enableBaseColumnList().enableBaseResultMap()).injectionConfig(builder -> builder.beforeOutputFile((tableInfo, objectMap) -> {
            DefaultAutoGenerator.enhanceObjectMap(objectMap, parameters);
            FileOutput.outputFile(tableInfo, objectMap, this.projectInfo, outputDir);
        })).templateEngine(TemplateEngineFactory.getTemplateEngine(this.projectInfo.getParameters().getTemplateType()));
        fastAutoGenerator.execute();
    }

    private DataSourceConfig.Builder dataSourceConfigBuilder() {
        DbInfo dbInfo = DbInfoUtils.getDbInfo(this.projectInfo);
        CustomerDataSource dataSource = new CustomerDataSource(dbInfo.getUrl(), dbInfo.getUsername(), dbInfo.getPassword());
        return new DataSourceConfig.Builder((DataSource)dataSource);
    }

    private String[] generateDefaultSuperEntityColumns() {
        String superEntityClass = this.projectInfo.getParameters().getSuperEntityClass();
        if (StrUtil.isBlank((CharSequence)superEntityClass)) {
            return new String[0];
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = Class.forName(superEntityClass, true, classLoader);
            Field[] declaredFields = ClassUtil.getDeclaredFields(cls);
            return (String[])Arrays.stream(declaredFields).map(field -> StrUtil.toUnderlineCase((CharSequence)field.getName())).toArray(String[]::new);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String[] trimItemName(String[] items) {
        if (items == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(items).map(String::trim).toArray(String[]::new);
    }

    private static void enhanceObjectMap(Map<String, Object> objectMap, Parameters parameters) {
        objectMap.remove("package");
        objectMap.put("parameters", parameters);
        objectMap.put("idField", DefaultAutoGenerator.getIdField((TableInfo)objectMap.get("table")));
        objectMap.put("allFieldList", DefaultAutoGenerator.handleAllFieldList((TableInfo)objectMap.get("table")));
        objectMap.put("superEntityClassPackage", parameters.getSuperEntityClass());
        objectMap.put("hasLongField", DefaultAutoGenerator.hasLongField((TableInfo)objectMap.get("table")));
        log.info("Beetl parameter map: {}", objectMap);
    }

    private static boolean hasLongField(TableInfo tableInfo) {
        return tableInfo.getFields().stream().anyMatch(item -> "Long".equalsIgnoreCase(item.getPropertyType()));
    }

    private static IdField getIdField(TableInfo tableInfo) {
        TableField tableField = tableInfo.getFields().stream().filter(TableField::isKeyFlag).findFirst().orElse(null);
        IdField idField = new IdField();
        if (tableField != null) {
            idField.setColumnName(tableField.getName());
            idField.setPropertyName(tableField.getPropertyName());
            idField.setPropertyType(tableField.getColumnType().getType());
        }
        return idField;
    }

    private static List<TableField> handleAllFieldList(TableInfo tableInfo) {
        List fieldList = tableInfo.getFields();
        List commonFields = tableInfo.getCommonFields();
        ArrayList<TableField> allList = new ArrayList<TableField>();
        allList.addAll(fieldList);
        allList.addAll(commonFields);
        return allList;
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }
}

