/*
 * Decompiled with CFR 0.152.
 */
package com.github.meazza.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.meazza.annotation.RequestCopy;
import com.github.meazza.handler.RequestBodyWrapper;
import java.lang.reflect.Method;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class RequestHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestHandlerInterceptor.class);
    private static final Logger logger = LoggerFactory.getLogger(RequestHandlerInterceptor.class);
    private RestTemplate restTemplate = new RestTemplate();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        RequestCopy requestCopy = method.getAnnotation(RequestCopy.class);
        if (requestCopy == null) {
            return true;
        }
        String url = requestCopy.url() + request.getRequestURI();
        float ratio = requestCopy.ratio();
        Random random = new Random();
        if (!(random.nextFloat() <= ratio)) return true;
        block4 : switch (request.getMethod()) {
            case "GET": {
                new Thread(() -> {
                    String fullUrl = url + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
                    String result = (String)this.restTemplate.getForObject(fullUrl, String.class, new Object[0]);
                    logger.info("Send copied GET request to url: {}, and receive response: {}", (Object)fullUrl, (Object)result);
                }).start();
                return true;
            }
            case "POST": {
                switch (request.getHeader("Content-Type")) {
                    case "application/json": {
                        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(request);
                        JSONObject jsonObject = JSON.parseObject((String)requestWrapper.getBody());
                        if (jsonObject == null) return true;
                        new Thread(() -> {
                            String fullUrl = url + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
                            String result = (String)this.restTemplate.postForObject(fullUrl, (Object)jsonObject, String.class, new Object[0]);
                            logger.info("Send copied POST request to url: {}, body: {}, and receive response: {}", new Object[]{fullUrl, jsonObject, result});
                        }).start();
                        break block4;
                    }
                }
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) {
    }
}

