/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;

public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getName());

    public static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Class<?> current = clazz;
        while (true) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                if ((current = current.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(fieldName);
            }
            break;
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... paramType) throws NoSuchMethodException {
        Class<?> current = clazz;
        while (true) {
            try {
                return current.getDeclaredMethod(methodName, paramType);
            }
            catch (Exception exception) {
                if ((current = current.getSuperclass()) != Object.class) continue;
                throw new NoSuchMethodException(methodName);
            }
            break;
        }
    }

    public static void copyObject(Object from, Object to) {
        Class<?> obj = from.getClass();
        while (!obj.equals(Object.class)) {
            Field[] fields = obj.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                try {
                    fields[i].set(to, fields[i].get(from));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            obj = obj.getSuperclass();
        }
    }

    static {
        LOGGER.setLevel(LogginProperties.ReflectionUtils);
    }
}

