/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateHelper {
    public static final Date getDate(int year, int month, int day, int hour, int minute) {
        GregorianCalendar cal = new GregorianCalendar(year, DateHelper.intToCalendarMonth(month), day, hour, minute);
        return cal.getTime();
    }

    public static final Date getDate(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar(year, DateHelper.intToCalendarMonth(month), day, hour, minute, second);
        return cal.getTime();
    }

    public static final Date getDate(int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar(year, DateHelper.intToCalendarMonth(month), day);
        return cal.getTime();
    }

    public static final Date addDays(Date target, int days) {
        long msPerDay = 86400000L;
        long msTarget = target.getTime();
        long msSum = msTarget + msPerDay * (long)days;
        Date result = new Date();
        result.setTime(msSum);
        return result;
    }

    public static int dayDiff(Date first, Date second) {
        long msPerDay = 86400000L;
        long diff = first.getTime() / msPerDay - second.getTime() / msPerDay;
        Long convertLong = new Long(diff);
        return convertLong.intValue();
    }

    public static int getYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int calendarMonth = cal.get(2);
        return DateHelper.calendarMonthToInt(calendarMonth);
    }

    public static int getDOW(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getHour(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinute(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(12);
    }

    public static int getSecond(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(13);
    }

    private static int calendarMonthToInt(int calendarMonth) {
        if (calendarMonth == 0) {
            return 1;
        }
        if (calendarMonth == 1) {
            return 2;
        }
        if (calendarMonth == 2) {
            return 3;
        }
        if (calendarMonth == 3) {
            return 4;
        }
        if (calendarMonth == 4) {
            return 5;
        }
        if (calendarMonth == 5) {
            return 6;
        }
        if (calendarMonth == 6) {
            return 7;
        }
        if (calendarMonth == 7) {
            return 8;
        }
        if (calendarMonth == 8) {
            return 9;
        }
        if (calendarMonth == 9) {
            return 10;
        }
        if (calendarMonth == 10) {
            return 11;
        }
        if (calendarMonth == 11) {
            return 12;
        }
        return 1;
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    public static String format(Calendar cal, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(DateHelper.calendarToDate(cal));
    }

    private static int intToCalendarMonth(int month) {
        if (month == 1) {
            return 0;
        }
        if (month == 2) {
            return 1;
        }
        if (month == 3) {
            return 2;
        }
        if (month == 4) {
            return 3;
        }
        if (month == 5) {
            return 4;
        }
        if (month == 6) {
            return 5;
        }
        if (month == 7) {
            return 6;
        }
        if (month == 8) {
            return 7;
        }
        if (month == 9) {
            return 8;
        }
        if (month == 10) {
            return 9;
        }
        if (month == 11) {
            return 10;
        }
        if (month == 12) {
            return 11;
        }
        return 0;
    }

    public static Calendar dateToCalendar(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal;
    }

    public static Date calendarToDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.getTime();
    }

    public static java.sql.Date calendarToSqlDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return new java.sql.Date(cal.getTime().getTime());
    }

    public static java.sql.Date dateToSqlDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static Date sqlDateToDate(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public static Date getCurrentDate() {
        int yy = DateHelper.getYear(DateHelper.getCurrentDateTime());
        int mm = DateHelper.getMonth(DateHelper.getCurrentDateTime());
        int dd = DateHelper.getDay(DateHelper.getCurrentDateTime());
        return DateHelper.getDate(yy, mm, dd);
    }

    public static String getCurrentDate(String format) {
        return DateHelper.format(DateHelper.getCurrentDate(), format);
    }

    public static Date getCurrentDateTime() {
        return Calendar.getInstance().getTime();
    }

    public static java.sql.Date getCurrentSqlDate() {
        return new java.sql.Date(Calendar.getInstance().getTime().getTime());
    }

    public static final java.sql.Date getSqlDate(int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar(year, DateHelper.intToCalendarMonth(month), day);
        return new java.sql.Date(cal.getTime().getTime());
    }

    public static Calendar sqlDateToCalendar(java.sql.Date fecha) {
        if (fecha == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTime(new Date(fecha.getTime()));
        return result;
    }

    public static int getSqlYear(java.sql.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getSqlMonth(java.sql.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int calendarMonth = cal.get(2);
        return DateHelper.calendarMonthToInt(calendarMonth);
    }

    public static int getSqlDay(java.sql.Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static String calendarToString(Calendar cal) {
        String resu = "";
        int dia = cal.get(5);
        int mes = cal.get(2) + 1;
        int anio = cal.get(1);
        resu = (dia < 10 ? "0" : "") + dia + "/" + (mes < 10 ? "0" : "") + mes + "/" + anio;
        return resu;
    }

    public static String getPeriodo(Calendar periodo) {
        Date date = DateHelper.calendarToDate(periodo);
        return DateHelper.getPeriodo(date);
    }

    public static String getPeriodo(java.sql.Date periodo) {
        Date date = DateHelper.sqlDateToDate(periodo);
        return DateHelper.getPeriodo(date);
    }

    public static String getPeriodo(Date periodo) {
        int month = DateHelper.getMonth(periodo);
        int year = DateHelper.getYear(periodo);
        String sPeriodo = (month < 10 ? "0" : "") + month + "/" + year;
        return sPeriodo;
    }

    public static String dtos(Date date) {
        int yyyy = DateHelper.getYear(date);
        int mm = DateHelper.getMonth(date);
        int dd = DateHelper.getDay(date);
        int hh = DateHelper.getHour(date);
        int mi = DateHelper.getMinute(date);
        int ss = DateHelper.getSecond(date);
        return yyyy < 100 ? "20" + yyyy : "" + yyyy + (mm < 10 ? "0" + mm : "" + mm) + (dd < 10 ? "0" + dd : "" + dd) + (hh < 10 ? "0" + hh : "" + hh) + (mi < 10 ? "0" + mi : "" + mi) + (ss < 10 ? "0" + ss : "" + ss);
    }

    public static String toScreenableString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        String texto = sdf.format(date);
        return texto;
    }
}

