/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.security;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.odbogm.annotations.Entity;
import net.odbogm.security.GroupSID;
import net.odbogm.security.ISecurityCredentials;
import net.odbogm.security.SID;

@Entity
public class UserSID
extends SID
implements ISecurityCredentials {
    private static final Logger LOGGER = Logger.getLogger(UserSID.class.getName());
    private List<GroupSID> groups;

    public UserSID() {
    }

    public UserSID(String name, String uuid) {
        super(name, uuid);
    }

    public void addGroup(GroupSID gsid) {
        if (this.groups == null) {
            this.groups = new ArrayList<GroupSID>();
        }
        if (!this.groups.contains(gsid)) {
            this.groups.add(gsid);
        }
        gsid.add(this);
    }

    public void removeGroup(GroupSID gsid) {
        if (this.groups != null) {
            this.groups.remove(gsid);
            gsid.remove(this);
        }
    }

    @Override
    public List<String> showSecurityCredentials() {
        return this.groups.stream().map(gid -> gid.getUUID()).collect(Collectors.toList());
    }

    public List<GroupSID> getGroups() {
        return this.groups.stream().map(gid -> gid).collect(Collectors.toList());
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

