/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.security;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.annotations.Entity;
import net.odbogm.security.AccessRight;
import net.odbogm.security.GroupSID;
import net.odbogm.security.ISecurityCredentials;
import net.odbogm.security.SID;
import net.odbogm.security.UserSID;

@Entity
public abstract class SObject {
    private static final Logger LOGGER = Logger.getLogger(SObject.class.getName());
    private SID __owner;
    private Map<String, Integer> __acl = new HashMap<String, Integer>();
    private int __state = 0;
    private SObject __inherit = null;

    public SObject() {
    }

    public SObject(UserSID owner) {
        this.__owner = owner;
    }

    public SObject(GroupSID owner) {
        this.__owner = owner;
    }

    final void setState(int s) {
        this.__state = s;
    }

    final int getState() {
        return this.__state;
    }

    public final SObject setAcl(GroupSID sid, AccessRight ar) {
        this.__acl.put(sid.getUUID(), ar.getRights());
        return this;
    }

    public final SObject setAcl(UserSID sid, AccessRight ar) {
        this.__acl.put(sid.getUUID(), ar.getRights());
        return this;
    }

    public final void removeAcl(GroupSID sid) {
        if (this.__acl != null) {
            this.__acl.remove(sid.getUUID());
        }
    }

    public final void removeAcl(UserSID sid) {
        if (this.__acl != null) {
            this.__acl.remove(sid.getUUID());
        }
    }

    public final SObject setOwner(UserSID o) {
        this.__owner = o;
        return this;
    }

    public final SID getOwner() {
        return this.__owner;
    }

    public final int validate(ISecurityCredentials sc) {
        LOGGER.log(Level.FINER, "validando los permisos de acceso...");
        int partialState = 0;
        int gal = 0;
        HashMap<String, Integer> acls = this.getAcls();
        LOGGER.log(Level.FINER, "Lista de acls: " + acls.size());
        if (acls.size() != 0) {
            for (String securityCredential : sc.showSecurityCredentials()) {
                gal = acls.get(securityCredential);
                LOGGER.log(Level.FINER, "SecurityCredential: " + securityCredential + " " + gal);
                if (gal == 0) {
                    partialState = 0;
                    break;
                }
                partialState |= gal;
            }
        } else {
            partialState = Integer.MAX_VALUE;
        }
        this.__state = partialState;
        return this.__state;
    }

    public final int getSecurityState() {
        return this.__state;
    }

    public final HashMap<String, Integer> getAcls() {
        HashMap<String, Integer> acls = new HashMap<String, Integer>();
        if (this.__inherit != null) {
            acls.putAll(this.__inherit.getAcls());
        }
        acls.putAll(this.__acl);
        return acls;
    }

    public final void setInheritFrom(SObject so) {
        this.__inherit = so;
    }

    static {
        LOGGER.setLevel(LogginProperties.SObject);
    }
}

