/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.security;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.odbogm.annotations.Entity;
import net.odbogm.security.SID;

@Entity
public class GroupSID
extends SID {
    private static final Logger LOGGER = Logger.getLogger(GroupSID.class.getName());
    private List<SID> participants;

    public GroupSID() {
    }

    public GroupSID(String name, String uuid) {
        super(name, uuid);
    }

    public final void add(SID user) {
        if (this.participants == null) {
            this.participants = new ArrayList<SID>();
        }
        this.participants.add(user);
    }

    public final void remove(SID user) {
        this.participants.remove(user);
    }

    public final List<SID> getParticipants() {
        return this.participants.stream().map(sid -> sid).collect(Collectors.toList());
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

