/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.proxy;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.odbogm.LogginProperties;
import net.odbogm.Transaction;
import net.odbogm.proxy.ILazyCollectionCalls;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.proxy.ObjectCollectionState;

public class VectorLazyProxy
extends Vector
implements ILazyCollectionCalls {
    private static final Logger LOGGER = Logger.getLogger(VectorLazyProxy.class.getName());
    private boolean dirty = false;
    private boolean lazyLoad = true;
    private boolean lazyLoading = false;
    private Transaction transaction;
    private OrientVertex relatedTo;
    private String field;
    private Class<?> fieldClass;
    private WeakReference<IObjectProxy> parent;
    private Map<Object, ObjectCollectionState> listState = new ConcurrentHashMap<Object, ObjectCollectionState>();

    @Override
    public void init(Transaction t, OrientVertex relatedTo, IObjectProxy parent, String field, Class<?> c) {
        try {
            this.transaction = t;
            this.relatedTo = relatedTo;
            this.parent = new WeakReference<IObjectProxy>(parent);
            this.field = field;
            this.fieldClass = c;
            LOGGER.log(Level.FINER, "relatedTo: {0} - field: {1} - Class: {2}", new Object[]{relatedTo, field, c.getSimpleName()});
            LOGGER.log(Level.FINER, "relatedTo.getGraph : " + relatedTo.getGraph());
        }
        catch (Exception ex) {
            Logger.getLogger(VectorLazyProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void lazyLoad() {
        this.transaction.getSessionManager().getGraphdb().getRawGraph().activateOnCurrentThread();
        LOGGER.log(Level.FINER, "getGraph: " + this.relatedTo.getGraph());
        if (this.relatedTo.getGraph() == null) {
            this.transaction.getSessionManager().getGraphdb().attach((OrientElement)this.relatedTo);
        }
        LOGGER.log(Level.FINER, "getRawGraph: " + this.relatedTo.getGraph().getRawGraph());
        this.relatedTo.getGraph().getRawGraph().activateOnCurrentThread();
        this.lazyLoad = false;
        this.lazyLoading = true;
        LOGGER.log(Level.FINER, "relatedTo: {0} - field: {1} - Class: {2}", new Object[]{this.relatedTo, this.field, this.fieldClass.getSimpleName()});
        Iterable rt = this.relatedTo.getVertices(Direction.OUT, new String[]{this.field});
        for (OrientVertex next : rt) {
            Object o = this.transaction.get(this.fieldClass, next.getId().toString());
            this.add(o);
            this.listState.put(o, ObjectCollectionState.REMOVED);
        }
        this.lazyLoading = false;
    }

    @Override
    public Map<Object, ObjectCollectionState> collectionState() {
        if (!this.lazyLoad) {
            for (Object o : this) {
                if (this.listState.get(o) == null) {
                    this.listState.put(o, ObjectCollectionState.ADDED);
                    continue;
                }
                this.listState.remove(o);
            }
        }
        return this.listState;
    }

    @Override
    public void clearState() {
        this.dirty = false;
        this.listState.clear();
        for (Object o : this) {
            if (this.listState.get(o) != null) continue;
            this.listState.put(o, ObjectCollectionState.REMOVED);
        }
    }

    private void setDirty() {
        LOGGER.log(Level.FINER, "Colecci\u00f3n marcada como Dirty. Avisar al padre.");
        this.dirty = true;
        LOGGER.log(Level.FINER, "weak:" + this.parent.get());
        if (this.parent.get() != null) {
            ((IObjectProxy)this.parent.get()).___setDirty();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void rollback() {
        this.clear();
        this.listState.clear();
        this.dirty = false;
        this.lazyLoad = true;
    }

    public VectorLazyProxy(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public VectorLazyProxy(int initialCapacity) {
        super(initialCapacity);
    }

    public VectorLazyProxy() {
    }

    @Override
    public Spliterator spliterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.spliterator();
    }

    @Override
    public synchronized void sort(Comparator c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.sort(c);
    }

    @Override
    public synchronized void replaceAll(UnaryOperator operator) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.replaceAll(operator);
    }

    @Override
    public synchronized boolean removeIf(Predicate filter) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeIf(filter);
    }

    @Override
    public synchronized void forEach(Consumer action) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.forEach(action);
    }

    @Override
    public synchronized Iterator iterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.iterator();
    }

    @Override
    public synchronized ListIterator listIterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.listIterator();
    }

    @Override
    public synchronized ListIterator listIterator(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.listIterator(index);
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public synchronized List subList(int fromIndex, int toIndex) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public synchronized String toString() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toString();
    }

    @Override
    public synchronized int hashCode() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.hashCode();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.equals(o);
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.addAll(index, c);
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.retainAll(c);
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.addAll(c);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.containsAll(c);
    }

    @Override
    public void clear() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.clear();
    }

    @Override
    public synchronized Object remove(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.remove(index);
    }

    @Override
    public void add(int index, Object element) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.add(index, element);
    }

    @Override
    public boolean remove(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.remove(o);
    }

    @Override
    public synchronized boolean add(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            this.setDirty();
        }
        return super.add(e);
    }

    @Override
    public synchronized Object set(int index, Object element) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.set(index, element);
    }

    @Override
    public synchronized Object get(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.get(index);
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toArray(a);
    }

    @Override
    public synchronized Object[] toArray() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toArray();
    }

    @Override
    public synchronized Object clone() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.clone();
    }

    @Override
    public synchronized void removeAllElements() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.removeAllElements();
    }

    @Override
    public synchronized boolean removeElement(Object obj) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeElement(obj);
    }

    public synchronized void addElement(Object obj) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.addElement(obj);
    }

    public synchronized void insertElementAt(Object obj, int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.insertElementAt(obj, index);
    }

    @Override
    public synchronized void removeElementAt(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.removeElementAt(index);
    }

    public synchronized void setElementAt(Object obj, int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.setElementAt(obj, index);
    }

    public synchronized Object lastElement() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.lastElement();
    }

    public synchronized Object firstElement() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.firstElement();
    }

    public synchronized Object elementAt(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.elementAt(index);
    }

    @Override
    public synchronized int lastIndexOf(Object o, int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.lastIndexOf(o, index);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.lastIndexOf(o);
    }

    @Override
    public synchronized int indexOf(Object o, int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.indexOf(o, index);
    }

    @Override
    public int indexOf(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.indexOf(o);
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    public Enumeration elements() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.elements();
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.isEmpty();
    }

    @Override
    public synchronized int size() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.size();
    }

    @Override
    public synchronized int capacity() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.capacity();
    }

    @Override
    public synchronized void setSize(int newSize) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.setSize(newSize);
    }

    @Override
    public synchronized void ensureCapacity(int minCapacity) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized void trimToSize() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.trimToSize();
    }

    @Override
    public synchronized void copyInto(Object[] anArray) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.copyInto(anArray);
    }

    @Override
    public Stream parallelStream() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.parallelStream();
    }

    @Override
    public Stream stream() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.stream();
    }

    protected void finalize() throws Throwable {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.finalize();
    }

    static {
        LOGGER.setLevel(LogginProperties.VectorLazyProxy);
    }
}

