/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.proxy;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.odbogm.Transaction;
import net.odbogm.proxy.ILazyCollectionCalls;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.proxy.ObjectCollectionState;

public class LinkedListLazyProxy
extends LinkedList
implements ILazyCollectionCalls {
    private static final Logger LOGGER = Logger.getLogger(LinkedListLazyProxy.class.getName());
    private boolean dirty = false;
    private boolean lazyLoad = true;
    private boolean lazyLoading = false;
    private Transaction transaction;
    private OrientVertex relatedTo;
    private String field;
    private Class<?> fieldClass;
    private WeakReference<IObjectProxy> parent;
    private Map<Object, ObjectCollectionState> listState = new ConcurrentHashMap<Object, ObjectCollectionState>();

    @Override
    public void init(Transaction t, OrientVertex relatedTo, IObjectProxy parent, String field, Class<?> c) {
        try {
            this.transaction = t;
            this.relatedTo = relatedTo;
            this.parent = new WeakReference<IObjectProxy>(parent);
            this.field = field;
            this.fieldClass = c;
            LOGGER.log(Level.FINER, "relatedTo: {0} - field: {1} - Class: {2}", new Object[]{relatedTo, field, c.getSimpleName()});
            LOGGER.log(Level.FINER, "relatedTo.getGraph : " + relatedTo.getGraph());
        }
        catch (Exception ex) {
            Logger.getLogger(LinkedListLazyProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void lazyLoad() {
        this.transaction.getSessionManager().getGraphdb().getRawGraph().activateOnCurrentThread();
        LOGGER.log(Level.FINER, "getGraph: " + this.relatedTo.getGraph());
        if (this.relatedTo.getGraph() == null) {
            this.transaction.getSessionManager().getGraphdb().attach((OrientElement)this.relatedTo);
        }
        LOGGER.log(Level.FINER, "getRawGraph: " + this.relatedTo.getGraph().getRawGraph());
        this.relatedTo.getGraph().getRawGraph().activateOnCurrentThread();
        this.lazyLoad = false;
        this.lazyLoading = true;
        LOGGER.log(Level.FINER, "relatedTo: {0} - field: {1} - Class: {2}", new Object[]{this.relatedTo, this.field, this.fieldClass.getSimpleName()});
        Iterable rt = this.relatedTo.getVertices(Direction.OUT, new String[]{this.field});
        for (OrientVertex next : rt) {
            Object o = this.transaction.get(this.fieldClass, next.getId().toString());
            this.add(o);
            this.listState.put(o, ObjectCollectionState.REMOVED);
        }
        this.lazyLoading = false;
    }

    @Override
    public Map<Object, ObjectCollectionState> collectionState() {
        if (!this.lazyLoad) {
            for (Object o : this) {
                if (this.listState.get(o) == null) {
                    this.listState.put(o, ObjectCollectionState.ADDED);
                    continue;
                }
                this.listState.remove(o);
            }
        }
        return this.listState;
    }

    @Override
    public void clearState() {
        this.dirty = false;
        this.listState.clear();
        for (Object o : this) {
            if (this.listState.get(o) != null) continue;
            this.listState.put(o, ObjectCollectionState.REMOVED);
        }
    }

    private void setDirty() {
        LOGGER.log(Level.FINER, "Colecci\u00f3n marcada como Dirty. Avisar al padre.");
        this.dirty = true;
        LOGGER.log(Level.FINER, "weak:" + this.parent.get());
        if (this.parent.get() != null) {
            ((IObjectProxy)this.parent.get()).___setDirty();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void rollback() {
        this.clear();
        this.listState.clear();
        this.dirty = false;
        this.lazyLoad = true;
    }

    @Override
    public Spliterator spliterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.spliterator();
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toArray(a);
    }

    @Override
    public Object[] toArray() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toArray();
    }

    @Override
    public Object clone() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.clone();
    }

    @Override
    public Iterator descendingIterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.descendingIterator();
    }

    @Override
    public ListIterator listIterator(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.listIterator(index);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeLastOccurrence(o);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeFirstOccurrence(o);
    }

    @Override
    public Object pop() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.pop();
    }

    @Override
    public void push(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.push(e);
    }

    @Override
    public Object pollLast() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.pollLast();
    }

    @Override
    public Object pollFirst() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.pollFirst();
    }

    @Override
    public Object peekLast() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.peekLast();
    }

    @Override
    public Object peekFirst() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.peekFirst();
    }

    @Override
    public boolean offerLast(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.offerLast(e);
    }

    @Override
    public boolean offerFirst(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.offerFirst(e);
    }

    @Override
    public boolean offer(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.offer(e);
    }

    @Override
    public Object remove() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.remove();
    }

    @Override
    public Object poll() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.poll();
    }

    @Override
    public Object element() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.element();
    }

    @Override
    public Object peek() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.peek();
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.lastIndexOf(o);
    }

    @Override
    public int indexOf(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.indexOf(o);
    }

    @Override
    public Object remove(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.remove(index);
    }

    @Override
    public void add(int index, Object element) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.add(index, element);
    }

    @Override
    public Object set(int index, Object element) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.set(index, element);
    }

    @Override
    public Object get(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.get(index);
    }

    @Override
    public void clear() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.clear();
    }

    @Override
    public boolean addAll(int index, Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.addAll(c);
    }

    @Override
    public boolean remove(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.remove(o);
    }

    @Override
    public boolean add(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            this.setDirty();
        }
        return super.add(e);
    }

    @Override
    public int size() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.size();
    }

    @Override
    public boolean contains(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.contains(o);
    }

    @Override
    public void addLast(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.addLast(e);
    }

    @Override
    public void addFirst(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.addFirst(e);
    }

    @Override
    public Object removeLast() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeLast();
    }

    @Override
    public Object removeFirst() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeFirst();
    }

    @Override
    public Object getLast() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.getLast();
    }

    @Override
    public Object getFirst() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.getFirst();
    }

    @Override
    public Iterator iterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.iterator();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.equals(o);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public ListIterator listIterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.listIterator();
    }

    @Override
    public void sort(Comparator c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.sort(c);
    }

    @Override
    public void replaceAll(UnaryOperator operator) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.replaceAll(operator);
    }

    @Override
    public String toString() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toString();
    }

    @Override
    public boolean retainAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeAll(c);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.isEmpty();
    }

    @Override
    public Stream parallelStream() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.parallelStream();
    }

    @Override
    public Stream stream() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.stream();
    }

    @Override
    public boolean removeIf(Predicate filter) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.removeIf(filter);
    }

    @Override
    public void forEach(Consumer action) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.forEach(action);
    }

    protected void finalize() throws Throwable {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.finalize();
    }
}

