/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.proxy;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.Primitives;
import net.odbogm.Transaction;
import net.odbogm.proxy.ILazyMapCalls;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.proxy.ObjectCollectionState;

public class HashMapLazyProxy
extends HashMap<Object, Object>
implements ILazyMapCalls {
    private static final Logger LOGGER = Logger.getLogger(HashMapLazyProxy.class.getName());
    private boolean dirty = false;
    private boolean lazyLoad = true;
    private boolean lazyLoading = false;
    private Transaction transaction;
    private OrientVertex relatedTo;
    private String field;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private WeakReference<IObjectProxy> parent;
    private Map<Object, ObjectCollectionState> entitiesState = new ConcurrentHashMap<Object, ObjectCollectionState>();
    private Map<Object, ObjectCollectionState> keyState = new ConcurrentHashMap<Object, ObjectCollectionState>();
    private Map<Object, OrientEdge> keyToEdge = new ConcurrentHashMap<Object, OrientEdge>();

    @Override
    public void init(Transaction t, OrientVertex relatedTo, IObjectProxy parent, String field, Class<?> k, Class<?> v) {
        this.transaction = t;
        this.relatedTo = relatedTo;
        this.parent = new WeakReference<IObjectProxy>(parent);
        this.field = field;
        this.keyClass = k;
        this.valueClass = v;
    }

    private void lazyLoad() {
        this.lazyLoad = false;
        this.lazyLoading = true;
        for (OrientVertex next : this.relatedTo.getVertices(Direction.OUT, new String[]{this.field})) {
            Object o = this.transaction.get(this.valueClass, next.getId().toString());
            for (Edge edge : this.relatedTo.getEdges(next, Direction.OUT, new String[]{this.field})) {
                OrientEdge oe = (OrientEdge)edge;
                Object k = null;
                LOGGER.log(Level.FINER, "edge keyclass: " + this.keyClass + "  OE RID:" + oe.getId().toString());
                if (Primitives.PRIMITIVE_MAP.containsKey(this.keyClass)) {
                    LOGGER.log(Level.FINER, "primitive!!");
                    for (String prop : oe.getPropertyKeys()) {
                        k = oe.getProperty(prop);
                    }
                } else {
                    LOGGER.log(Level.FINER, "clase como key");
                    k = this.transaction.getEdgeAsObject(this.keyClass, oe);
                }
                this.put(k, o);
                this.keyState.put(k, ObjectCollectionState.REMOVED);
                this.keyToEdge.put(k, oe);
            }
            if (this.entitiesState.get(o) != null) continue;
            this.entitiesState.put(o, ObjectCollectionState.REMOVED);
        }
        this.lazyLoading = false;
    }

    @Override
    public void clearState() {
        this.entitiesState.clear();
        this.keyState.clear();
        ConcurrentHashMap<Object, OrientEdge> newOE = new ConcurrentHashMap<Object, OrientEdge>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            Object k = entry.getKey();
            Object o = entry.getValue();
            this.keyState.put(k, ObjectCollectionState.REMOVED);
            if (this.keyToEdge.get(k) != null) {
                newOE.put(k, this.keyToEdge.get(k));
            }
            if (this.entitiesState.get(o) != null) continue;
            this.entitiesState.put(o, ObjectCollectionState.REMOVED);
        }
        this.keyToEdge = newOE;
        this.dirty = false;
    }

    @Override
    public Map<Object, ObjectCollectionState> collectionState() {
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.keyState.get(key) == null) {
                this.keyState.put(key, ObjectCollectionState.ADDED);
            } else {
                this.keyState.replace(key, ObjectCollectionState.NOCHANGE);
            }
            if (this.entitiesState.get(value) == null) {
                this.entitiesState.put(value, ObjectCollectionState.ADDED);
                continue;
            }
            this.entitiesState.replace(value, ObjectCollectionState.NOCHANGE);
        }
        return this.keyState;
    }

    @Override
    public Map<Object, ObjectCollectionState> getEntitiesState() {
        return this.entitiesState;
    }

    @Override
    public Map<Object, ObjectCollectionState> getKeyState() {
        return this.keyState;
    }

    @Override
    public Map<Object, OrientEdge> getKeyToEdge() {
        return this.keyToEdge;
    }

    private void setDirty() {
        LOGGER.log(Level.FINER, "Colecci\u00f3n marcada como Dirty. Avisar al padre.");
        this.dirty = true;
        LOGGER.log(Level.FINER, "weak:" + this.parent.get());
        if (this.parent.get() != null) {
            ((IObjectProxy)this.parent.get()).___setDirty();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void rollback() {
        this.clear();
        this.entitiesState.clear();
        this.keyToEdge.clear();
        this.keyState.clear();
        this.dirty = false;
        this.lazyLoad = true;
    }

    public HashMapLazyProxy() {
    }

    public HashMapLazyProxy(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public HashMapLazyProxy(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Object clone() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.clone();
    }

    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            this.setDirty();
        }
        super.replaceAll(function);
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.forEach(action);
    }

    @Override
    public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            this.setDirty();
        }
        return super.merge(key, value, remappingFunction);
    }

    @Override
    public Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.compute(key, remappingFunction);
    }

    @Override
    public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object replace(Object key, Object value) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            this.setDirty();
        }
        return super.replace(key, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            this.setDirty();
        }
        return super.replace(key, oldValue, newValue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            this.setDirty();
        }
        return super.remove(key, value);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        Object res;
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if ((res = super.putIfAbsent(key, value)) != null) {
            this.setDirty();
        }
        return res;
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.entrySet();
    }

    @Override
    public Collection<Object> values() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.values();
    }

    @Override
    public Set<Object> keySet() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.keySet();
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.containsValue(value);
    }

    @Override
    public void clear() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.clear();
    }

    @Override
    public Object remove(Object key) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.remove(key);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.putAll(m);
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.get(key);
    }

    @Override
    public boolean isEmpty() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.isEmpty();
    }

    @Override
    public int size() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.size();
    }

    @Override
    public String toString() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toString();
    }

    @Override
    public int hashCode() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.equals(o);
    }

    protected void finalize() throws Throwable {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.finalize();
    }

    static {
        LOGGER.setLevel(LogginProperties.HashMapLazyProxy);
    }
}

