/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.proxy;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.proxy.IEmbeddedCalls;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.utils.ThreadHelper;

public class HashMapEmbeddedProxy
extends HashMap<Object, Object>
implements IEmbeddedCalls {
    private static final Logger LOGGER = Logger.getLogger(HashMapEmbeddedProxy.class.getName());
    private boolean dirty = false;
    private WeakReference<IObjectProxy> parent;

    @Override
    public void init(IObjectProxy parent) {
        this.parent = new WeakReference<IObjectProxy>(parent);
    }

    private synchronized void setDirty() {
        LOGGER.log(Level.FINER, "Colecci\u00f3n marcada como Dirty. Avisar al padre.");
        LOGGER.log(Level.FINER, "weak:" + this.parent.get());
        if (this.parent.get() != null) {
            ((IObjectProxy)this.parent.get()).___setDirty();
            LOGGER.log(Level.FINER, ThreadHelper.getCurrentStackTrace());
        }
    }

    public HashMapEmbeddedProxy() {
    }

    public HashMapEmbeddedProxy(IObjectProxy parent) {
        this.init(parent);
    }

    public HashMapEmbeddedProxy(IObjectProxy parent, Map source) {
        super(source);
        this.init(parent);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        this.setDirty();
        super.replaceAll(function);
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        super.forEach(action);
    }

    @Override
    public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        this.setDirty();
        return super.merge(key, value, remappingFunction);
    }

    @Override
    public Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return super.compute(key, remappingFunction);
    }

    @Override
    public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return super.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object replace(Object key, Object value) {
        this.setDirty();
        return super.replace(key, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        this.setDirty();
        return super.replace(key, oldValue, newValue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.setDirty();
        return super.remove(key, value);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        Object res = super.putIfAbsent(key, value);
        if (res != null) {
            this.setDirty();
        }
        return res;
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Collection<Object> values() {
        return super.values();
    }

    @Override
    public Set<Object> keySet() {
        return super.keySet();
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public void clear() {
        this.setDirty();
        super.clear();
    }

    @Override
    public Object remove(Object key) {
        this.setDirty();
        return super.remove(key);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        this.setDirty();
        super.putAll(m);
    }

    @Override
    public Object put(Object key, Object value) {
        this.setDirty();
        return super.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return super.get(key);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    static {
        LOGGER.setLevel(LogginProperties.HashMapEmbeddedProxy);
    }
}

