/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.proxy;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.odbogm.LogginProperties;
import net.odbogm.Transaction;
import net.odbogm.exceptions.RelatedToNullException;
import net.odbogm.proxy.ILazyCollectionCalls;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.proxy.ObjectCollectionState;
import net.odbogm.utils.ThreadHelper;

public class ArrayListLazyProxy
extends ArrayList
implements ILazyCollectionCalls {
    private static final long serialVersionUID = -3396834078126983330L;
    private static final Logger LOGGER = Logger.getLogger(ArrayListLazyProxy.class.getName());
    private boolean dirty = false;
    private boolean lazyLoad = true;
    private boolean lazyLoading = false;
    private Transaction transaction;
    private OrientVertex relatedTo;
    private String field;
    private Class<?> fieldClass;
    private WeakReference<IObjectProxy> parent;
    private Map<Object, ObjectCollectionState> listState = new ConcurrentHashMap<Object, ObjectCollectionState>();

    @Override
    public synchronized void init(Transaction t, OrientVertex relatedTo, IObjectProxy parent, String field, Class<?> c) {
        try {
            if (relatedTo == null) {
                throw new RelatedToNullException("Se ha detectado un ArraylistLazyProxy sin relaci\u00f3n con un v\u00e9rtice!\n field: " + field + " Class: " + c.getSimpleName());
            }
            this.transaction = t;
            this.relatedTo = relatedTo;
            this.parent = new WeakReference<IObjectProxy>(parent);
            this.field = field;
            this.fieldClass = c;
            LOGGER.log(Level.FINER, "relatedTo: {0} - field: {1} - Class: {2}", new Object[]{relatedTo, field, c.getSimpleName()});
            LOGGER.log(Level.FINER, "relatedTo.getGraph : " + relatedTo.getGraph());
        }
        catch (Exception ex) {
            Logger.getLogger(ArrayListLazyProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private synchronized void lazyLoad() {
        this.transaction.getSessionManager().getGraphdb().getRawGraph().activateOnCurrentThread();
        LOGGER.log(Level.FINER, "getGraph: " + this.relatedTo.getGraph());
        if (this.relatedTo.getGraph() == null) {
            this.transaction.getSessionManager().getGraphdb().attach((OrientElement)this.relatedTo);
        }
        this.lazyLoad = false;
        this.lazyLoading = true;
        LOGGER.log(Level.FINER, "relatedTo: {0} - field: {1} - Class: {2}", new Object[]{this.relatedTo, this.field, this.fieldClass.getSimpleName()});
        Iterable rt = this.relatedTo.getVertices(Direction.OUT, new String[]{this.field});
        for (OrientVertex next : rt) {
            Object o = this.transaction.get(this.fieldClass, next.getId().toString());
            this.add(o);
            this.listState.put(o, ObjectCollectionState.REMOVED);
        }
        this.lazyLoading = false;
    }

    @Override
    public synchronized Map<Object, ObjectCollectionState> collectionState() {
        if (!this.lazyLoad) {
            for (Object o : this) {
                if (this.listState.get(o) == null) {
                    this.listState.put(o, ObjectCollectionState.ADDED);
                    continue;
                }
                this.listState.remove(o);
            }
        }
        return this.listState;
    }

    @Override
    public synchronized void clearState() {
        this.dirty = false;
        this.listState.clear();
        for (Object o : this) {
            if (this.listState.get(o) != null) continue;
            this.listState.put(o, ObjectCollectionState.REMOVED);
        }
    }

    private synchronized void setDirty() {
        LOGGER.log(Level.FINER, "Colecci\u00f3n marcada como Dirty. Avisar al padre.");
        this.dirty = true;
        LOGGER.log(Level.FINER, "weak:" + this.parent.get());
        if (this.parent.get() != null) {
            ((IObjectProxy)this.parent.get()).___setDirty();
            LOGGER.log(Level.FINER, ThreadHelper.getCurrentStackTrace());
        }
    }

    @Override
    public synchronized boolean isDirty() {
        return this.dirty;
    }

    @Override
    public synchronized void rollback() {
        this.clear();
        this.listState.clear();
        this.dirty = false;
        this.lazyLoad = true;
    }

    @Override
    public int hashCode() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toString();
    }

    @Override
    public boolean containsAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.containsAll(c);
    }

    @Override
    public Stream parallelStream() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.parallelStream();
    }

    @Override
    public Stream stream() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.stream();
    }

    protected void finalize() throws Throwable {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.finalize();
    }

    @Override
    public void sort(Comparator c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.sort(c);
    }

    @Override
    public void replaceAll(UnaryOperator operator) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.replaceAll(operator);
    }

    @Override
    public boolean removeIf(Predicate filter) {
        boolean removed;
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (removed = super.removeIf(filter)) {
            this.setDirty();
        }
        return removed;
    }

    @Override
    public Spliterator spliterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.spliterator();
    }

    @Override
    public void forEach(Consumer action) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.forEach(action);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public Iterator iterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.iterator();
    }

    @Override
    public ListIterator listIterator() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.listIterator();
    }

    @Override
    public ListIterator listIterator(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.listIterator(index);
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean changeDetected;
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (changeDetected = super.retainAll(c)) {
            this.setDirty();
        }
        return changeDetected;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changeDetected;
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (changeDetected = super.removeAll(c)) {
            this.setDirty();
        }
        return changeDetected;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection c) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.addAll(c);
    }

    @Override
    public void clear() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.clear();
    }

    @Override
    public boolean remove(Object o) {
        boolean changeDetected;
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (changeDetected = super.remove(o)) {
            this.setDirty();
        }
        return changeDetected;
    }

    @Override
    public Object remove(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.remove(index);
    }

    @Override
    public void add(int index, Object element) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.add(index, element);
    }

    @Override
    public boolean add(Object e) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        if (!this.lazyLoading) {
            LOGGER.log(Level.FINER, "DIRTY: Elemento nuevo agregado: " + e.toString());
            this.setDirty();
        }
        return super.add(e);
    }

    @Override
    public Object set(int index, Object element) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        return super.set(index, element);
    }

    @Override
    public Object get(int index) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.get(index);
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toArray(a);
    }

    @Override
    public Object[] toArray() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.toArray();
    }

    @Override
    public Object clone() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.clone();
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.lastIndexOf(o);
    }

    @Override
    public int indexOf(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.indexOf(o);
    }

    @Override
    public boolean contains(Object o) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.contains(o);
    }

    @Override
    public boolean isEmpty() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.isEmpty();
    }

    @Override
    public int size() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        return super.size();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        super.ensureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        if (this.lazyLoad) {
            this.lazyLoad();
        }
        this.setDirty();
        super.trimToSize();
    }

    static {
        LOGGER.setLevel(LogginProperties.ArrayListLazyProxy);
    }
}

