/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.proxy;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.proxy.IEmbeddedCalls;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.utils.ThreadHelper;

public class ArrayListEmbeddedProxy
extends ArrayList
implements IEmbeddedCalls {
    private static final long serialVersionUID = 3136116168236143774L;
    private static final Logger LOGGER = Logger.getLogger(ArrayListEmbeddedProxy.class.getName());
    private WeakReference<IObjectProxy> parent;

    @Override
    public synchronized void init(IObjectProxy parent) {
        try {
            this.parent = new WeakReference<IObjectProxy>(parent);
        }
        catch (Exception ex) {
            Logger.getLogger(ArrayListEmbeddedProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private synchronized void setDirty() {
        LOGGER.log(Level.FINER, "Colecci\u00f3n marcada como Dirty. Avisar al padre.");
        LOGGER.log(Level.FINER, "weak:" + this.parent.get());
        if (this.parent.get() != null) {
            ((IObjectProxy)this.parent.get()).___setDirty();
            LOGGER.log(Level.FINER, ThreadHelper.getCurrentStackTrace());
        }
    }

    public ArrayListEmbeddedProxy() {
    }

    public ArrayListEmbeddedProxy(IObjectProxy parent) {
        this.init(parent);
    }

    public ArrayListEmbeddedProxy(IObjectProxy parent, List l) {
        super(l);
        this.init(parent);
    }

    @Override
    public void replaceAll(UnaryOperator operator) {
        this.setDirty();
        super.replaceAll(operator);
    }

    @Override
    public boolean removeIf(Predicate filter) {
        boolean removed = super.removeIf(filter);
        if (removed) {
            this.setDirty();
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean changeDetected = super.retainAll(c);
        if (changeDetected) {
            this.setDirty();
        }
        return changeDetected;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changeDetected = super.removeAll(c);
        if (changeDetected) {
            this.setDirty();
        }
        return changeDetected;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.setDirty();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        this.setDirty();
        return super.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection c) {
        this.setDirty();
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.setDirty();
        super.clear();
    }

    @Override
    public boolean remove(Object o) {
        boolean changeDetected = super.remove(o);
        if (changeDetected) {
            this.setDirty();
        }
        return changeDetected;
    }

    @Override
    public Object remove(int index) {
        this.setDirty();
        return super.remove(index);
    }

    @Override
    public void add(int index, Object element) {
        this.setDirty();
        super.add(index, element);
    }

    @Override
    public boolean add(Object e) {
        LOGGER.log(Level.FINER, "DIRTY: Elemento nuevo agregado: " + e.toString());
        this.setDirty();
        return super.add(e);
    }

    @Override
    public Object set(int index, Object element) {
        this.setDirty();
        return super.set(index, element);
    }

    @Override
    public void trimToSize() {
        this.setDirty();
        super.trimToSize();
    }

    static {
        LOGGER.setLevel(LogginProperties.ArrayListEmbeddedProxy);
    }
}

