/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.ObjectMapper;
import net.odbogm.Primitives;
import net.odbogm.annotations.Embedded;
import net.odbogm.annotations.Ignore;
import net.odbogm.cache.ClassDef;

public class ClassCache {
    private static final Logger LOGGER = Logger.getLogger(ClassCache.class.getName());
    private final HashMap<Class<?>, ClassDef> classCache = new HashMap();

    public ClassDef get(Class<?> c) {
        LOGGER.log(Level.FINER, "Procesando clase: {0}", c.getName());
        ClassDef cached = this.classCache.get(c);
        if (cached == null) {
            LOGGER.log(Level.FINER, "Nueva clase detectada. Analizando...");
            cached = this.cacheClass(c);
            this.classCache.put(c, cached);
        }
        LOGGER.log(Level.FINER, "Class struc:");
        LOGGER.log(Level.FINER, "Class: " + c.getName());
        LOGGER.log(Level.FINER, "Fields: " + cached.fields.size());
        LOGGER.log(Level.FINER, "enums: " + cached.enumFields.size());
        LOGGER.log(Level.FINER, "Links: " + cached.links.size());
        LOGGER.log(Level.FINER, "LinkList: " + cached.linkLists.size());
        LOGGER.log(Level.FINER, "-------------------------------------");
        return cached;
    }

    private ClassDef cacheClass(Class<?> c) {
        ClassDef classdef = new ClassDef();
        this.cacheClass(c, classdef);
        return classdef;
    }

    private void cacheClass(Class<?> c, ClassDef cached) {
        if (c != Object.class) {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                try {
                    if (!(f.isAnnotationPresent(Ignore.class) || Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()))) {
                        boolean acc = f.isAccessible();
                        f.setAccessible(true);
                        LOGGER.log(Level.FINER, "Field: " + f.getName() + "  Type: " + f.getType() + (f.getType().isEnum() ? "<<<<<<<<<<< ENUM" : ""));
                        if (Primitives.PRIMITIVE_MAP.get(f.getType()) != null) {
                            cached.fields.put(f.getName(), f.getType());
                        } else if (f.getType().isEnum()) {
                            cached.enumFields.put(f.getName(), f.getType());
                        } else if (Primitives.LAZY_COLLECTION.get(f.getType()) != null) {
                            ParameterizedType listType;
                            LOGGER.log(Level.FINER, "Colecci\u00f3n detectada: " + f.getName());
                            boolean setAsEmbedded = false;
                            if (List.class.isAssignableFrom(f.getType())) {
                                LOGGER.log(Level.FINER, "se trata de una Lista...");
                                listType = (ParameterizedType)f.getGenericType();
                                Class listClass = (Class)listType.getActualTypeArguments()[0];
                                if (Primitives.PRIMITIVE_MAP.get(listClass) != null || f.isAnnotationPresent(Embedded.class)) {
                                    LOGGER.log(Level.FINER, "\n**********************************************************");
                                    LOGGER.log(Level.FINER, "Es una colecci\u00f3n de primitivas: " + listClass.getSimpleName());
                                    LOGGER.log(Level.FINER, "Se procede a embeberla.");
                                    LOGGER.log(Level.FINER, "\n**********************************************************");
                                    setAsEmbedded = true;
                                }
                            } else if (Map.class.isAssignableFrom(f.getType())) {
                                LOGGER.log(Level.FINER, "se trata de un Map...");
                                listType = (ParameterizedType)f.getGenericType();
                                Class keyClass = (Class)listType.getActualTypeArguments()[0];
                                Class valClass = (Class)listType.getActualTypeArguments()[1];
                                if (keyClass == String.class && (Primitives.PRIMITIVE_MAP.get(valClass) != null || f.isAnnotationPresent(Embedded.class))) {
                                    LOGGER.log(Level.FINER, "Es una colecci\u00f3n de embebida: " + valClass.getSimpleName());
                                    setAsEmbedded = true;
                                }
                            }
                            if (setAsEmbedded) {
                                cached.fields.put(f.getName(), f.getType());
                                cached.embeddedFields.put(f.getName(), f.getType());
                            } else {
                                LOGGER.log(Level.FINER, "Es una colecci\u00f3n de objetos que genera V\u00e9rtices y Ejes.");
                                cached.linkLists.put(f.getName(), f.getType());
                            }
                        } else {
                            cached.links.put(f.getName(), f.getType());
                        }
                        f.setAccessible(acc);
                        continue;
                    }
                    if (f.isAnnotationPresent(Ignore.class)) continue;
                    LOGGER.log(Level.WARNING, "Ignorado: {0}", f.getName());
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.cacheClass(c.getSuperclass(), cached);
        }
    }

    static {
        LOGGER.setLevel(LogginProperties.ClassCache);
    }
}

