/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.auditory;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.Transaction;
import net.odbogm.annotations.Audit;
import net.odbogm.auditory.IAuditor;
import net.odbogm.auditory.LogData;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.utils.DateHelper;

public class Auditor
implements IAuditor {
    private static final Logger LOGGER = Logger.getLogger(Auditor.class.getName());
    private Transaction transaction;
    private String auditUser;
    private ArrayList<LogData> logdata = new ArrayList();
    private final String ODBAUDITLOGVERTEXCLASS = "ODBAuditLog";

    public Auditor(Transaction t, String user) {
        this.transaction = t;
        this.auditUser = user;
        if (this.transaction.getDBClass(this.ODBAUDITLOGVERTEXCLASS) == null) {
            OrientVertexType olog = this.transaction.getGraphdb().createVertexType(this.ODBAUDITLOGVERTEXCLASS);
            olog.createProperty("rid", OType.STRING);
            olog.createProperty("timestamp", OType.DATETIME);
            olog.createProperty("user", OType.STRING);
            olog.createProperty("action", OType.STRING);
            olog.createProperty("label", OType.STRING);
            olog.createProperty("log", OType.STRING);
            this.transaction.commit();
        }
    }

    @Override
    public synchronized void auditLog(IObjectProxy o, int at, String label, Object data) {
        if (o.___getBaseClass().isAnnotationPresent(Audit.class)) {
            int logVal = o.___getBaseClass().getAnnotation(Audit.class).log();
            if ((logVal & at) > 0) {
                this.logdata.add(new LogData(o, at, label, data));
                LOGGER.log(Level.FINER, "objeto auditado");
            } else {
                LOGGER.log(Level.FINER, "No corresponde auditar");
            }
        } else {
            LOGGER.log(Level.FINER, "No auditado: " + o.___getBaseClass().getSimpleName());
        }
    }

    @Override
    public void commit() {
        String ovLogID = UUID.randomUUID().toString();
        for (LogData logData : this.logdata) {
            LOGGER.log(Level.FINER, "valid: " + logData.o.___isValid() + " : " + logData.rid);
            HashMap<String, Object> ologData = new HashMap<String, Object>();
            ologData.put("transactionID", ovLogID);
            ologData.put("rid", logData.o.___isValid() & !logData.o.___isDeleted() ? logData.o.___getRid() : logData.rid);
            ologData.put("timestamp", DateHelper.getCurrentDateTime());
            ologData.put("user", this.auditUser);
            ologData.put("action", logData.auditType);
            ologData.put("label", logData.label);
            ologData.put("log", logData.data.toString());
            OrientVertex orientVertex = this.transaction.getGraphdb().addVertex((Object)("class:" + this.ODBAUDITLOGVERTEXCLASS), new Object[]{ologData});
        }
        this.logdata.clear();
    }

    static {
        LOGGER.setLevel(LogginProperties.Auditor);
    }
}

