/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.agent.ITransparentDirtyDetectorDef;
import net.odbogm.agent.TransparentDirtyDetectorAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class TransparentDirtyDetectorInstrumentator
implements ClassFileTransformer,
ITransparentDirtyDetectorDef {
    private static final Logger LOGGER = Logger.getLogger(TransparentDirtyDetectorInstrumentator.class.getName());

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        LOGGER.log(Level.FINEST, "preprocesando clase: {0}...", className);
        ClassReader cr = new ClassReader(classfileBuffer);
        if (this.isInterface(cr)) {
            LOGGER.log(Level.FINER, "Interface detectada {0}. NO PROCESAR!", className);
            return classfileBuffer;
        }
        ClassWriter cw = new ClassWriter(cr, 2);
        TransparentDirtyDetectorAdapter taa = new TransparentDirtyDetectorAdapter((ClassVisitor)cw);
        cr.accept((ClassVisitor)taa, 0);
        if (taa.isInstrumentable()) {
            LOGGER.log(Level.FINER, "Redefiniendo on-the-fly {0}...", className);
            MethodVisitor mv = cw.visitMethod(1, "___ogm___isDirty", "()Z", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "__ogm__dirtyMark", "Z");
            mv.visitInsn(172);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(1, "___ogm___setDirty", "(Z)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(21, 1);
            mv.visitFieldInsn(181, className, "__ogm__dirtyMark", "Z");
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            if (LogginProperties.TransparentDirtyDetectorInstrumentator == Level.FINER) {
                this.writeToFile(className, cw.toByteArray());
            }
            return cw.toByteArray();
        }
        return classfileBuffer;
    }

    private void writeToFile(String className, byte[] myByteArray) {
        try {
            File theDir = new File("/tmp/asm");
            if (!theDir.exists()) {
                theDir.mkdir();
            }
            FileOutputStream fos = new FileOutputStream("/tmp/asm/" + className.substring(className.lastIndexOf("/")) + ".class");
            fos.write(myByteArray);
            fos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TransparentDirtyDetectorInstrumentator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isInterface(ClassReader cr) {
        return (cr.getAccess() & 0x200) != 0;
    }

    static {
        LOGGER.setLevel(LogginProperties.TransparentDirtyDetectorInstrumentator);
    }
}

