/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.agent;

import com.ea.agentloader.AgentLoader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.agent.TransparentDirtyDetectorInstrumentator;

public class TransparentDirtyDetectorAgent {
    private static final Logger LOGGER = Logger.getLogger(TransparentDirtyDetectorAgent.class.getName());
    private static Instrumentation instrumentation;
    private static boolean started;

    public static void ensureToolsJar() {
        if (!started) {
            LOGGER.log(Level.INFO, "Attach API not initialized");
        }
    }

    public static void premain(String args, Instrumentation inst) throws Exception {
        LOGGER.log(Level.FINER, "premain method invoked with args: {0} and inst: {1}", new Object[]{args, inst});
        instrumentation = inst;
        instrumentation.addTransformer(new TransparentDirtyDetectorInstrumentator());
    }

    public static void agentmain(String args, Instrumentation inst) throws Exception {
        LOGGER.log(Level.FINER, "agentmain method invoked with args: {0} and inst: {1}", new Object[]{args, inst});
        instrumentation = inst;
        instrumentation.addTransformer(new TransparentDirtyDetectorInstrumentator());
    }

    public static void initialize() {
        if (instrumentation == null) {
            LOGGER.log(Level.INFO, "dynamically loading java agent...");
            try {
                String pathToAgent = TransparentDirtyDetectorAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                LOGGER.log(Level.INFO, "path: " + pathToAgent);
                if (pathToAgent.endsWith(".jar")) {
                    AgentLoader.loadAgent((String)pathToAgent, null);
                } else {
                    AgentLoader.loadAgentClass((String)TransparentDirtyDetectorAgent.class.getName(), null, null, (boolean)true, (boolean)true, (boolean)true);
                }
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(TransparentDirtyDetectorAgent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        LOGGER.setLevel(LogginProperties.TransparentDirtyDetectorAgent);
        try {
            String javaHome = System.getProperty("java.home");
            String toolsJarURL = "file:" + javaHome + "/../lib/tools.jar";
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            if (sysloader.getResourceAsStream("/com/sun/tools/attach/VirtualMachine.class") == null) {
                method.invoke((Object)sysloader, new URL(toolsJarURL));
                Thread.currentThread().getContextClassLoader().loadClass("com.sun.tools.attach.VirtualMachine");
                Thread.currentThread().getContextClassLoader().loadClass("com.sun.tools.attach.AttachNotSupportedException");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Java home points to " + System.getProperty("java.home") + " make sure it is not a JRE path");
            LOGGER.log(Level.INFO, "Failed to add tools.jar to classpath", e);
        }
        started = true;
    }
}

