/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm.agent;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.agent.ITransparentDirtyDetector;
import net.odbogm.agent.ITransparentDirtyDetectorDef;
import net.odbogm.agent.WriteAccessActivatorAdapter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class TransparentDirtyDetectorAdapter
extends ClassVisitor
implements ITransparentDirtyDetectorDef {
    private static final Logger LOGGER = Logger.getLogger(TransparentDirtyDetectorAdapter.class.getName());
    private boolean isFieldPresent = false;
    private boolean isInstrumetable = false;

    public TransparentDirtyDetectorAdapter(ClassVisitor cv) {
        super(262144, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String[] addInterfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
        addInterfaces[addInterfaces.length - 1] = ITransparentDirtyDetector.class.getName().replace(".", "/");
        LOGGER.log(Level.FINER, "visitando clase: " + name + " super: " + superName);
        this.cv.visit(version, access, name, signature, superName, addInterfaces);
    }

    public AnnotationVisitor visitAnnotation(String ann, boolean bln) {
        LOGGER.log(Level.FINER, "Annotation: >" + ann + "<");
        if (ann.startsWith("Lnet/odbogm/annotations/Entity")) {
            LOGGER.log(Level.FINER, ">>>>>>>>>>> marcar como instrumentable");
            this.isInstrumetable = true;
        }
        return super.visitAnnotation(ann, bln);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("__ogm__dirtyMark")) {
            this.isFieldPresent = true;
        }
        return this.cv.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOGGER.log(Level.FINEST, "visitando m\u00e9todo: " + name);
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv != null && !name.equals("<init>") && !name.equals("<clinit>") && this.isInstrumentable()) {
            LOGGER.log(Level.FINER, ">>>>>>>>>>> Instrumentando m\u00e9todo: " + name);
            mv = new WriteAccessActivatorAdapter(mv);
        }
        return mv;
    }

    public void visitEnd() {
        if (!this.isFieldPresent && this.isInstrumentable()) {
            LOGGER.log(Level.FINER, "Agregando el campo");
            FieldVisitor fv = this.cv.visitField(1, "__ogm__dirtyMark", Type.BOOLEAN_TYPE.getDescriptor(), null, null);
            if (fv != null) {
                fv.visitEnd();
                LOGGER.log(Level.FINER, "fv.visitEnd..");
            }
        }
        this.cv.visitEnd();
    }

    public boolean isInstrumentable() {
        return this.isInstrumetable;
    }

    static {
        LOGGER.setLevel(LogginProperties.TransparentDirtyDetectorAdapter);
    }
}

