/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientDynaElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.Actions;
import net.odbogm.LogginProperties;
import net.odbogm.ObjectMapper;
import net.odbogm.ObjectStruct;
import net.odbogm.Primitives;
import net.odbogm.SessionManager;
import net.odbogm.annotations.CascadeDelete;
import net.odbogm.annotations.RemoveOrphan;
import net.odbogm.auditory.Auditor;
import net.odbogm.cache.ClassDef;
import net.odbogm.exceptions.ClassToVertexNotFound;
import net.odbogm.exceptions.CollectionNotSupported;
import net.odbogm.exceptions.IncorrectRIDField;
import net.odbogm.exceptions.NoOpenTx;
import net.odbogm.exceptions.NoUserLoggedIn;
import net.odbogm.exceptions.ReferentialIntegrityViolation;
import net.odbogm.exceptions.UnknownObject;
import net.odbogm.exceptions.UnknownRID;
import net.odbogm.exceptions.UnmanagedObject;
import net.odbogm.exceptions.VertexJavaClassNotFound;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.proxy.ObjectProxyFactory;
import net.odbogm.security.SObject;
import net.odbogm.utils.ReflectionUtils;
import net.odbogm.utils.ThreadHelper;

public class Transaction
implements Actions.Store,
Actions.Get,
Actions.Query {
    private static final Logger LOGGER = Logger.getLogger(Transaction.class.getName());
    private static final long serialVersionUID = 1L;
    private ObjectMapper objectMapper;
    private ConcurrentHashMap<String, WeakReference<Object>> objectCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> dirty = new ConcurrentHashMap();
    private int nestedTransactionLevel = 0;
    private int getTransactionCount = 0;
    ConcurrentHashMap<String, Object> transactionCache = new ConcurrentHashMap();
    List<String> newrids = new ArrayList<String>();
    private boolean commiting = false;
    private ConcurrentHashMap<Object, Object> commitedObject = new ConcurrentHashMap();
    int newObjectCount = 0;
    private Auditor auditor;
    SessionManager sm;
    OrientGraph orientdbTransact;

    Transaction(SessionManager sm) {
        this.sm = sm;
        this.orientdbTransact = this.sm.getFactory().getTx();
        this.objectMapper = this.sm.getObjectMapper();
    }

    public void clear() {
        this.dirty.clear();
    }

    public synchronized void setAsDirty(Object o) throws UnmanagedObject {
        if (!(o instanceof IObjectProxy)) {
            throw new UnmanagedObject();
        }
        String rid = ((IObjectProxy)o).___getVertex().getId().toString();
        LOGGER.log(Level.FINER, "Marcando como dirty: " + o.getClass().getSimpleName() + " - " + o.toString());
        LOGGER.log(Level.FINEST, ThreadHelper.getCurrentStackTrace());
        this.dirty.put(rid, o);
    }

    public synchronized void addToCache(String rid, WeakReference<Object> o) {
        this.objectCache.put(rid, o);
    }

    public synchronized void refreshDirtyObjects() {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        for (Map.Entry<String, Object> e : this.dirty.entrySet()) {
            String rid = e.getKey();
            IObjectProxy o = (IObjectProxy)e.getValue();
            o.___reload();
        }
    }

    public synchronized void refreshObject(IObjectProxy o) {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        o.___reload();
    }

    public OrientGraph getGraphdb() {
        return this.orientdbTransact;
    }

    public synchronized void begin() {
        ++this.nestedTransactionLevel;
    }

    public synchronized void close() {
        this.orientdbTransact.shutdown();
    }

    public synchronized void commit() throws NoOpenTx, OConcurrentModificationException {
        if (this.nestedTransactionLevel == 0) {
            if (this.orientdbTransact == null) {
                throw new NoOpenTx();
            }
            this.commiting = true;
            LOGGER.log(Level.FINER, "Iniciando COMMIT ==================================");
            LOGGER.log(Level.FINER, "Objetos marcados como Dirty: " + this.dirty.size());
            for (Map.Entry<String, Object> e : this.dirty.entrySet()) {
                String rid = e.getKey();
                IObjectProxy o = (IObjectProxy)e.getValue();
                LOGGER.log(Level.FINER, "Commiting: " + rid + "   class: " + o.___getBaseClass() + " isValid: " + o.___isValid());
                o.___commit();
            }
            LOGGER.log(Level.FINER, "Fin persistencia. <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            LOGGER.log(Level.FINER, "llamando al commit de la base");
            this.orientdbTransact.commit();
            LOGGER.log(Level.FINER, "finalizado.");
            if (this.isAuditing()) {
                LOGGER.log(Level.FINER, "grabando auditor\u00eda...");
                this.getAuditor().commit();
                this.orientdbTransact.commit();
                LOGGER.log(Level.FINER, "finalizado.");
            }
            this.dirty.clear();
            this.commiting = false;
            this.commitedObject.clear();
            this.objectCache.clear();
            this.newrids.clear();
        } else {
            --this.nestedTransactionLevel;
        }
        LOGGER.log(Level.FINER, "FIN DE COMMIT! ----------------------------");
    }

    public synchronized void rollback() {
        LOGGER.log(Level.FINER, "Rollback ------------------------");
        LOGGER.log(Level.FINER, "Dirty objects: " + this.dirty.size());
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        this.orientdbTransact.rollback();
        for (Map.Entry<String, Object> entry : this.dirty.entrySet()) {
            String key = entry.getKey();
            IObjectProxy value = (IObjectProxy)entry.getValue();
            value.___rollback();
        }
        this.objectCache.clear();
        this.dirty.clear();
        this.nestedTransactionLevel = 0;
        LOGGER.log(Level.FINER, "FIN ROLLBACK.");
    }

    public int getTransactionLevel() {
        return this.nestedTransactionLevel;
    }

    @Override
    public synchronized <T> T store(T o) throws IncorrectRIDField, NoOpenTx, ClassToVertexNotFound {
        Object proxied = null;
        try {
            if (this.orientdbTransact == null) {
                throw new NoOpenTx();
            }
            String classname = o instanceof IObjectProxy ? o.getClass().getSuperclass().getSimpleName() : o.getClass().getSimpleName();
            LOGGER.log(Level.FINER, "STORE: guardando objeto de la clase " + classname);
            ClassDef oClassDef = this.sm.getObjectMapper().getClassDef(o);
            ObjectStruct oStruct = this.objectMapper.objectStruct(o);
            HashMap<String, Object> omap = oStruct.fields;
            if (this.sm.getDBClass(classname) == null) {
                throw new ClassToVertexNotFound("No se ha encontrado la definici\u00f3n de la clase " + classname + " en la base!");
            }
            final OrientVertex v = this.orientdbTransact.addVertex((Object)("class:" + classname), new Object[]{omap});
            proxied = ObjectProxyFactory.create(o, (OrientElement)v, this);
            this.newrids.add(v.getId().toString());
            ReflectionUtils.copyObject(o, proxied);
            this.sm.getObjectMapper().collectionsToEmbedded(proxied, oClassDef, this);
            if (this.isAuditing()) {
                this.auditLog((IObjectProxy)proxied, 2, "STORE", omap);
            }
            LOGGER.log(Level.FINER, "Marcando como dirty: " + proxied.getClass().getSimpleName());
            this.dirty.put(v.getId().toString(), proxied);
            this.commitedObject.put(o, proxied);
            LOGGER.log(Level.FINER, "Procesando los Links");
            for (Map.Entry<String, Object> link : oStruct.links.entrySet()) {
                String field = link.getKey();
                String graphRelationName = classname + "_" + field;
                Object innerO = this.commitedObject.get(link.getValue());
                if (innerO == null) {
                    LOGGER.log(Level.FINER, field + ": No existe el objeto en el cache de objetos creados.");
                    innerO = link.getValue();
                }
                if (!(innerO instanceof IObjectProxy)) {
                    LOGGER.log(Level.FINER, "innerO nuevo. Crear un v\u00e9rtice y un link");
                    innerO = this.store(innerO);
                    ObjectMapper.setFieldValue(proxied, field, innerO);
                } else {
                    ObjectMapper.setFieldValue(proxied, field, innerO);
                }
                OrientEdge oe = this.orientdbTransact.addEdge((Object)("class:" + graphRelationName), (Vertex)v, (Vertex)((IObjectProxy)innerO).___getVertex(), graphRelationName);
                if (!this.isAuditing()) continue;
                this.auditLog((IObjectProxy)proxied, 2, "STORE: " + graphRelationName, oe);
            }
            LOGGER.log(Level.FINER, "Procesando los LinkList");
            LOGGER.log(Level.FINER, "LinkLists: " + oStruct.linkLists.size());
            final Object finalProxied = proxied;
            for (Map.Entry<String, Object> link : oStruct.linkLists.entrySet()) {
                String field = link.getKey();
                Object value = link.getValue();
                final String graphRelationName = classname + "_" + field;
                LOGGER.log(Level.FINER, "field: " + field + " clase: " + value.getClass().getName());
                if (value instanceof List) {
                    Collection innerCol = (Collection)value;
                    LOGGER.log(Level.FINER, "Nueva lista: " + graphRelationName + ": " + innerCol.size() + " elementos");
                    for (Object llObject : innerCol) {
                        IObjectProxy ioproxied;
                        Object llO = this.commitedObject.get(llObject);
                        if (llO == null) {
                            llO = llObject;
                        }
                        if (!(llO instanceof IObjectProxy)) {
                            LOGGER.log(Level.FINER, "llObject nuevo. Crear un v\u00e9rtice y un link");
                            ioproxied = (IObjectProxy)this.store(llO);
                        } else {
                            ioproxied = (IObjectProxy)llO;
                        }
                        LOGGER.log(Level.FINE, "-----> agregando un edge a: " + ioproxied.___getVertex().getId());
                        OrientEdge oe = this.orientdbTransact.addEdge((Object)("class:" + graphRelationName), (Vertex)v, (Vertex)ioproxied.___getVertex(), graphRelationName);
                        if (!this.isAuditing()) continue;
                        this.auditLog((IObjectProxy)proxied, 2, "STORE: " + graphRelationName, oe);
                    }
                } else if (value instanceof Map) {
                    HashMap innerMap = (HashMap)value;
                    innerMap.forEach(new BiConsumer(){

                        public void accept(Object imk, Object imV) {
                            IObjectProxy ioproxied;
                            Object imO = Transaction.this.commitedObject.get(imV);
                            if (imO == null) {
                                imO = imV;
                            }
                            if (imO instanceof IObjectProxy) {
                                ioproxied = (IObjectProxy)imO;
                            } else {
                                LOGGER.log(Level.FINER, "Link Map Object nuevo. Crear un v\u00e9rtice y un link");
                                ioproxied = (IObjectProxy)Transaction.this.store(imO);
                            }
                            LOGGER.log(Level.FINER, "-----> agregando el edges de " + v.getId().toString() + " para " + ioproxied.___getVertex().toString() + " key: " + imk);
                            OrientEdge oe = Transaction.this.orientdbTransact.addEdge((Object)("class:" + graphRelationName), (Vertex)v, (Vertex)ioproxied.___getVertex(), graphRelationName);
                            if (Transaction.this.isAuditing()) {
                                Transaction.this.auditLog((IObjectProxy)finalProxied, 2, "STORE: " + graphRelationName, oe);
                            }
                            if (Primitives.PRIMITIVE_MAP.get(imk.getClass()) != null) {
                                LOGGER.log(Level.FINER, "la prop del edge es primitiva");
                                oe.setProperty("key", imk);
                            } else {
                                LOGGER.log(Level.FINER, "la prop del edge es un Objeto. Se debe mapear!! ");
                                oe.setProperties(new Object[]{Transaction.this.sm.getObjectMapper().simpleMap(imk)});
                            }
                        }
                    });
                }
                this.sm.getObjectMapper().colecctionToLazy(proxied, field, v, this);
            }
            this.objectCache.put(v.getId().toString(), new WeakReference<Object>(proxied));
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        LOGGER.log(Level.FINER, "FIN del Store ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        return (T)proxied;
    }

    public void delete(Object toRemove) throws ReferentialIntegrityViolation, UnknownObject {
        LOGGER.log(Level.FINER, "Remove: " + toRemove.getClass().getName());
        if (toRemove instanceof IObjectProxy) {
            Field f;
            String field;
            OrientVertex ovToRemove = ((IObjectProxy)toRemove).___getVertex();
            ovToRemove.reload();
            LOGGER.log(Level.FINER, "Referencias IN: " + ovToRemove.countEdges(Direction.IN, new String[0]));
            if (ovToRemove.countEdges(Direction.IN, new String[0]) > 0L) {
                throw new ReferentialIntegrityViolation();
            }
            ovToRemove.remove();
            ClassDef classDef = this.objectMapper.getClassDef(toRemove);
            ArrayList vertexToRemove = new ArrayList();
            for (Map.Entry<String, Class<?>> entry : classDef.links.entrySet()) {
                try {
                    Object value;
                    field = entry.getKey();
                    f = ReflectionUtils.findField(toRemove.getClass(), field);
                    if (f.isAnnotationPresent(CascadeDelete.class)) {
                        value = f.get(toRemove);
                        if (value == null) continue;
                        this.delete(value);
                        continue;
                    }
                    if (!f.isAnnotationPresent(RemoveOrphan.class) || (value = f.get(toRemove)) == null) continue;
                    try {
                        this.delete(value);
                    }
                    catch (ReferentialIntegrityViolation riv) {
                        LOGGER.log(Level.FINER, "RemoveOrphan: El objeto a\u00fan tiene v\u00ednculos.");
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            for (Map.Entry<String, Class<?>> entry : classDef.linkLists.entrySet()) {
                try {
                    Object oMapCol;
                    field = entry.getKey();
                    String graphRelationName = toRemove.getClass().getSimpleName() + "_" + field;
                    Class<?> fieldClass = entry.getValue();
                    f = ReflectionUtils.findField(toRemove.getClass(), field);
                    boolean acc = f.isAccessible();
                    f.setAccessible(true);
                    LOGGER.log(Level.FINER, "procesando campo: " + field);
                    Collection oCol = (Collection)f.get(toRemove);
                    if (oCol != null && f.isAnnotationPresent(CascadeDelete.class)) {
                        if (oCol instanceof List) {
                            for (Object object : oCol) {
                                this.delete(object);
                            }
                        } else if (oCol instanceof Map) {
                            oMapCol = (HashMap)((Object)oCol);
                            ((HashMap)oMapCol).forEach((k, v) -> this.delete(v));
                        } else {
                            LOGGER.log(Level.FINER, "********************************************");
                            LOGGER.log(Level.FINER, "field: {0}", field);
                            LOGGER.log(Level.FINER, "********************************************");
                            throw new CollectionNotSupported(oCol.getClass().getSimpleName());
                        }
                        f.setAccessible(acc);
                        continue;
                    }
                    if (oCol == null || !f.isAnnotationPresent(RemoveOrphan.class)) continue;
                    if (oCol instanceof List) {
                        for (Object object : oCol) {
                            try {
                                this.delete(object);
                            }
                            catch (ReferentialIntegrityViolation riv) {
                                LOGGER.log(Level.FINER, "RemoveOrphan: El objeto a\u00fan tiene v\u00ednculos.");
                            }
                        }
                    } else if (oCol instanceof Map) {
                        oMapCol = (HashMap)((Object)oCol);
                        ((HashMap)oMapCol).forEach((k, v) -> {
                            try {
                                this.delete(v);
                            }
                            catch (ReferentialIntegrityViolation riv) {
                                LOGGER.log(Level.FINER, "RemoveOrphan: El objeto a\u00fan tiene v\u00ednculos.");
                            }
                        });
                    } else {
                        LOGGER.log(Level.FINER, "********************************************");
                        LOGGER.log(Level.FINER, "field: {0}", field);
                        LOGGER.log(Level.FINER, "********************************************");
                        throw new CollectionNotSupported(oCol.getClass().getSimpleName());
                    }
                    f.setAccessible(acc);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
                    Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.isAuditing()) {
                this.auditLog((IObjectProxy)toRemove, 4, "DELETE", "");
            }
        } else {
            throw new UnknownObject();
        }
        this.dirty.remove(((IObjectProxy)toRemove).___getVertex().getId().toString());
        ((IObjectProxy)toRemove).___setDeletedMark();
    }

    public synchronized void flush() {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        for (Map.Entry<String, Object> e : this.dirty.entrySet()) {
            String rid = e.getKey();
            IObjectProxy o = (IObjectProxy)e.getValue();
            o.___commit();
        }
    }

    public SessionManager getSessionManager() {
        return this.sm;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void addToTransactionCache(String rid, Object o) {
        ++this.getTransactionCount;
        if (this.transactionCache.get(rid) == null) {
            LOGGER.log(Level.FINER, "Forzando el agregado al TransactionCache de " + rid);
            this.transactionCache.put(rid, o);
        }
    }

    public void decreseTransactionCache() {
        --this.getTransactionCount;
        if (this.getTransactionCount == 0) {
            this.transactionCache.clear();
        }
    }

    public int getDirtyCount() {
        return this.dirty.size();
    }

    @Override
    public Object get(String rid) throws UnknownRID, VertexJavaClassNotFound {
        try {
            if (this.orientdbTransact == null) {
                throw new NoOpenTx();
            }
            if (rid == null) {
                throw new UnknownRID();
            }
            Object ret = null;
            if (this.objectCache.get(rid) != null && !((IObjectProxy)(ret = this.objectCache.get(rid).get())).___isDirty()) {
                ((IObjectProxy)ret).___reload();
            }
            if (ret == null) {
                this.objectCache.remove(rid);
                OrientVertex v = this.orientdbTransact.getVertex((Object)rid);
                if (v == null) {
                    throw new UnknownRID(rid);
                }
                String javaClass = v.getType().getCustom("javaClass");
                if (javaClass == null) {
                    throw new VertexJavaClassNotFound("La clase del V\u00e9rtice no tiene la propiedad javaClass");
                }
                javaClass = javaClass.replaceAll("['\"]", "");
                Class<?> c = Class.forName(javaClass);
                ret = this.get(c, rid);
            } else {
                LOGGER.log(Level.FINER, "Objeto Recupeardo del cach\u00e9.");
                if (this.sm.getLoggedInUser() != null && ret instanceof SObject) {
                    ((SObject)ret).validate(this.sm.getLoggedInUser());
                }
            }
            return ret;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public <T> T get(Class<T> type, String rid) throws UnknownRID {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        if (rid == null) {
            throw new UnknownRID();
        }
        Object o = null;
        if (this.objectCache.get(rid) != null) {
            if (this.objectCache.get(rid).get() != null) {
                LOGGER.log(Level.FINER, "Objeto Recupeardo del cach\u00e9.");
                o = this.objectCache.get(rid).get();
                if (!((IObjectProxy)o).___isDirty()) {
                    ((IObjectProxy)o).___reload();
                }
            } else {
                this.objectCache.remove(rid);
            }
        }
        if (o == null) {
            ++this.getTransactionCount;
            LOGGER.log(Level.FINER, "Obteniendo objeto type: " + type.getSimpleName() + " en RID: " + rid);
            o = this.transactionCache.get(rid);
            if (o == null) {
                OrientVertex v = this.orientdbTransact.getVertex((Object)rid);
                try {
                    o = this.objectMapper.hydrate(type, v, this);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchFieldException ex) {
                    Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                LOGGER.log(Level.FINER, "Objeto recuperado del dirty cache! : " + o.getClass().getSimpleName());
            }
            --this.getTransactionCount;
            if (this.getTransactionCount == 0) {
                LOGGER.log(Level.FINER, "Fin de la transacci\u00f3n. Reseteando el cache.....................");
                this.transactionCache.clear();
            }
            this.objectCache.put(rid, new WeakReference<Object>(o));
        }
        if (this.sm.getLoggedInUser() != null && o instanceof SObject) {
            LOGGER.log(Level.FINER, "SObject detectado. Aplicando seguridad de acuerdo al usuario logueado: " + this.sm.getLoggedInUser().getName());
            ((SObject)o).validate(this.sm.getLoggedInUser());
        }
        if (this.isAuditing()) {
            this.auditLog((IObjectProxy)o, 1, "READ", "");
        }
        LOGGER.log(Level.FINER, "Fin get -------------------------------------\n");
        return (T)o;
    }

    @Override
    public <T> T getEdgeAsObject(Class<T> type, OrientEdge e) {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        T o = null;
        try {
            o = this.objectMapper.hydrate(type, e, this);
            if (this.sm.getLoggedInUser() != null && o instanceof SObject) {
                ((SObject)o).validate(this.sm.getLoggedInUser());
            }
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(SessionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return o;
    }

    @Override
    public <T> T query(String sql) {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        this.flush();
        OCommandSQL osql = new OCommandSQL(sql);
        return (T)this.orientdbTransact.command((OCommandRequest)osql).execute(new Object[0]);
    }

    @Override
    public <T> T query(String sql, Object ... param) {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        this.flush();
        OCommandSQL osql = new OCommandSQL(sql);
        return (T)this.orientdbTransact.command((OCommandRequest)osql).execute(param);
    }

    @Override
    public long query(String sql, String retVal) {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        this.flush();
        OCommandSQL osql = new OCommandSQL(sql);
        OrientVertex ov = (OrientVertex)((OrientDynaElementIterable)this.orientdbTransact.command((OCommandRequest)osql).execute(new Object[0])).iterator().next();
        if (retVal.isEmpty()) {
            retVal = (String)ov.getProperties().keySet().iterator().next();
        }
        return (Long)ov.getProperty(retVal);
    }

    @Override
    public <T> List<T> query(Class<T> clazz) {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        this.flush();
        long init = System.currentTimeMillis();
        ArrayList<T> ret = new ArrayList<T>();
        Iterable vertices = this.orientdbTransact.getVerticesOfClass(clazz.getSimpleName());
        LOGGER.log(Level.FINER, "Enlapsed ODB response: " + (System.currentTimeMillis() - init));
        for (Vertex verticesOfClas : vertices) {
            ret.add(this.get(clazz, verticesOfClas.getId().toString()));
        }
        LOGGER.log(Level.FINER, "Enlapsed time query to List: " + (System.currentTimeMillis() - init));
        return ret;
    }

    @Override
    public <T> List<T> query(Class<T> clase, String body) {
        if (this.orientdbTransact == null) {
            throw new NoOpenTx();
        }
        this.flush();
        ArrayList<T> ret = new ArrayList<T>();
        String cSQL = "SELECT FROM " + clase.getSimpleName() + " " + body;
        LOGGER.log(Level.FINER, cSQL);
        for (Vertex v : (Iterable)this.orientdbTransact.command((OCommandRequest)new OCommandSQL(cSQL)).execute(new Object[0])) {
            ret.add(this.get(clase, v.getId().toString()));
        }
        return ret;
    }

    @Override
    public <T> List<T> query(Class<T> clase, String sql, Object ... param) {
        OSQLSynchQuery query = new OSQLSynchQuery(sql);
        ArrayList<T> ret = new ArrayList<T>();
        LOGGER.log(Level.FINER, sql);
        for (Vertex v : (Iterable)this.orientdbTransact.command((OCommandRequest)query).execute(param)) {
            ret.add(this.get(clase, v.getId().toString()));
        }
        return ret;
    }

    public OClass getDBClass(String clase) {
        return this.getGraphdb().getRawGraph().getMetadata().getSchema().getClass(clase);
    }

    public void setAuditOnUser(String user) {
        this.auditor = new Auditor(this, user);
    }

    public void setAuditOnUser() throws NoUserLoggedIn {
        if (this.sm.getLoggedInUser() == null) {
            throw new NoUserLoggedIn();
        }
        this.auditor = new Auditor(this, this.sm.getLoggedInUser().getUUID());
    }

    public synchronized void auditLog(IObjectProxy o, int at, String label, Object data) {
        if (this.isAuditing()) {
            this.auditor.auditLog(o, at, label, data);
        }
    }

    public boolean isAuditing() {
        return this.auditor != null;
    }

    Auditor getAuditor() {
        return this.auditor;
    }

    static {
        LOGGER.setLevel(LogginProperties.Transaction);
    }
}

