/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm;

import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.Actions;
import net.odbogm.LogginProperties;
import net.odbogm.ObjectMapper;
import net.odbogm.Transaction;
import net.odbogm.agent.TransparentDirtyDetectorAgent;
import net.odbogm.auditory.Auditor;
import net.odbogm.exceptions.ClassToVertexNotFound;
import net.odbogm.exceptions.IncorrectRIDField;
import net.odbogm.exceptions.NoOpenTx;
import net.odbogm.exceptions.NoUserLoggedIn;
import net.odbogm.exceptions.ReferentialIntegrityViolation;
import net.odbogm.exceptions.UnknownObject;
import net.odbogm.exceptions.UnknownRID;
import net.odbogm.exceptions.UnmanagedObject;
import net.odbogm.exceptions.VertexJavaClassNotFound;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.security.UserSID;

public class SessionManager
implements Actions.Store,
Actions.Get {
    private static final Logger LOGGER = Logger.getLogger(SessionManager.class.getName());
    private OrientGraphFactory factory;
    private ObjectMapper objectMapper;
    private ActivationStrategy activationStrategy = ActivationStrategy.ONMETHODACCESS;
    private List<WeakReference<Transaction>> openTransactionList = new ArrayList<WeakReference<Transaction>>();
    private Transaction publicTransaction;
    private UserSID loggedInUser;

    public SessionManager(String url, String user, String passwd) {
        this.init(url, user, passwd, 1, 10);
    }

    public SessionManager(String url, String user, String passwd, int minPool, int maxPool) {
        this.init(url, user, passwd, minPool, maxPool);
    }

    private void init(String url, String user, String passwd, int minPool, int maxPool) {
        LOGGER.log(Level.INFO, "ODBOGM Session Manager initialization...");
        this.factory = new OrientGraphFactory(url, user, passwd).setupPool(minPool, maxPool);
        this.objectMapper = new ObjectMapper();
    }

    public SessionManager setActivationStrategy(ActivationStrategy as) {
        this.activationStrategy = as;
        if (this.activationStrategy == ActivationStrategy.CLASS_INSTRUMENTATION) {
            TransparentDirtyDetectorAgent.initialize();
        }
        return this;
    }

    public ActivationStrategy getActivationStrategy() {
        return this.activationStrategy;
    }

    OrientGraphFactory getFactory() {
        return this.factory;
    }

    public void begin() {
        if (this.publicTransaction == null) {
            this.publicTransaction = new Transaction(this);
        } else {
            this.publicTransaction.begin();
        }
    }

    public Transaction getTransaction() {
        return new Transaction(this);
    }

    public Transaction getCurrentTransaction() {
        return this.publicTransaction;
    }

    @Override
    public synchronized <T> T store(T o) throws IncorrectRIDField, NoOpenTx, ClassToVertexNotFound {
        return this.publicTransaction.store(o);
    }

    public void delete(Object toRemove) throws ReferentialIntegrityViolation, UnknownObject {
        this.publicTransaction.delete(toRemove);
    }

    public synchronized void setAsDirty(Object o) throws UnmanagedObject {
        this.publicTransaction.setAsDirty(o);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getRID(Object o) {
        if (o != null && o instanceof IObjectProxy) {
            return ((IObjectProxy)o).___getVertex().getId().toString();
        }
        return null;
    }

    public synchronized void commit() throws NoOpenTx, OConcurrentModificationException {
        this.publicTransaction.commit();
    }

    public synchronized void flush() {
        this.publicTransaction.flush();
    }

    public synchronized void refreshDirtyObjects() {
        this.publicTransaction.refreshDirtyObjects();
    }

    public synchronized void refreshObject(IObjectProxy o) {
        this.publicTransaction.refreshObject(o);
    }

    public synchronized void rollback() {
        this.publicTransaction.rollback();
    }

    public void shutdown() {
        for (WeakReference<Transaction> weakReference : this.openTransactionList) {
            Transaction t = (Transaction)weakReference.get();
            if (t == null) continue;
            t.rollback();
            t.close();
        }
        this.factory.close();
        this.publicTransaction.close();
    }

    public void getTxConflics() {
    }

    public OrientGraph getGraphdb() {
        return this.publicTransaction.getGraphdb();
    }

    public int getDirtyCount() {
        return this.publicTransaction.getDirtyCount();
    }

    @Override
    public Object get(String rid) throws UnknownRID, VertexJavaClassNotFound {
        return this.publicTransaction.get(rid);
    }

    @Override
    public <T> T get(Class<T> type, String rid) throws UnknownRID {
        return this.publicTransaction.get(type, rid);
    }

    @Override
    public <T> T getEdgeAsObject(Class<T> type, OrientEdge e) {
        return this.publicTransaction.getEdgeAsObject(type, e);
    }

    public <T> T query(String sql) {
        return this.publicTransaction.query(sql);
    }

    public long query(String sql, String retVal) {
        return this.publicTransaction.query(sql, retVal);
    }

    public <T> T query(String sql, Object ... param) {
        return this.publicTransaction.query(sql, param);
    }

    public <T> List<T> query(Class<T> clazz) {
        return this.publicTransaction.query(clazz);
    }

    public <T> List<T> query(Class<T> clase, String body) {
        return this.publicTransaction.query(clase, body);
    }

    public <T> List<T> query(Class<T> clase, String sql, Object ... param) {
        return this.publicTransaction.query(clase, sql, param);
    }

    public OClass getDBClass(String clase) {
        return this.publicTransaction.getDBClass(clase);
    }

    public void setAuditOnUser(String user) {
        this.publicTransaction.setAuditOnUser(user);
    }

    public void setAuditOnUser() throws NoUserLoggedIn {
        this.publicTransaction.setAuditOnUser();
    }

    public void setLoggedInUser(UserSID usid) {
        this.loggedInUser = usid;
    }

    public void auditLog(IObjectProxy o, int at, String label, Object data) {
        if (this.publicTransaction.isAuditing()) {
            this.publicTransaction.auditLog(o, at, label, data);
        }
    }

    public boolean isAuditing() {
        return this.publicTransaction.isAuditing();
    }

    Auditor getAuditor() {
        return this.publicTransaction.getAuditor();
    }

    public UserSID getLoggedInUser() {
        return this.loggedInUser;
    }

    static {
        LOGGER.setLevel(LogginProperties.SessionManager);
    }

    public static enum ActivationStrategy {
        ONMETHODACCESS,
        CLASS_INSTRUMENTATION;

    }
}

