/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.ObjectStruct;
import net.odbogm.Primitives;
import net.odbogm.Transaction;
import net.odbogm.cache.ClassCache;
import net.odbogm.cache.ClassDef;
import net.odbogm.exceptions.CollectionNotSupported;
import net.odbogm.exceptions.DuplicateClassDefinition;
import net.odbogm.proxy.ArrayListEmbeddedProxy;
import net.odbogm.proxy.HashMapEmbeddedProxy;
import net.odbogm.proxy.ILazyCollectionCalls;
import net.odbogm.proxy.ILazyMapCalls;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.proxy.ObjectProxyFactory;
import net.odbogm.utils.ReflectionUtils;
import org.objenesis.ObjenesisStd;

public class ObjectMapper {
    private static final Logger LOGGER = Logger.getLogger(ObjectMapper.class.getName());
    private ClassCache classCache;
    private HashMap<String, Class> classLoaded = new HashMap();
    private ObjenesisStd objenesis = new ObjenesisStd();

    public ObjectMapper() {
        this.classCache = new ClassCache();
    }

    public ClassDef getClassDef(Object o) {
        if (o instanceof IObjectProxy) {
            return this.classCache.get(((IObjectProxy)o).___getBaseClass());
        }
        return this.classCache.get(o.getClass());
    }

    public Map<String, Object> simpleMap(Object o) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (Primitives.PRIMITIVE_MAP.containsKey(o.getClass())) {
            data.put("key", o);
        } else {
            ClassDef classmap = this.classCache.get(o.getClass());
            this.simpleFastMap(o, classmap, data);
        }
        return data;
    }

    public void simpleFastMap(Object o, ClassDef classmap, HashMap<String, Object> data) {
        classmap.fields.entrySet().stream().forEach(entry -> {
            try {
                String field = (String)entry.getKey();
                Class c = (Class)entry.getValue();
                Field f = ReflectionUtils.findField(o.getClass(), field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                if (f.get(o) != null) {
                    data.put(f.getName(), f.get(o));
                }
                f.setAccessible(acc);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    public ObjectStruct objectStruct(Object o) {
        ObjectStruct oStruct = new ObjectStruct();
        ClassDef classmap = o instanceof IObjectProxy ? this.classCache.get(o.getClass().getSuperclass()) : this.classCache.get(o.getClass());
        this.fastmap(o, classmap, oStruct);
        return oStruct;
    }

    private void fastmap(Object o, ClassDef classmap, ObjectStruct oStruct) {
        classmap.fields.entrySet().stream().forEach(entry -> {
            try {
                String field = (String)entry.getKey();
                Class c = (Class)entry.getValue();
                Field f = ReflectionUtils.findField(o.getClass(), field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                if (f.get(o) != null) {
                    LOGGER.log(Level.FINER, "Field: " + field + " Class: " + c.getSimpleName() + ": " + f.get(o));
                    oStruct.fields.put(f.getName(), f.get(o));
                }
                f.setAccessible(acc);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        classmap.enumFields.entrySet().stream().forEach(entry -> {
            try {
                String field = (String)entry.getKey();
                Class c = (Class)entry.getValue();
                Field f = ReflectionUtils.findField(o.getClass(), field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                if (f.get(o) != null) {
                    oStruct.fields.put(f.getName(), "" + f.get(o));
                }
                f.setAccessible(acc);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        classmap.links.entrySet().stream().forEach(entry -> {
            try {
                String field = (String)entry.getKey();
                Class c = (Class)entry.getValue();
                Field f = ReflectionUtils.findField(o.getClass(), field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                if (f.get(o) != null) {
                    oStruct.links.put(f.getName(), f.get(o));
                }
                f.setAccessible(acc);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        classmap.linkLists.entrySet().stream().forEach(entry -> {
            try {
                String field = (String)entry.getKey();
                Class c = (Class)entry.getValue();
                Field f = ReflectionUtils.findField(o.getClass(), field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                if (f.get(o) != null) {
                    oStruct.linkLists.put(f.getName(), f.get(o));
                }
                f.setAccessible(acc);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    public <T> T hydrate(Class<T> c, OrientVertex v, Transaction t) throws DuplicateClassDefinition, InstantiationException, IllegalAccessException, NoSuchFieldException, CollectionNotSupported {
        boolean acc;
        Field f;
        Class fc;
        Object value;
        Class fieldClazz;
        String prop;
        String vertexClass;
        v.getGraph().getRawGraph().activateOnCurrentThread();
        Class<Object> toHydrate = c;
        String string = vertexClass = v.getType().getName() == "V" ? c.getSimpleName() : v.getType().getName();
        if (!c.getSimpleName().equals(vertexClass)) {
            LOGGER.log(Level.FINER, "Tipos distintos. {0} <> {1}", new Object[]{c.getSimpleName(), vertexClass});
            String javaClass = v.getType().getCustom("javaClass");
            if (javaClass != null) {
                try {
                    javaClass = javaClass.replaceAll("['\"]", "");
                    toHydrate = Class.forName(javaClass);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                throw new InstantiationException("ERROR de Instanciaci\u00f3n! \nEl v\u00e9rtice no coincide con la clase que se est\u00e1 intentando instanciar\ny no tiene definido la propiedad javaClass.");
            }
        }
        T oproxied = ObjectProxyFactory.create(toHydrate, (OrientElement)v, t);
        LOGGER.log(Level.FINER, "**************************************************");
        LOGGER.log(Level.FINER, "Hydratando: {0} - Class: {1}", new Object[]{c.getName(), toHydrate});
        LOGGER.log(Level.FINER, "**************************************************");
        ClassDef classdef = this.classCache.get(toHydrate);
        HashMap<String, Class<?>> fieldmap = classdef.fields;
        for (Map.Entry entry : fieldmap.entrySet()) {
            prop = (String)entry.getKey();
            fieldClazz = (Class)entry.getValue();
            LOGGER.log(Level.FINER, "Buscando campo {0} ....", new String[]{prop});
            value = v.getProperty(prop);
            if (value == null) continue;
            fc = (Class)fieldmap.get(prop);
            f = ReflectionUtils.findField(toHydrate, prop);
            acc = f.isAccessible();
            f.setAccessible(true);
            if (f.getType().isEnum()) {
                LOGGER.log(Level.FINER, "Enum field: " + f.getName() + " type: " + f.getType() + "  value: " + value + "   Enum val: " + Enum.valueOf(f.getType().asSubclass(Enum.class), value.toString()));
                ObjectMapper.setFieldValue(oproxied, prop, Enum.valueOf(f.getType().asSubclass(Enum.class), value.toString()));
            } else if (f.getType().isAssignableFrom(List.class)) {
                LOGGER.log(Level.FINER, "EmbeddedList detectada: realizando una copia del contenido...");
                ObjectMapper.setFieldValue(oproxied, prop, new ArrayListEmbeddedProxy((IObjectProxy)oproxied, (List)value));
            } else if (f.getType().isAssignableFrom(Map.class)) {
                LOGGER.log(Level.FINER, "EmbeddedMap detectado: realizando una copia del contenido...");
                ObjectMapper.setFieldValue(oproxied, prop, new HashMapEmbeddedProxy((IObjectProxy)oproxied, (Map)value));
            } else {
                LOGGER.log(Level.FINER, "hidratado campo: " + prop + "=" + value);
                ObjectMapper.setFieldValue(oproxied, prop, value);
            }
            f.setAccessible(acc);
        }
        t.transactionCache.put(v.getId().toString(), oproxied);
        for (Map.Entry<Object, Object> entry : classdef.enumFields.entrySet()) {
            prop = (String)entry.getKey();
            fieldClazz = (Class)entry.getValue();
            LOGGER.log(Level.FINER, "Buscando campo {0} ....", new String[]{prop});
            value = v.getProperty(prop);
            if (value == null) continue;
            fc = (Class)fieldmap.get(prop);
            f = ReflectionUtils.findField(toHydrate, prop);
            LOGGER.log(Level.FINER, "Enum field: " + f.getName() + " type: " + f.getType() + "  value: " + value + "   Enum val: " + Enum.valueOf(f.getType().asSubclass(Enum.class), value.toString()));
            ObjectMapper.setFieldValue(oproxied, prop, Enum.valueOf(f.getType().asSubclass(Enum.class), value.toString()));
            LOGGER.log(Level.FINER, "hidratado campo: " + prop + "=" + value);
        }
        LOGGER.log(Level.FINER, "preparando las colecciones...");
        for (Map.Entry<Object, Object> entry : classdef.linkLists.entrySet()) {
            try {
                String field = (String)entry.getKey();
                Class fc2 = (Class)entry.getValue();
                LOGGER.log(Level.FINER, "Field: {0}   Class: {1}", new String[]{field, fc2.getName()});
                Field fLink = ReflectionUtils.findField(toHydrate, field);
                String graphRelationName = toHydrate.getSimpleName() + "_" + field;
                acc = fLink.isAccessible();
                fLink.setAccessible(true);
                if (v.countEdges(Direction.OUT, new String[]{graphRelationName}) > 0L || fLink.get(oproxied) != null) {
                    this.colecctionToLazy(oproxied, field, fc2, v, t);
                }
                fLink.setAccessible(acc);
            }
            catch (NoSuchFieldException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        LOGGER.log(Level.FINER, "******************* FIN HYDRATE *******************");
        return oproxied;
    }

    public void colecctionToLazy(Object o, String field, OrientVertex v, Transaction t) {
        LOGGER.log(Level.FINER, "convertir colection a Lazy: " + field);
        ClassDef classdef = o instanceof IObjectProxy ? this.classCache.get(o.getClass().getSuperclass()) : this.classCache.get(o.getClass());
        Class<?> fc = classdef.linkLists.get(field);
        this.colecctionToLazy(o, field, fc, v, t);
    }

    public void colecctionToLazy(Object o, String field, Class<?> fc, OrientVertex v, Transaction t) {
        LOGGER.log(Level.FINER, "***************************************************************");
        LOGGER.log(Level.FINER, "convertir colection a Lazy: " + field + " class: " + fc.getName());
        LOGGER.log(Level.FINER, "***************************************************************");
        try {
            Class<?> c = o instanceof IObjectProxy ? o.getClass().getSuperclass() : o.getClass();
            Field fLink = ReflectionUtils.findField(c, field);
            String graphRelationName = c.getSimpleName() + "_" + field;
            boolean acc = fLink.isAccessible();
            fLink.setAccessible(true);
            Class<?> lazyClass = Primitives.LAZY_COLLECTION.get(fc);
            LOGGER.log(Level.FINER, "lazyClass: " + lazyClass.getName());
            Object col = lazyClass.newInstance();
            if (col instanceof List) {
                ParameterizedType listType = (ParameterizedType)fLink.getGenericType();
                Class listClass = (Class)listType.getActualTypeArguments()[0];
                ((ILazyCollectionCalls)col).init(t, v, (IObjectProxy)o, graphRelationName, listClass);
            } else if (col instanceof Map) {
                ParameterizedType listType = (ParameterizedType)fLink.getGenericType();
                Class keyClass = (Class)listType.getActualTypeArguments()[0];
                Class valClass = (Class)listType.getActualTypeArguments()[1];
                ((ILazyMapCalls)col).init(t, v, (IObjectProxy)o, graphRelationName, keyClass, valClass);
            } else {
                throw new CollectionNotSupported();
            }
            fLink.set(o, col);
            fLink.setAccessible(acc);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void collectionsToEmbedded(Object o, ClassDef classDef, Transaction t) {
        for (Map.Entry<String, Class<?>> entry : classDef.embeddedFields.entrySet()) {
            try {
                String field = entry.getKey();
                Class<Object> value = entry.getValue();
                Class<?> c = o instanceof IObjectProxy ? o.getClass().getSuperclass() : o.getClass();
                LOGGER.log(Level.FINER, "Procesando campo: {0} type: {1}", new String[]{field, value.getName()});
                Field f = ReflectionUtils.findField(c, field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                if (f.get(o) != null) {
                    if (value.isAssignableFrom(List.class)) {
                        LOGGER.log(Level.FINER, "convirtiendo en ArrayListEmbeddedProxy...");
                        f.set(o, new ArrayListEmbeddedProxy((IObjectProxy)o, (List)f.get(o)));
                    } else if (value.isAssignableFrom(Map.class)) {
                        LOGGER.log(Level.FINER, "convirtiendo en HashMapEmbeddedProxy");
                        f.set(o, new HashMapEmbeddedProxy((IObjectProxy)o, (Map)f.get(o)));
                    }
                }
                f.setAccessible(acc);
            }
            catch (NoSuchFieldException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public <T> T hydrate(Class<T> c, OrientEdge e, Transaction t) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        T oproxied = ObjectProxyFactory.create(c, (OrientElement)e, t);
        ClassDef classdef = this.classCache.get(c);
        HashMap<String, Class<?>> fieldmap = classdef.fields;
        for (String prop : e.getPropertyKeys()) {
            Object value = e.getProperty(prop);
            Class fc = (Class)fieldmap.get(prop);
            if (fc == null) continue;
            Field f = ReflectionUtils.findField(c, prop);
            boolean acc = f.isAccessible();
            f.setAccessible(true);
            f.set(oproxied, value);
            f.setAccessible(acc);
        }
        return oproxied;
    }

    public static void setFieldValue(Object o, String field, Object value) {
        try {
            Field f = ReflectionUtils.findField(o.getClass(), field);
            boolean acc = f.isAccessible();
            f.setAccessible(true);
            f.set(o, value);
            f.setAccessible(acc);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
            Logger.getLogger(ObjectMapper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        LOGGER.setLevel(LogginProperties.ObjectMapper);
    }
}

