/*
 * Decompiled with CFR 0.152.
 */
package net.odbogm;

import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.LogginProperties;
import net.odbogm.Primitives;
import net.odbogm.annotations.FieldAttributes;
import net.odbogm.annotations.Ignore;
import net.odbogm.annotations.IgnoreClass;
import net.odbogm.annotations.Indexed;

public class DbManager {
    private static final Logger LOGGER = Logger.getLogger(DbManager.class.getName());
    private OrientGraph graphdb;
    private OrientGraphFactory factory;
    private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the package '%s' exists?";
    private static final char PKG_SEPARATOR = '.';
    private static final char DIR_SEPARATOR = '/';
    private static final String CLASS_FILE_SUFFIX = ".class";
    private ArrayList<ClassStruct> orderedRegisteredClass = new ArrayList();
    private ConcurrentHashMap<String, ClassStruct> registeredClass = new ConcurrentHashMap();
    private boolean withDrops = false;

    public DbManager(String url, String user, String passwd) {
        this.init(url, user, passwd);
    }

    public DbManager(String url, String user, String passwd, boolean withDrops) {
        this.init(url, user, passwd);
        this.withDrops = withDrops;
    }

    private void init(String url, String user, String passwd) {
        this.factory = new OrientGraphFactory(url, user, passwd).setupPool(1, 10);
    }

    public void begin() {
        this.graphdb = this.factory.getTx();
    }

    private void process(String[] analize) {
        ArrayList classes = new ArrayList();
        for (String clazz : analize) {
            classes.addAll(this.find(clazz));
        }
        for (Class clazz : classes) {
            String className = clazz.getSimpleName();
            if (clazz.isAnnotationPresent(IgnoreClass.class)) continue;
            this.buildDBScript(clazz);
        }
    }

    public void generateToConsole(String[] analize) {
        this.process(analize);
        for (ClassStruct orderedRegisteredClas : this.orderedRegisteredClass) {
            System.out.println(orderedRegisteredClas.drop);
            System.out.println(orderedRegisteredClas.create);
            for (String property : orderedRegisteredClas.properties) {
                System.out.println(property);
            }
            System.out.println("");
        }
    }

    public ArrayList<String> generateDBSQL(String[] analize) {
        ArrayList<String> statements = new ArrayList<String>();
        this.process(analize);
        for (ClassStruct orderedRegisteredClas : this.orderedRegisteredClass) {
            statements.add(orderedRegisteredClas.drop);
            statements.add(orderedRegisteredClas.create);
            for (String property : orderedRegisteredClas.properties) {
                statements.add(property);
            }
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDBSQL(String fileName, String[] analize) {
        this.process(analize);
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            LOGGER.log(Level.FINER, "abriendo el archivo...");
            fw = new FileWriter(fileName);
            LOGGER.log(Level.FINER, "preparando el printwriter...");
            pw = new PrintWriter(fw);
            LOGGER.log(Level.FINER, "procesando " + this.orderedRegisteredClass.size() + " lineas...");
            for (ClassStruct orderedRegisteredClas : this.orderedRegisteredClass) {
                pw.println(orderedRegisteredClas.drop);
                pw.println(orderedRegisteredClas.create);
                for (String property : orderedRegisteredClas.properties) {
                    pw.println(property);
                }
                pw.println("");
            }
            LOGGER.log(Level.FINER, "finalizado!");
        }
        catch (IOException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void buildDBScript(Class clazz) {
        Field[] fields;
        String className;
        if (clazz == null || clazz.isAnonymousClass() || clazz.isEnum() || clazz.isAnnotationPresent(IgnoreClass.class) || clazz.isInterface()) {
            return;
        }
        LOGGER.log(Level.FINER, "procesando: " + clazz.getSimpleName() + "...");
        String superName = "";
        if (clazz.getSuperclass() != Object.class) {
            this.buildDBScript(clazz.getSuperclass());
            String string = superName = clazz.getSuperclass() == null ? "" : clazz.getSuperclass().getSimpleName();
        }
        if (this.registeredClass.get(className = clazz.getSimpleName()) != null) {
            return;
        }
        ClassStruct clazzStruct = new ClassStruct(className);
        this.registeredClass.put(className, clazzStruct);
        this.orderedRegisteredClass.add(clazzStruct);
        clazzStruct.drop = (!this.withDrops ? "/*\n" : "\n") + "let exist = select from (select expand(classes) from metadata:schema) where name = '" + className + "'\nif ($exist.size()>0) {\n     delete vertex " + className + "\n     drop class " + className + "\n}" + (!this.withDrops ? "\n */" : "\n");
        clazzStruct.create = "\nlet exist = select from (select expand(classes) from metadata:schema) where name = '" + className + "'\nif ($exist.size()=0) {\n     create class " + className + (superName.isEmpty() ? " extends V" : " extends " + superName) + "\n}\n alter class " + className + " custom javaClass='" + clazz.getCanonicalName() + "'\n" + (superName.isEmpty() ? " " : "alter class " + className + " superclass " + superName + "\n");
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(Ignore.class) || Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) continue;
            FieldAttributes fa = field.getAnnotation(FieldAttributes.class);
            String currentProp = className + "." + field.getName();
            if (Primitives.PRIMITIVE_MAP.get(field.getType()) != null || field.getType().isEnum()) {
                String statement = "\nlet exist = select from (select expand(properties)  from (select expand(classes)  from metadata:schema)  where name = '" + className + "') where name = '" + field.getName() + "'\nif ($exist.size()=0) {\n     create property " + currentProp + " " + (field.getType().isEnum() ? " string " : (Serializable)Primitives.PRIMITIVE_MAP.get(field.getType())) + "\n}\n ";
                clazzStruct.properties.add(statement);
                if (fa != null) {
                    if (!fa.min().isEmpty()) {
                        clazzStruct.properties.add("alter property " + currentProp + " min " + fa.min());
                    }
                    if (!fa.max().isEmpty()) {
                        clazzStruct.properties.add("alter property " + currentProp + " max " + fa.max());
                    }
                    if (fa.mandatory() != FieldAttributes.Bool.UNDEF) {
                        clazzStruct.properties.add("alter property " + currentProp + " mandatory " + (Object)((Object)fa.mandatory()));
                    }
                    if (fa.notNull() != FieldAttributes.Bool.UNDEF) {
                        clazzStruct.properties.add("alter property " + currentProp + " NotNull " + (Object)((Object)fa.notNull()));
                    }
                    if (!fa.regexp().isEmpty()) {
                        clazzStruct.properties.add("alter property " + currentProp + " regexp " + fa.regexp());
                    }
                    if (!fa.collate().isEmpty()) {
                        clazzStruct.properties.add("alter property " + currentProp + " collate " + fa.collate());
                    }
                    if (fa.readOnly() != FieldAttributes.Bool.UNDEF) {
                        clazzStruct.properties.add("alter property " + currentProp + " readonly " + (Object)((Object)fa.readOnly()));
                    }
                    if (!fa.defaultVal().isEmpty()) {
                        clazzStruct.properties.add("alter property " + currentProp + " default " + fa.defaultVal());
                    }
                }
            } else {
                clazzStruct.properties.add("\nlet exist = select from (select expand(classes) from metadata:schema) where name = '" + className + "_" + field.getName() + "'\nif ($exist.size()=0) {\n     create class " + className + "_" + field.getName() + " extends E\n}\n ");
            }
            if (!field.isAnnotationPresent(Indexed.class)) continue;
            Indexed idx = field.getAnnotation(Indexed.class);
            clazzStruct.properties.add("\nlet exist = select from(select expand(indexes) from metadata:indexmanager) where name = '" + currentProp + "'\nif ($exist.size()=0) {\n     create index " + currentProp + " " + (Object)((Object)idx.type()) + "\n}\n ");
        }
    }

    private List<Class<?>> find(String scannedPackage) {
        String scannedPath = scannedPackage.replace('.', '/');
        URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
        LOGGER.log(Level.INFO, "URL: " + scannedUrl);
        if (scannedUrl == null) {
            throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage));
        }
        File scannedDir = new File(scannedUrl.getFile());
        try {
            LOGGER.log(Level.INFO, "scannedDir: " + scannedDir.getCanonicalPath());
        }
        catch (IOException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList classes = new ArrayList();
        for (File file : scannedDir.listFiles()) {
            classes.addAll(this.find(file, scannedPackage));
        }
        return classes;
    }

    private List<Class<?>> find(File file, String scannedPackage) {
        ArrayList classes;
        block4: {
            String resource;
            block3: {
                classes = new ArrayList();
                resource = scannedPackage + '.' + file.getName();
                LOGGER.log(Level.INFO, "resource: " + resource);
                if (!file.isDirectory()) break block3;
                for (File child : file.listFiles()) {
                    classes.addAll(this.find(child, resource));
                }
                break block4;
            }
            if (!resource.endsWith(CLASS_FILE_SUFFIX)) break block4;
            int endIndex = resource.length() - CLASS_FILE_SUFFIX.length();
            String className = resource.substring(0, endIndex);
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classes;
    }

    static {
        LOGGER.setLevel(LogginProperties.DbManager);
    }

    class ClassStruct {
        public String className;
        public String drop;
        public String create;
        public ArrayList<String> properties = new ArrayList();

        public ClassStruct(String className) {
            this.className = className;
        }

        public int hashCode() {
            int hash = 7;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassStruct other = (ClassStruct)obj;
            return Objects.equals(this.className, other.className);
        }
    }
}

