/*
 * Decompiled with CFR 0.152.
 */
package Test;

import Test.EdgeAttrib;
import Test.Foo;
import Test.SSimpleVertex;
import Test.SimpleVertex;
import Test.SimpleVertexEx;
import Test.SimpleVertexWithEmbedded;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.odbogm.DbManager;
import net.odbogm.SessionManager;
import net.odbogm.exceptions.IncorrectRIDField;
import net.odbogm.exceptions.ReferentialIntegrityViolation;
import net.odbogm.proxy.IObjectProxy;
import net.odbogm.security.AccessRight;
import net.odbogm.security.GroupSID;
import net.odbogm.security.UserSID;
import net.odbogm.utils.DateHelper;
import net.odbogm.utils.ReflectionUtils;

public class Test {
    private static final Logger LOGGER = Logger.getLogger(Test.class.getName());
    SessionManager sm;
    public ArrayList<SimpleVertex> testArrayList;
    public Map<String, SimpleVertex> testHashMap;
    final String lexicon = "a\u00e1bcde\u00e9fghi\u00edjklmn\u00f1o\u00f3pqrstuvwxyz";
    final Random rand = new Random();

    public static void main(String[] args) {
        new Test();
    }

    public Test() {
        this.initSession();
        this.testDelete();
        this.sm.shutdown();
    }

    public void initSession() {
        System.out.println("Iniciando comunicaci\u00f3n con la base....");
        long millis = System.currentTimeMillis();
        this.sm = new SessionManager("remote:localhost/Test", "root", "toor").setActivationStrategy(SessionManager.ActivationStrategy.CLASS_INSTRUMENTATION);
        System.out.println("Tiempo de inicio: " + (System.currentTimeMillis() - millis));
        System.out.println("comunicaci\u00f3n inicializada!");
        this.sm.begin();
    }

    public void testSessionManager() {
        try {
            this.sm.commit();
        }
        catch (OConcurrentModificationException oConcurrentModificationException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public void testDbManager() {
        DbManager dbm = new DbManager("remote:localhost/Test", "root", "toor");
        dbm.generateDBSQL("/tmp/1/test.sql", new String[]{"Test"});
    }

    public void testSimpleQuery() {
        System.out.println("\n\n\n");
        System.out.println("***************************************************************");
        System.out.println("Query basado en la clase: verificar que devuelve la clase y los");
        System.out.println("subtipos de la misma");
        System.out.println("***************************************************************");
        SimpleVertexEx sve = new SimpleVertexEx();
        sve.initEnum();
        sve.initInner();
        sve.initArrayList();
        sve.initHashMap();
        System.out.println("guardado del objeto limpio.");
        SimpleVertexEx stored = this.sm.store(sve);
        this.sm.commit();
        System.out.println("consultando por SimpleVertex....");
        List<SimpleVertex> list = this.sm.query(SimpleVertex.class);
        int isv = 0;
        int isve = 0;
        for (SimpleVertex object : list) {
            if (object instanceof SimpleVertexEx) {
                ++isve;
                continue;
            }
            if (object instanceof SimpleVertex) {
                ++isv;
                continue;
            }
            System.out.println("ERROR:  " + object.getClass() + " !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        System.out.println("sv: " + isv);
        System.out.println("SVE: " + isve);
        System.out.println("***************************************************************");
        System.out.println("Fin SimpleQuery");
        System.out.println("***************************************************************");
    }

    public void testComplexHashMap() {
        System.out.println("\n\n\n");
        System.out.println("***************************************************************");
        System.out.println("Verificar el comportamiento de los HashMap con objetos como key");
        System.out.println("***************************************************************");
        SimpleVertexEx sve = new SimpleVertexEx();
        System.out.println("guardado del objeto limpio.");
        SimpleVertexEx stored = this.sm.store(sve);
        this.sm.commit();
        String rid = ((IObjectProxy)((Object)stored)).___getRid();
        System.out.println("primer commit finalizado. RID: " + rid + " ------------------------------------------------------------");
        System.out.println("Agrego un HM nuevo");
        HashMap<EdgeAttrib, SimpleVertexEx> ohm = new HashMap<EdgeAttrib, SimpleVertexEx>();
        stored.setOhmSVE(ohm);
        ohm.put(new EdgeAttrib("nota 1", DateHelper.getCurrentDate()), new SimpleVertexEx());
        ohm.put(new EdgeAttrib("nota 2", DateHelper.getCurrentDate()), new SimpleVertexEx());
        System.out.println("\ninicio segundo commit ----------------------------------------------------------");
        this.sm.commit();
        System.out.println("segundo commit finalizado ----------------------------------------------------------\n");
        SimpleVertexEx retrieved = this.sm.get(SimpleVertexEx.class, rid);
        System.out.println("1 ----------");
        System.out.println("retrieved: " + retrieved + " : " + retrieved.getOhmSVE());
        System.out.println("2 ----------");
        System.out.println("stored: " + stored + " : " + stored.getOhmSVE() + "\n\n");
        System.out.println("3 ----------");
        int iretSize = retrieved.getOhmSVE().size();
        int istoredSize = stored.getOhmSVE().size();
        Test.assertEquals(iretSize, istoredSize);
        System.out.println("\nagregamos un nuevo objeto al hashmap ya inicializado");
        stored.getOhmSVE().put(new EdgeAttrib("nota 3", DateHelper.getCurrentDate()), new SimpleVertexEx());
        System.out.println("\ninicio tercer commit ----------------------------------------------------------");
        this.sm.commit();
        System.out.println("tercer commit ----------------------------------------------------------\n");
        retrieved = this.sm.get(SimpleVertexEx.class, rid);
        System.out.println("retrieved: " + retrieved + " : " + retrieved.getOhmSVE());
        System.out.println("stored: " + stored + " : " + stored.getOhmSVE());
        Test.assertEquals(retrieved.getOhmSVE().size(), stored.getOhmSVE().size());
    }

    public void testEmbeddded() {
        SimpleVertexWithEmbedded svemb = new SimpleVertexWithEmbedded();
        SimpleVertexWithEmbedded result = this.sm.store(svemb);
        this.sm.commit();
        String rid = ((IObjectProxy)((Object)result)).___getRid();
        SimpleVertexWithEmbedded ret = this.sm.get(SimpleVertexWithEmbedded.class, rid);
        System.out.println("list.size: " + ret.stringlist.size());
        System.out.println("map.size: " + ret.simplemap.size());
        System.out.println("Anexando uno a la lista");
        ret.addToList();
        this.sm.commit();
        System.out.println("modificando el contenido de un elemento de la lista...");
        ret.stringlist.set(1, "-1-");
        this.sm.commit();
        System.out.println("==========================================================");
        System.out.println("Anexando uno al map");
        System.out.println("==========================================================");
        ret.addToMap();
        this.sm.commit();
        System.out.println("==========================================================");
        ret.simplemap.put("key 1", 10);
        this.sm.commit();
    }

    public void setUpGroups() {
        GroupSID gna = new GroupSID("gna", "gna");
        GroupSID gr = new GroupSID("gr", "gr");
        GroupSID gw = new GroupSID("gw", "gr");
        GroupSID sgna = this.sm.store(gna);
        GroupSID sgr = this.sm.store(gr);
        GroupSID sgw = this.sm.store(gw);
        this.sm.commit();
        UserSID una = new UserSID("una", "una");
        UserSID ur = new UserSID("ur", "ur");
        UserSID uw = new UserSID("uw", "uw");
        UserSID urw = new UserSID("urw", "urw");
        una = this.sm.store(una);
        ur = this.sm.store(ur);
        uw = this.sm.store(uw);
        urw = this.sm.store(urw);
        this.sm.commit();
        this.sm.commit();
    }

    public void testSObjects() {
        SSimpleVertex ssv = new SSimpleVertex();
        ssv = this.sm.store(ssv);
        this.sm.commit();
        String reg = ((IObjectProxy)((Object)ssv)).___getRid();
        GroupSID gna = this.sm.get(GroupSID.class, "#32:11");
        GroupSID gr = this.sm.get(GroupSID.class, "#32:10");
        GroupSID gw = this.sm.get(GroupSID.class, "#32:9");
        System.out.println("Agregando los acls...");
        ssv.setAcl(gna, new AccessRight(0));
        ssv.setAcl(gr, new AccessRight().setRights(1));
        ssv.setAcl(gw, new AccessRight().setRights(2));
        this.sm.commit();
        UserSID una = this.sm.get(UserSID.class, "33:23");
        UserSID ur = this.sm.get(UserSID.class, "33:22");
        UserSID uw = this.sm.get(UserSID.class, "33:21");
        this.sm.setLoggedInUser(una);
        System.out.println("Security State NA: " + ssv.validate(una));
        System.out.println("Security State R: " + ssv.validate(ur));
        System.out.println("Security State W: " + ssv.validate(uw));
    }

    public void lab() {
        SimpleVertexEx sv1 = this.sm.get(SimpleVertexEx.class, "12:1177");
        SimpleVertexEx sv2 = this.sm.get(SimpleVertexEx.class, "12:1177");
        HashMap hmi = new HashMap();
        try {
            System.out.println(ReflectionUtils.findMethod(SimpleVertexEx.class, "toString", null));
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("" + sv2.toString());
    }

    public void testQuery() {
        long i = this.sm.query("select count(*) as size from SimpleVertexEx ", "");
        System.out.println("res: " + i);
    }

    public void store() {
        try {
            SimpleVertex value;
            String key;
            System.out.println("*******************************");
            System.out.println("     Test store: agrego uno    ");
            System.out.println("*******************************");
            GroupSID gs = new GroupSID();
            System.out.println("---------------------------------------------------------");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            LOGGER.log(Level.FINER, "Test finer");
            SimpleVertex svinner = new SimpleVertex();
            SimpleVertex svinner2 = new SimpleVertex();
            SimpleVertexEx svex = new SimpleVertexEx();
            svex.initInner();
            svex.initArrayList();
            svex.initHashMap();
            svex.initEnum();
            System.out.println("iniciando STORE -------");
            svex = this.sm.store(svex);
            System.out.println("idNew: " + ((IObjectProxy)((Object)svex)).___getVertex().getIdentity().isNew());
            System.out.println("idTemporary: " + ((IObjectProxy)((Object)svex)).___getVertex().getIdentity().isTemporary());
            this.sm.flush();
            System.out.println("----------- STORE commit -----------------");
            this.sm.commit();
            String testRID = this.sm.getRID(svex);
            System.out.println("Test: RID:" + testRID);
            System.out.println("*******************************");
            System.out.println("         Test hydrate          ");
            System.out.println("*******************************");
            System.out.println("Test hydrate " + testRID);
            SimpleVertexEx sv = this.sm.get(SimpleVertexEx.class, testRID);
            System.out.print("1- Enter String");
            String s = br.readLine();
            System.out.println("continuando...");
            System.out.println("SVINNER.getS(): " + sv.getSvinner().getS());
            System.out.println("Enum test:" + (Object)((Object)sv.getEnumTest()));
            System.out.println("Test - List:");
            for (SimpleVertex next : sv.getAlSV()) {
                System.out.println(next.i);
            }
            System.out.println("Test - Map:");
            for (Map.Entry<String, SimpleVertex> entry : sv.getHmSV().entrySet()) {
                key = (String)entry.getKey();
                value = (SimpleVertex)entry.getValue();
                System.out.println("Key: " + key + " value: " + value.i);
            }
            System.out.print("2- Enter String");
            s = br.readLine();
            System.out.println("continuando...");
            System.out.println("*******************************");
            System.out.println("         Test update          ");
            System.out.println("*******************************");
            sv.i = 25;
            for (SimpleVertex next : sv.getAlSV()) {
                ++next.i;
                System.out.println(next.i);
            }
            System.out.println("Update map");
            for (Map.Entry<String, SimpleVertex> entry : sv.getHmSV().entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                ++value.i;
            }
            System.out.println("----------- 1 commit -----------------");
            try {
                this.sm.commit();
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {}
        }
        catch (IllegalArgumentException | SecurityException | IncorrectRIDField ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void testStoreLink() {
        System.out.println("\n\n\n");
        System.out.println("***************************************************************");
        System.out.println("store objeto sin Link y luego se le agrega uno");
        System.out.println("***************************************************************");
        SimpleVertexEx sve = new SimpleVertexEx();
        SimpleVertexEx result = this.sm.store(sve);
        Test.assertEquals(1, this.sm.getDirtyCount());
        this.sm.commit();
        Test.assertEquals(0, this.sm.getDirtyCount());
        System.out.println("=========== fin primer commit ====================================");
        Test.assertEquals(result.getSvinner(), sve.getSvinner());
        result.initInner();
        Test.assertEquals(1, this.sm.getDirtyCount());
        System.out.println("result.svinner: " + result.getSvinner().getS() + "      toS: " + result.getSvinner().toString());
        System.out.println("=========== inicio segundo commit <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        this.sm.commit();
        Test.assertEquals(0, this.sm.getDirtyCount());
        System.out.println("=========== fin segundo commit ====================================");
        System.out.println("result.svinner: " + result.getSvinner().getS() + "      toS: " + result.getSvinner().toString());
        Test.assertEquals(0, this.sm.getDirtyCount());
        String rid = ((IObjectProxy)((Object)result)).___getRid();
        System.out.println("============================================================================");
        System.out.println("RID: " + rid);
        System.out.println("============================================================================");
        Test.assertEquals(0, this.sm.getDirtyCount());
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("========= comienzo del get =================================================");
        SimpleVertexEx expResult = this.sm.get(SimpleVertexEx.class, rid);
        Test.assertEquals(0, this.sm.getDirtyCount());
        System.out.println("========= fin del get =================================================");
        Test.assertEquals(((IObjectProxy)((Object)expResult)).___getRid(), rid);
        System.out.println("\n\n\n++++++++++++++++ result: " + result.getSvinner().toString());
        System.out.println("++++++++++++++++ expResult: " + expResult.getSvinner().toString());
        Test.assertEquals(expResult.getSvinner().getI(), result.getSvinner().getI());
        Test.assertEquals(expResult.getSvinner().getS(), result.getSvinner().getS());
        Test.assertEquals(expResult.getSvinner().getoB(), result.getSvinner().getoB());
        Test.assertEquals(expResult.getSvinner().getoF(), result.getSvinner().getoF());
        Test.assertEquals(expResult.getSvinner().getoI(), result.getSvinner().getoI());
    }

    public void testUpdateLink() {
        System.out.println("store objeto sin Link y luego se le agrega uno");
        SimpleVertexEx sve = new SimpleVertexEx();
        SimpleVertexEx result = this.sm.store(sve);
        this.sm.commit();
        System.out.println("=========== fin primer commit ====================================");
        result.initInner();
        System.out.println("result.svinner: " + result.getSvinner().getS() + "      toS: " + result.getSvinner().toString());
        System.out.println("=========== inicio segundo commit <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        this.sm.commit();
        System.out.println("=========== fin segundo commit ====================================");
        System.out.println("result.svinner: " + result.getSvinner().getS() + "      toS: " + result.getSvinner().toString());
        String rid = ((IObjectProxy)((Object)result)).___getRid();
        System.out.println("============================================================================");
        System.out.println("RID: " + rid);
        System.out.println("============================================================================");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("========= comienzo del get =================================================");
        SimpleVertexEx expResult = this.sm.get(SimpleVertexEx.class, rid);
        System.out.println("========= fin del get =================================================");
        System.out.println("++++++++++++++++ result: " + result.getSvinner().toString());
        System.out.println("++++++++++++++++ expResult: " + expResult.getSvinner().toString());
    }

    public void testLoop() {
        System.out.println("***************************************************************");
        System.out.println("Verificar el tratamiento de objetos con loops");
        System.out.println("***************************************************************");
        SimpleVertexEx sve = new SimpleVertexEx();
        sve.initInner();
        sve.initEnum();
        sve.initArrayList();
        sve.initHashMap();
        SimpleVertexEx sveLoop = new SimpleVertexEx();
        sveLoop.initInner();
        sveLoop.initEnum();
        sveLoop.initArrayList();
        sveLoop.initHashMap();
        sve.setLooptest(sveLoop);
        sveLoop.setLooptest(sve);
        System.out.println("pre store..............................");
        SimpleVertexEx result = this.sm.store(sve);
        System.out.println("store ok!");
        System.out.println("pre commit..............................");
        this.sm.commit();
        System.out.println("commit ok ==============================");
        System.out.println(" inicio de los test");
        String rid = ((IObjectProxy)((Object)result)).___getRid();
        SimpleVertexEx expResult = this.sm.get(SimpleVertexEx.class, rid);
        System.out.println("1 >>>>>>>>>>>>>");
        String looprid = ((IObjectProxy)((Object)expResult.getLooptest())).___getRid();
        System.out.println("2 >>>>>>>>>>>>>");
        System.out.println("");
        System.out.println("");
        System.out.println("Objeto almacenado en: " + rid + " loop rid: " + looprid);
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println(" get completado. Iniciando los asserts");
        System.out.println("");
        System.out.println("");
        System.out.println("-1-");
        Test.assertEquals(((IObjectProxy)((Object)expResult)).___getRid(), ((IObjectProxy)((Object)result)).___getRid());
        System.out.println("-2-");
        Test.assertEquals(((IObjectProxy)((Object)expResult.getLooptest())).___getRid(), ((IObjectProxy)((Object)result.getLooptest())).___getRid());
        System.out.println("-3-");
        Test.assertEquals(((IObjectProxy)((Object)expResult.getLooptest().getLooptest())).___getRid(), ((IObjectProxy)((Object)result)).___getRid());
        System.out.println("============================= FIN LoopTest ===============================");
    }

    public void testDelete() {
        System.out.println("\n\n\n");
        System.out.println("***************************************************************");
        System.out.println("delete objetos");
        System.out.println("***************************************************************");
        System.out.println("Testeando ingegridad referencial...");
        SimpleVertex irSV = this.sm.store(new SimpleVertex());
        this.sm.commit();
        String irSVrid = this.sm.getRID(irSV);
        SimpleVertexEx irSVEX = new SimpleVertexEx();
        irSVEX.setSvinner(irSV);
        SimpleVertexEx rirSVEX = this.sm.store(irSVEX);
        irSVEX = null;
        this.sm.commit();
        String rirSVEXrid = this.sm.getRID(rirSVEX);
        System.out.println("Referencia creada: " + rirSVEXrid + "-->" + irSVrid);
        System.out.println("presione ENTER para continuar...");
        Scanner scanner = new Scanner(System.in);
        scanner.nextLine();
        try {
            this.sm.delete(irSV);
            this.sm.commit();
            System.out.println("El objeto fue borrado y deber\u00eda haber saltado una excepci\u00f3n");
        }
        catch (ReferentialIntegrityViolation riv) {
            System.out.println("ReferencialIntegrityViolation ");
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Test.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (Test.equalsRegardingNull(expected, actual)) {
            return;
        }
        if (expected instanceof String && actual instanceof String) {
            String cleanMessage = message == null ? "" : message;
            System.out.println("Expected: " + expected + " - actual: " + actual);
        } else {
            Test.failNotEquals(message, expected, actual);
        }
    }

    private static boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return Test.isEquals(expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        System.out.println("ERROR: " + Test.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return formatted + "expected: " + Test.formatClassAndValue(expected, expectedString) + " but was: " + Test.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    private void testLongQuery() {
        for (int i = 0; i < 1000000; ++i) {
            String nombre = this.randomIdentifier();
            SimpleVertex s = new SimpleVertex(nombre);
            s.i = this.rand.nextInt(10000);
            this.sm.store(s);
            if (i % 100 != 0) continue;
            this.sm.commit();
            System.out.println("" + i);
        }
    }

    public String randomIdentifier() {
        StringBuilder builder = new StringBuilder();
        while (builder.toString().length() == 0) {
            int length = this.rand.nextInt(5) + 5;
            for (int i = 0; i < length; ++i) {
                builder.append("a\u00e1bcde\u00e9fghi\u00edjklmn\u00f1o\u00f3pqrstuvwxyz".charAt(this.rand.nextInt("a\u00e1bcde\u00e9fghi\u00edjklmn\u00f1o\u00f3pqrstuvwxyz".length())));
            }
        }
        return builder.toString();
    }

    private void testMultiTran() {
        OrientGraphFactory fact = new OrientGraphFactory("remote:localhost/Test", "root", "toor").setupPool(1, 10);
        OrientGraph t1 = fact.getTx();
        OrientGraph t2 = fact.getTx();
        t1.addVertex((Object)"class:Test", new Object[]{"text", "transac 1"});
        t2.addVertex((Object)"class:Test", new Object[]{"text", "transac 2"});
        t1.commit();
        t2.rollback();
        t1.shutdown();
        t2.shutdown();
    }

    private void testRollbackEmbedded() {
        System.out.println("\n\n\n");
        System.out.println("***************************************************************");
        System.out.println("test embedded rollback SObjects");
        System.out.println("***************************************************************");
        Foo foo = new Foo();
        System.out.println("\n\nIniciando Store ========================= \n\n");
        Foo rfoo = this.sm.store(foo);
        this.sm.commit();
        System.out.println("\n\nStore finalizado ========================= \n\n");
        String rid = this.sm.getRID(rfoo);
        rfoo = null;
        System.out.println("\n\nIniciando GET ========================= \n\n");
        rfoo = this.sm.get(Foo.class, rid);
        System.out.println("\n\nGET FINALIZADO ========================= \n\n");
        rfoo.setText("rollback");
        System.out.println("\n\nINICIANDO ROLLBACK ========================= \n\n");
        this.sm.rollback();
    }

    private void testRollbackSVE() {
        System.out.println("\n\n\n");
        System.out.println("***************************************************************");
        System.out.println("Rollback Collections. Se restablecen los atributos que hereden de Collection.");
        System.out.println("***************************************************************");
        SimpleVertexEx sve = new SimpleVertexEx();
        sve.initEnum();
        sve.initInner();
        sve.initArrayList();
        sve.initHashMap();
        sve.alSV = new ArrayList();
        sve.alSV.add(new SimpleVertex());
        sve.alSV.add(new SimpleVertex());
        sve.alSV.add(new SimpleVertex());
        SimpleVertexEx stored = this.sm.store(sve);
        System.out.println("guardando el objeto con 3 elementos en el AL.");
        this.sm.commit();
        System.out.println("\n\nSTORE FINALIZADO ========================= \n\n");
        String rid = this.sm.getRID(stored);
        stored.alSV.add(new SimpleVertex());
        System.out.println("\n\nINICIANDO ROLLBACK ========================= \n\n");
        this.sm.rollback();
        System.out.println("" + sve.alSV.size() + " =|= " + stored.alSV.size());
        Test.assertEquals(sve.alSV.size(), stored.alSV.size());
    }

    private void testTimeLoad() {
        long initTime = System.currentTimeMillis();
        List<SimpleVertexEx> svexs = this.sm.query(SimpleVertexEx.class);
        long endTime = System.currentTimeMillis();
        System.out.println("Tiempo: " + (endTime - initTime) + " - Size: " + svexs.size() + "\n\n");
        initTime = System.currentTimeMillis();
        for (SimpleVertexEx svex : svexs) {
            String string = svex.getS() + ", " + svex.getI() + ", " + svex.getF() + ", " + svex.getFecha();
        }
        endTime = System.currentTimeMillis();
        System.out.println("Tiempo: " + (endTime - initTime) + "\n\n");
    }

    static {
        LOGGER.setLevel(Level.ALL);
    }
}

