/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.util;

import com.github.mauricio.async.db.postgresql.util.ParserURL$$anonfun$parseOptions$1$1$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class ParserURL$ {
    public static final ParserURL$ MODULE$;
    private final Logger logger;
    private final String PGPORT;
    private final String PGDBNAME;
    private final String PGHOST;
    private final String PGUSERNAME;
    private final String PGPASSWORD;
    private final String DEFAULT_PORT;
    private final Regex pgurl1;
    private final Regex pgurl2;

    static {
        new ParserURL$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String PGPORT() {
        return this.PGPORT;
    }

    public String PGDBNAME() {
        return this.PGDBNAME;
    }

    public String PGHOST() {
        return this.PGHOST;
    }

    public String PGUSERNAME() {
        return this.PGUSERNAME;
    }

    public String PGPASSWORD() {
        return this.PGPASSWORD;
    }

    public String DEFAULT_PORT() {
        return this.DEFAULT_PORT;
    }

    private Regex pgurl1() {
        return this.pgurl1;
    }

    private Regex pgurl2() {
        return this.pgurl2;
    }

    public Map<String, String> parse(String connectionURL) {
        Map map;
        Map properties = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        String string = connectionURL;
        Option option = this.pgurl1().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(5) == 0) {
            String server = (String)((LinearSeqOptimized)option.get()).apply(1);
            String port = (String)((LinearSeqOptimized)option.get()).apply(2);
            String dbname = (String)((LinearSeqOptimized)option.get()).apply(3);
            String params = (String)((LinearSeqOptimized)option.get()).apply(4);
            Map result = properties;
            if (server != null) {
                result = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGHOST()), (Object)this.unwrapIpv6address(server)));
            }
            if (dbname != null && new StringOps(Predef$.MODULE$.augmentString(dbname)).nonEmpty()) {
                result = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGDBNAME()), (Object)dbname));
            }
            if (port != null) {
                result = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGPORT()), (Object)port));
            }
            if (params != null) {
                result = result.$plus$plus((GenTraversableOnce)this.parseOptions$1(params));
            }
            map = result;
        } else {
            Option option2 = this.pgurl2().unapplySeq((Object)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(7) == 0) {
                String username = (String)((LinearSeqOptimized)option2.get()).apply(1);
                String password = (String)((LinearSeqOptimized)option2.get()).apply(2);
                String server = (String)((LinearSeqOptimized)option2.get()).apply(3);
                String port = (String)((LinearSeqOptimized)option2.get()).apply(4);
                String dbname = (String)((LinearSeqOptimized)option2.get()).apply(5);
                String params = (String)((LinearSeqOptimized)option2.get()).apply(6);
                Map result = properties.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGHOST()), (Object)this.unwrapIpv6address(server))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGPORT()), (Object)port)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGDBNAME()), (Object)dbname)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGUSERNAME()), (Object)username)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGPASSWORD()), (Object)password));
                if (params != null) {
                    result = result.$plus$plus((GenTraversableOnce)this.parseOptions$1(params));
                }
                map = result;
            } else {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection url '", "' could not be parsed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionURL})));
                map = properties;
            }
        }
        return map;
    }

    private String unwrapIpv6address(String server) {
        return server.startsWith("[") ? server.substring(1, server.length() - 1) : server;
    }

    private final Map parseOptions$1(String optionsStr) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])optionsStr.split("&")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String o) {
                Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(o)).span((Function1)new anonfun$parseOptions$1$1$$anonfun$1(this));
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)name), new StringOps(Predef$.MODULE$.augmentString(value)).drop(1));
                    return tuple22;
                }
                throw new MatchError((Object)tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
    }

    private ParserURL$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.PGPORT = "port";
        this.PGDBNAME = "database";
        this.PGHOST = "host";
        this.PGUSERNAME = "user";
        this.PGPASSWORD = "password";
        this.DEFAULT_PORT = "5432";
        this.pgurl1 = new StringOps(Predef$.MODULE$.augmentString("(jdbc:postgresql):(?://([^/:]*|\\[.+\\])(?::(\\d+))?)?(?:/([^/?]*))?(?:\\?(.*))?")).r();
        this.pgurl2 = new StringOps(Predef$.MODULE$.augmentString("(postgres|postgresql)://(.*):(.*)@(.*):(\\d+)/([^/?]*)(?:\\?(.*))?")).r();
    }
}

