/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.encoders;

import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementEncoderHelper;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementEncoderHelper$;
import com.github.mauricio.async.db.util.ByteBufferUtils$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;

public abstract class PreparedStatementEncoderHelper$class {
    public static ByteBuf writeExecutePortal(PreparedStatementEncoderHelper $this, byte[] statementIdBytes, String query, Seq values, ColumnEncoderRegistry encoder, Charset charset, boolean writeDescribe) {
        BoxedUnit boxedUnit;
        if (PreparedStatementEncoderHelper$.MODULE$.log().isDebugEnabled()) {
            PreparedStatementEncoderHelper$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing execute portal to statement (", ") - values (", ") - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query, values.mkString(", "), charset})));
        }
        ByteBuf bindBuffer = Unpooled.buffer((int)1024);
        bindBuffer.writeByte(66);
        bindBuffer.writeInt(0);
        bindBuffer.writeBytes(statementIdBytes);
        bindBuffer.writeByte(0);
        bindBuffer.writeBytes(statementIdBytes);
        bindBuffer.writeByte(0);
        bindBuffer.writeShort(0);
        bindBuffer.writeShort(values.length());
        ArrayBuffer decodedValues = PreparedStatementEncoderHelper$.MODULE$.log().isDebugEnabled() ? new ArrayBuffer(values.size()) : null;
        values.foreach((Function1)new Serializable($this, bindBuffer, decodedValues, encoder, charset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreparedStatementEncoderHelper $outer;
            private final ByteBuf bindBuffer$1;
            private final ArrayBuffer decodedValues$1;
            private final ColumnEncoderRegistry encoder$1;
            private final Charset charset$1;

            public final Object apply(Object value) {
                Object object;
                if (this.$outer.isNull(value)) {
                    this.bindBuffer$1.writeInt(-1);
                    object = PreparedStatementEncoderHelper$.MODULE$.log().isDebugEnabled() ? this.decodedValues$1.$plus$eq(null) : BoxedUnit.UNIT;
                } else {
                    String encodedValue = this.encoder$1.encode(value);
                    Object object2 = PreparedStatementEncoderHelper$.MODULE$.log().isDebugEnabled() ? this.decodedValues$1.$plus$eq((Object)encodedValue) : BoxedUnit.UNIT;
                    if (this.$outer.isNull(encodedValue)) {
                        object = this.bindBuffer$1.writeInt(-1);
                    } else {
                        byte[] content = encodedValue.getBytes(this.charset$1);
                        this.bindBuffer$1.writeInt(content.length);
                        object = this.bindBuffer$1.writeBytes(content);
                    }
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bindBuffer$1 = bindBuffer$1;
                this.decodedValues$1 = decodedValues$1;
                this.encoder$1 = encoder$1;
                this.charset$1 = charset$1;
            }
        });
        if (PreparedStatementEncoderHelper$.MODULE$.log().isDebugEnabled()) {
            PreparedStatementEncoderHelper$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing portal - statement id (", ") - statement (", ") - encoded values (", ") - original values (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.byteArrayOps(statementIdBytes).mkString("-"), query, decodedValues.mkString(", "), values.mkString(", ")})));
        }
        bindBuffer.writeShort(0);
        ByteBufferUtils$.MODULE$.writeLength(bindBuffer);
        if (writeDescribe) {
            int describeLength = 6 + statementIdBytes.length + 1;
            ByteBuf describeBuffer = bindBuffer;
            describeBuffer.writeByte(68);
            describeBuffer.writeInt(describeLength - 1);
            describeBuffer.writeByte(80);
            describeBuffer.writeBytes(statementIdBytes);
            boxedUnit = describeBuffer.writeByte(0);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int executeLength = 5 + statementIdBytes.length + 1 + 4;
        ByteBuf executeBuffer = Unpooled.buffer((int)executeLength);
        executeBuffer.writeByte(69);
        executeBuffer.writeInt(executeLength - 1);
        executeBuffer.writeBytes(statementIdBytes);
        executeBuffer.writeByte(0);
        executeBuffer.writeInt(0);
        int closeLength = 6 + statementIdBytes.length + 1;
        ByteBuf closeBuffer = Unpooled.buffer((int)closeLength);
        closeBuffer.writeByte(67);
        closeBuffer.writeInt(closeLength - 1);
        closeBuffer.writeByte(80);
        closeBuffer.writeBytes(statementIdBytes);
        closeBuffer.writeByte(0);
        ByteBuf syncBuffer = Unpooled.buffer((int)5);
        syncBuffer.writeByte(83);
        syncBuffer.writeInt(4);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{bindBuffer, executeBuffer, syncBuffer, closeBuffer});
    }

    public static boolean writeExecutePortal$default$6(PreparedStatementEncoderHelper $this) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNull(PreparedStatementEncoderHelper $this, Object value) {
        if (value == null) return true;
        Object object = value;
        None$ none$ = None$.MODULE$;
        if (object != null) {
            if (!object.equals(none$)) return false;
            return true;
        }
        if (none$ == null) return true;
        return false;
    }

    public static void $init$(PreparedStatementEncoderHelper $this) {
    }
}

