/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.pool.TimeoutScheduler;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.NotificationResponse;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011}r!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0006)pgR<'/Z*R\u0019\u000e{gN\\3di&|gN\u0003\u0002\u0004\t\u0005Q\u0001o\\:uOJ,7/\u001d7\u000b\u0005\u00151\u0011A\u00013c\u0015\t9\u0001\"A\u0003bgft7M\u0003\u0002\n\u0015\u0005AQ.Y;sS\u000eLwN\u0003\u0002\f\u0019\u00051q-\u001b;ik\nT\u0011!D\u0001\u0004G>l7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u000by\u0012aB\"pk:$XM]\u000b\u0002AA\u0011\u0011EK\u0007\u0002E)\u00111\u0005J\u0001\u0007CR|W.[2\u000b\u0005\u00152\u0013AC2p]\u000e,(O]3oi*\u0011q\u0005K\u0001\u0005kRLGNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-\u0012#AC!u_6L7\rT8oO\"1Q&\u0005Q\u0001\u000e\u0001\n\u0001bQ8v]R,'\u000f\t\u0005\b_E\u0011\r\u0011\"\u00021\u0003A\u0019VM\u001d<feZ+'o]5p].+\u00170F\u00012\u001f\u0005\u0011\u0014%A\u001a\u0002\u001dM,'O^3s?Z,'o]5p]\"1Q'\u0005Q\u0001\u000eE\n\u0011cU3sm\u0016\u0014h+\u001a:tS>t7*Z=!\u0011\u001d9\u0014C1A\u0005\u0006a\n1\u0001\\8h+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000f\u0002\u0007\u0019><w-\u001a:\t\r\t\u000b\u0002\u0015!\u0004:\u0003\u0011awn\u001a\u0011\t\u000f\u0011\u000b\u0012\u0013!C\u0001\u000b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012A\u0012\u0016\u0003\u000f.\u0003\"\u0001S%\u000e\u0003\u0011I!A\u0013\u0003\u0003\u001b\r{gNZ5hkJ\fG/[8oW\u0005a\u0005CA'S\u001b\u0005q%BA(Q\u0003%)hn\u00195fG.,GM\u0003\u0002R-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Ms%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9Q+EI\u0001\n\u00031\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001XU\tA6\n\u0005\u0002Z96\t!L\u0003\u0002\\\t\u000511m\u001c7v[:L!!\u0018.\u0003+\r{G.^7o\u000b:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"9q,EI\u0001\n\u0003\u0001\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001bU\t\u00117\n\u0005\u0002ZG&\u0011AM\u0017\u0002\u0016\u0007>dW/\u001c8EK\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0011\u001d1\u0017#%A\u0005\u0002\u001d\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u00015+\u0005%\\\u0005C\u00016r\u001b\u0005Y'B\u00017n\u0003\u001d\u0019\u0007.\u00198oK2T!A\\8\u0002\u000b9,G\u000f^=\u000b\u0003A\f!![8\n\u0005I\\'AD#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\biF\t\n\u0011\"\u0001v\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\taO\u000b\u0002x\u0017B\u0011\u0001P_\u0007\u0002s*\u0011QEF\u0005\u0003wf\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0007\tI\u0011\u0001!`\n\byRq\u0018\u0011BA\b!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u0003\u0003\u0015\u0019w\u000eZ3d\u0013\u0011\t9!!\u0001\u00039A{7\u000f^4sKN\u000bFjQ8o]\u0016\u001cG/[8o\t\u0016dWmZ1uKB\u0019\u0001*a\u0003\n\u0007\u00055AA\u0001\u0006D_:tWm\u0019;j_:\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+!\u0011\u0001\u00029p_2LA!!\u0007\u0002\u0014\t\u0001B+[7f_V$8k\u00195fIVdWM\u001d\u0005\n\u0003;a(\u0011!Q\u0001\n\u001d\u000bQbY8oM&<WO]1uS>t\u0007\"CA\u0011y\n\u0005\t\u0015!\u0003Y\u0003=)gnY8eKJ\u0014VmZ5tiJL\b\"CA\u0013y\n\u0005\t\u0015!\u0003c\u0003=!WmY8eKJ\u0014VmZ5tiJL\b\"CA\u0015y\n\u0005\t\u0015!\u0003j\u0003\u00159'o\\;q\u0011)\ti\u0003 BC\u0002\u0013\r\u0011qF\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012a\u001e\u0005\n\u0003ga(\u0011!Q\u0001\n]\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0011\u0019YB\u0010\"\u0001\u00028Qa\u0011\u0011HA\u001e\u0003{\ty$!\u0011\u0002DA\u0011\u0001\u0003 \u0005\n\u0003;\t)\u0004%AA\u0002\u001dC\u0011\"!\t\u00026A\u0005\t\u0019\u0001-\t\u0013\u0005\u0015\u0012Q\u0007I\u0001\u0002\u0004\u0011\u0007\"CA\u0015\u0003k\u0001\n\u00111\u0001j\u0011%\ti#!\u000e\u0011\u0002\u0003\u000fq\u000fC\u0005\u0002Hq\u0014\r\u0011\"\u0004\u0002J\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005-\u0003cA@\u0002N%!\u0011qJA\u0001\u0005m\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\"\u000bg\u000e\u001a7fe\"A\u00111\u000b?!\u0002\u001b\tY%\u0001\nd_:tWm\u0019;j_:D\u0015M\u001c3mKJ\u0004\u0003\"CA,y\n\u0007IQBA-\u00031\u0019WO\u001d:f]R\u001cu.\u001e8u+\t\tY\u0006E\u0002\u0016\u0003;J1!a\u0018\u0017\u0005\u0011auN\\4\t\u0011\u0005\rD\u0010)A\u0007\u00037\nQbY;se\u0016tGoQ8v]R\u0004\u0003\"CA4y\n\u0007IQBA5\u0003e\u0001(/\u001a9be\u0016$7\u000b^1uK6,g\u000e^:D_VtG/\u001a:\u0016\u0005\u0005-\u0004cA\u0011\u0002n%\u0019\u0011q\u000e\u0012\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\t\u0019\b Q\u0001\u000e\u0005-\u0014A\u00079sKB\f'/\u001a3Ti\u0006$X-\\3oiN\u001cu.\u001e8uKJ\u0004\u0003\"CA<y\n\u0007I\u0011BA=\u0003=\u0001\u0018M]1nKR,'o\u0015;biV\u001cXCAA>!!\ti(a\"\u0002\f\u0006-UBAA@\u0015\u0011\t\t)a!\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u0011\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\n\u0006}$a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003\u001b\u000b\u0019JD\u0002\u0016\u0003\u001fK1!!%\u0017\u0003\u0019\u0001&/\u001a3fM&!\u0011QSAL\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0013\f\t\u0011\u0005mE\u0010)A\u0005\u0003w\n\u0001\u0003]1sC6,G/\u001a:Ti\u0006$Xo\u001d\u0011\t\u0013\u0005}EP1A\u0005\n\u0005\u0005\u0016\u0001\u00059beN,Gm\u0015;bi\u0016lWM\u001c;t+\t\t\u0019\u000b\u0005\u0005\u0002~\u0005\u001d\u00151RAS!\r\u0001\u0012qU\u0005\u0004\u0003S\u0013!a\u0006)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"{G\u000eZ3s\u0011!\ti\u000b Q\u0001\n\u0005\r\u0016!\u00059beN,Gm\u0015;bi\u0016lWM\u001c;tA!I\u0011\u0011\u0017?A\u0002\u0013%\u00111W\u0001\u000eCV$\b.\u001a8uS\u000e\fG/\u001a3\u0016\u0005\u0005U\u0006cA\u000b\u00028&\u0019\u0011\u0011\u0018\f\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0018?A\u0002\u0013%\u0011qX\u0001\u0012CV$\b.\u001a8uS\u000e\fG/\u001a3`I\u0015\fH\u0003BAa\u0003\u000f\u00042!FAb\u0013\r\t)M\u0006\u0002\u0005+:LG\u000f\u0003\u0006\u0002J\u0006m\u0016\u0011!a\u0001\u0003k\u000b1\u0001\u001f\u00132\u0011!\ti\r Q!\n\u0005U\u0016AD1vi\",g\u000e^5dCR,G\r\t\u0005\n\u0003#d(\u0019!C\u0005\u0003'\f\u0001cY8o]\u0016\u001cG/[8o\rV$XO]3\u0016\u0005\u0005U\u0007#\u0002=\u0002X\u0006%\u0011bAAms\n9\u0001K]8nSN,\u0007\u0002CAoy\u0002\u0006I!!6\u0002#\r|gN\\3di&|gNR;ukJ,\u0007\u0005C\u0005\u0002br\u0004\r\u0011\"\u0003\u00024\u0006Y!/Z2f]R,%O]8s\u0011%\t)\u000f a\u0001\n\u0013\t9/A\bsK\u000e,g\u000e^#se>\u0014x\fJ3r)\u0011\t\t-!;\t\u0015\u0005%\u00171]A\u0001\u0002\u0004\t)\f\u0003\u0005\u0002nr\u0004\u000b\u0015BA[\u00031\u0011XmY3oi\u0016\u0013(o\u001c:!\u0011%\t\t\u0010 b\u0001\n\u0013\t\u00190A\u000brk\u0016\u0014\u0018\u0010\u0015:p[&\u001cXMU3gKJ,gnY3\u0016\u0005\u0005U\b#B\u0011\u0002x\u0006m\u0018bAA}E\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0003\u0016\u0003{\u0014\t!C\u0002\u0002\u0000Z\u0011aa\u00149uS>t\u0007#\u0002=\u0002X\n\r\u0001c\u0001%\u0003\u0006%\u0019!q\u0001\u0003\u0003\u0017E+XM]=SKN,H\u000e\u001e\u0005\t\u0005\u0017a\b\u0015!\u0003\u0002v\u00061\u0012/^3ssB\u0013x.\\5tKJ+g-\u001a:f]\u000e,\u0007\u0005C\u0005\u0003\u0010q\u0004\r\u0011\"\u0003\u0003\u0012\u0005a1-\u001e:sK:$\u0018+^3ssV\u0011!1\u0003\t\u0006+\u0005u(Q\u0003\t\u0007\u0005/\u0011iB!\t\u000e\u0005\te!b\u0001B\u000e\t\u00059q-\u001a8fe\u0006d\u0017\u0002\u0002B\u0010\u00053\u0011\u0001#T;uC\ndWMU3tk2$8+\u001a;\u0011\t\t\r\"QF\u0007\u0003\u0005KQAAa\n\u0003*\u00059!-Y2lK:$'b\u0001B\u0016\u0005\u0005AQ.Z:tC\u001e,7/\u0003\u0003\u00030\t\u0015\"\u0001\u0006)pgR<'/Z*R\u0019\u000e{G.^7o\t\u0006$\u0018\rC\u0005\u00034q\u0004\r\u0011\"\u0003\u00036\u0005\u00012-\u001e:sK:$\u0018+^3ss~#S-\u001d\u000b\u0005\u0003\u0003\u00149\u0004\u0003\u0006\u0002J\nE\u0012\u0011!a\u0001\u0005'A\u0001Ba\u000f}A\u0003&!1C\u0001\u000eGV\u0014(/\u001a8u#V,'/\u001f\u0011\t\u0013\t}B\u00101A\u0005\n\t\u0005\u0013\u0001G2veJ,g\u000e\u001e)sKB\f'/\u001a3Ti\u0006$X-\\3oiV\u0011!1\t\t\u0006+\u0005u\u0018Q\u0015\u0005\n\u0005\u000fb\b\u0019!C\u0005\u0005\u0013\nAdY;se\u0016tG\u000f\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002B\n-\u0003BCAe\u0005\u000b\n\t\u00111\u0001\u0003D!A!q\n?!B\u0013\u0011\u0019%A\rdkJ\u0014XM\u001c;Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R\u0004\u0003\"\u0003B*y\u0002\u0007I\u0011\u0002B+\u0003\u001d1XM]:j_:,\"Aa\u0016\u0011\t\te#QL\u0007\u0003\u00057R!a\n\u0003\n\t\t}#1\f\u0002\b-\u0016\u00148/[8o\u0011%\u0011\u0019\u0007 a\u0001\n\u0013\u0011)'A\u0006wKJ\u001c\u0018n\u001c8`I\u0015\fH\u0003BAa\u0005OB!\"!3\u0003b\u0005\u0005\t\u0019\u0001B,\u0011!\u0011Y\u0007 Q!\n\t]\u0013\u0001\u0003<feNLwN\u001c\u0011\t\u0013\t=D\u00101A\u0005\n\tE\u0014a\u00048pi&4\u0017\u0010T5ti\u0016tWM]:\u0016\u0005\tM\u0004C\u0002B;\u0005o\u0012Y(D\u0001%\u0013\r\u0011I\b\n\u0002\u0015\u0007>\u0004\u0018p\u00148Xe&$X-\u0011:sCfd\u0015n\u001d;\u0011\u000fU\u0011iH!!\u0002B&\u0019!q\u0010\f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002B\u0012\u0005\u0007KAA!\"\u0003&\t!bj\u001c;jM&\u001c\u0017\r^5p]J+7\u000f]8og\u0016D\u0011B!#}\u0001\u0004%IAa#\u0002'9|G/\u001b4z\u0019&\u001cH/\u001a8feN|F%Z9\u0015\t\u0005\u0005'Q\u0012\u0005\u000b\u0003\u0013\u00149)!AA\u0002\tM\u0004\u0002\u0003BIy\u0002\u0006KAa\u001d\u0002!9|G/\u001b4z\u0019&\u001cH/\u001a8feN\u0004\u0003\"\u0003BKy\u0002\u0007I\u0011\u0002BL\u0003-\tX/\u001a:z%\u0016\u001cX\u000f\u001c;\u0016\u0005\te\u0005#B\u000b\u0002~\n\r\u0001\"\u0003BOy\u0002\u0007I\u0011\u0002BP\u0003=\tX/\u001a:z%\u0016\u001cX\u000f\u001c;`I\u0015\fH\u0003BAa\u0005CC!\"!3\u0003\u001c\u0006\u0005\t\u0019\u0001BM\u0011!\u0011)\u000b Q!\n\te\u0015\u0001D9vKJL(+Z:vYR\u0004\u0003b\u0002BUy\u0012\u0005#1V\u0001\u000fKZ,g\u000e\u001e'p_B<%o\\;q+\u0005I\u0007b\u0002BXy\u0012\u0005\u00111W\u0001\u0010SN\u0014V-\u00193z\r>\u0014\u0018+^3ss\"9!1\u0017?\u0005\u0002\tU\u0016aB2p]:,7\r^\u000b\u0003\u0005o\u0003R\u0001\u001fB]\u0003\u0013I1Aa/z\u0005\u00191U\u000f^;sK\"9!q\u0018?\u0005B\tU\u0016A\u00033jg\u000e|gN\\3di\"9!1\u0019?\u0005B\t\u0015\u0017!C8o)&lWm\\;u+\t\t\t\rC\u0004\u0003Jr$\t%a-\u0002\u0017%\u001c8i\u001c8oK\u000e$X\r\u001a\u0005\b\u0005\u001bdH\u0011\u0001Bh\u0003E\u0001\u0018M]1nKR,'o\u0015;biV\u001cXm]\u000b\u0003\u0005#\u0004\u0002Ba5\u0003Z\u0006-\u00151R\u0007\u0003\u0005+TAAa6\u0002\u0004\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u00057\u0014)NA\u0002NCBDqAa8}\t\u0003\u0012\t/A\u0005tK:$\u0017+^3ssR!!1\u001dBs!\u0015A(\u0011\u0018B\u0002\u0011!\u00119O!8A\u0002\u0005-\u0015!B9vKJL\bb\u0002Bvy\u0012\u0005#Q^\u0001\u0016g\u0016tG\r\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u)\u0019\u0011\u0019Oa<\u0003r\"A!q\u001dBu\u0001\u0004\tY\t\u0003\u0006\u0003t\n%\b\u0013!a\u0001\u0005k\faA^1mk\u0016\u001c\bC\u0002B|\u0007\u000f\u0019iA\u0004\u0003\u0003z\u000e\ra\u0002\u0002B~\u0007\u0003i!A!@\u000b\u0007\t}h\"\u0001\u0004=e>|GOP\u0005\u0002/%\u00191Q\u0001\f\u0002\u000fA\f7m[1hK&!1\u0011BB\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0007\u000b1\u0002cA\u000b\u0004\u0010%\u00191\u0011\u0003\f\u0003\u0007\u0005s\u0017\u0010C\u0004\u0004\u0016q$\tea\u0006\u0002\u000f=tWI\u001d:peR!\u0011\u0011YB\r\u0011!\u0019Yba\u0005A\u0002\ru\u0011!C3yG\u0016\u0004H/[8o!\u0011\u00119pa\b\n\t\r\u000521\u0002\u0002\n)\"\u0014xn^1cY\u0016Dqa!\n}\t\u0003\t\u0019,\u0001\biCN\u0014VmY3oi\u0016\u0013(o\u001c:\t\u000f\r%B\u0010\"\u0003\u0004,\u0005\t2/\u001a;FeJ|'o\u00148GkR,(/Z:\u0015\t\u0005\u00057Q\u0006\u0005\t\u0007_\u00199\u00031\u0001\u0004\u001e\u0005\tQ\rC\u0004\u00044q$\te!\u000e\u0002\u001f=t'+Z1es\u001a{'/U;fef$\"!!1\t\u000f\rUA\u0010\"\u0011\u0004:Q!\u0011\u0011YB\u001e\u0011!\u0019ida\u000eA\u0002\r}\u0012!A7\u0011\t\t\r2\u0011I\u0005\u0005\u0007\u0007\u0012)C\u0001\u0007FeJ|'/T3tg\u0006<W\rC\u0004\u0004Hq$\te!\u0013\u0002#=t7i\\7nC:$7i\\7qY\u0016$X\r\u0006\u0003\u0002B\u000e-\u0003\u0002CB\u001f\u0007\u000b\u0002\ra!\u0014\u0011\t\t\r2qJ\u0005\u0005\u0007#\u0012)C\u0001\fD_6l\u0017M\u001c3D_6\u0004H.\u001a;f\u001b\u0016\u001c8/Y4f\u0011\u001d\u0019)\u0006 C!\u0007/\n\u0011c\u001c8QCJ\fW.\u001a;feN#\u0018\r^;t)\u0011\t\tm!\u0017\t\u0011\ru21\u000ba\u0001\u00077\u0002BAa\t\u0004^%!1q\fB\u0013\u0005Y\u0001\u0016M]1nKR,'o\u0015;biV\u001cX*Z:tC\u001e,\u0007bBB2y\u0012\u00053QM\u0001\n_:$\u0015\r^1S_^$B!!1\u0004h!A1QHB1\u0001\u0004\u0019I\u0007\u0005\u0003\u0003$\r-\u0014\u0002BB7\u0005K\u0011a\u0002R1uCJ{w/T3tg\u0006<W\rC\u0004\u0004rq$\tea\u001d\u0002!=t'k\\<EKN\u001c'/\u001b9uS>tG\u0003BAa\u0007kB\u0001b!\u0010\u0004p\u0001\u00071q\u000f\t\u0005\u0005G\u0019I(\u0003\u0003\u0004|\t\u0015\"!\u0006*po\u0012+7o\u0019:jaRLwN\\'fgN\fw-\u001a\u0005\b\u0007\u007fbH\u0011BBA\u00039\u0019X\r^\"pYVlg\u000eR1uCN$B!!1\u0004\u0004\"A1QQB?\u0001\u0004\u00199)A\u0006d_2,XN\u001c#bi\u0006\u001c\b#B\u000b\u0004\n\n\u0005\u0012bABF-\t)\u0011I\u001d:bs\"91q\u0012?\u0005B\rE\u0015\u0001G8o\u0003V$\b.\u001a8uS\u000e\fG/[8o%\u0016\u001c\bo\u001c8tKR!\u0011\u0011YBJ\u0011!\u0019)j!$A\u0002\r]\u0015aB7fgN\fw-\u001a\t\u0005\u0005G\u0019I*\u0003\u0003\u0004\u001c\n\u0015\"!F!vi\",g\u000e^5dCRLwN\\'fgN\fw-\u001a\u0005\b\u0007?cH\u0011IBQ\u0003YygNT8uS\u001aL7-\u0019;j_:\u0014Vm\u001d9p]N,G\u0003BAa\u0007GC\u0001b!&\u0004\u001e\u0002\u0007!\u0011\u0011\u0005\b\u0007OcH\u0011ABU\u0003Y\u0011XmZ5ti\u0016\u0014hj\u001c;jMfd\u0015n\u001d;f]\u0016\u0014H\u0003BAa\u0007WC\u0001b!,\u0004&\u0002\u0007!1P\u0001\tY&\u001cH/\u001a8fe\"91\u0011\u0017?\u0005\u0002\rM\u0016\u0001G;oe\u0016<\u0017n\u001d;fe:{G/\u001b4z\u0019&\u001cH/\u001a8feR!\u0011\u0011YB[\u0011!\u0019ika,A\u0002\tm\u0004bBB]y\u0012\u00051QG\u0001\u0015G2,\u0017M\u001d(pi&4\u0017\u0010T5ti\u0016tWM]:\t\u000f\ruF\u0010\"\u0003\u0004@\u0006Q1M]3eK:$\u0018.\u00197\u0015\t\r\u00057Q\u001a\t\u0005\u0007\u0007\u001cI-\u0004\u0002\u0004F*!1q\u0019B\u0015\u0003!1'o\u001c8uK:$\u0017\u0002BBf\u0007\u000b\u0014\u0011c\u0011:fI\u0016tG/[1m\u001b\u0016\u001c8/Y4f\u0011!\u0019yma/A\u0002\rE\u0017!F1vi\",g\u000e^5dCRLwN\\'fgN\fw-\u001a\t\u0005\u0005G\u0019\u0019.\u0003\u0003\u0004V\n\u0015\"AH!vi\",g\u000e^5dCRLwN\\\"iC2dWM\\4f\u001b\u0016\u001c8/Y4f\u0011!\u0019I\u000e Q\u0005\n\rm\u0017!\u00068piJ+\u0017\rZ=G_J\fV/\u001a:z\u000bJ\u0014xN\u001d\u000b\u0007\u0007;\u001c\u0019oa:\u0011\u0007U\u0019y.C\u0002\u0004bZ\u0011qAT8uQ&tw\r\u0003\u0005\u0004f\u000e]\u0007\u0019AAF\u00031)'O]8s\u001b\u0016\u001c8/Y4f\u0011!\u0019Ioa6A\u0002\u0005U\u0016\u0001\u0002:bG\u0016Dqa!<}\t\u0003\u0019y/A\u000ewC2LG-\u0019;f\u0013\u001aLE/S:SK\u0006$\u0017PR8s#V,'/\u001f\u000b\u0005\u0003\u0003\u001c\t\u0010\u0003\u0005\u0004f\u000e-\b\u0019AAF\u0011\u001d\u0019)\u0010 C\u0005\u0007o\fQB^1mS\u0012\fG/Z)vKJLH\u0003BAa\u0007sD\u0001Ba:\u0004t\u0002\u0007\u00111\u0012\u0005\b\u0007{dH\u0011BB\u0000\u00031\tX/\u001a:z!J|W.[:f+\t\tY\u0010C\u0004\u0005\u0004q$I\u0001\"\u0002\u0002\u001fM,G/U;fef\u0004&o\\7jg\u0016$B!!1\u0005\b!AA\u0011\u0002C\u0001\u0001\u0004\u0011\t!A\u0004qe>l\u0017n]3\t\u000f\u00115A\u0010\"\u0003\u0004\u0000\u0006\t2\r\\3beF+XM]=Qe>l\u0017n]3\t\u000f\u0011EA\u0010\"\u0003\u0005\u0014\u0005\u0001b-Y5m#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003\u0003$)\u0002\u0003\u0005\u0005\u0018\u0011=\u0001\u0019AB\u000f\u0003\u0005!\bb\u0002C\u000ey\u0012%AQD\u0001\u0014gV\u001c7-Z3e#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003\u0003$y\u0002\u0003\u0005\u0005\"\u0011e\u0001\u0019\u0001B\u0002\u0003\u0019\u0011Xm];mi\"9AQ\u0005?\u0005\n\u0011\u001d\u0012!B<sSR,G\u0003BAa\tSA\u0001b!&\u0005$\u0001\u0007A1\u0006\t\u0005\u0007\u0007$i#\u0003\u0003\u00050\r\u0015'!D\"mS\u0016tG/T3tg\u0006<W\rC\u0004\u00054q$\t\u0005\"\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a#\t\u0013\u0011eB0%A\u0005B\u0011m\u0012aH:f]\u0012\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011AQ\b\u0016\u0004\u0005k\\\u0005")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection,
TimeoutScheduler {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final EventLoopGroup group;
    private final ExecutionContext executionContext;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Option<PreparedStatementHolder> currentPreparedStatement;
    private Version version;
    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners;
    private Option<QueryResult> queryResult;
    private AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static EventLoopGroup $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool() {
        return this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;
    }

    public void com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool_$eq(AtomicBoolean x$1) {
        this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool = x$1;
    }

    public boolean isTimeouted() {
        return TimeoutScheduler.class.isTimeouted((TimeoutScheduler)this);
    }

    public <A> Option<ScheduledFuture<?>> addTimeout(Promise<A> promise, Option<Duration> durationOption, ExecutionContext executionContext) {
        return TimeoutScheduler.class.addTimeout((TimeoutScheduler)this, promise, durationOption, (ExecutionContext)executionContext);
    }

    public ScheduledFuture<?> schedule(Function0<BoxedUnit> block, Duration duration) {
        return TimeoutScheduler.class.schedule((TimeoutScheduler)this, block, (Duration)duration);
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.class.inTransaction((Connection)this, f, (ExecutionContext)executionContext);
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    public final AtomicInteger com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    public HashMap<String, PreparedStatementHolder> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    public Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<MutableResultSet<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<PreparedStatementHolder> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<PreparedStatementHolder> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners() {
        return this.notifyListeners;
    }

    private void notifyListeners_$eq(CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> x$1) {
        this.notifyListeners = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.group;
    }

    public boolean isReadyForQuery() {
        return this.queryPromise().isEmpty();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onFailure((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.executionContext());
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final PostgreSQLConnection apply(PostgreSQLConnectionHandler c) {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.executionContext());
    }

    public void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap(Predef$.MODULE$.conforms());
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.write(new QueryMessage(query));
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        PreparedStatementMessage preparedStatementMessage;
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        PreparedStatementHolder holder = (PreparedStatementHolder)this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements().getOrElseUpdate((Object)query, (Function0)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;
            private final String query$1;

            public final PreparedStatementHolder apply() {
                return new PreparedStatementHolder(this.query$1, this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter().incrementAndGet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
        if (holder.paramsCount() != values.length()) {
            this.clearQueryPromise();
            throw new InsufficientParametersException(holder.paramsCount(), values);
        }
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)new Some((Object)holder));
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)new Some((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])holder.columnDatas()))));
        if (holder.prepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        } else {
            holder.prepared_$eq(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().isCompleted()) {
            future = BoxedUnit.UNIT;
        } else {
            this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().failure(e);
            future = this.disconnect();
        }
        this.currentPreparedStatement().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final Option<PreparedStatementHolder> apply(PreparedStatementHolder p) {
                return this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements().remove((Object)p.query());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().trySuccess((Object)this);
        this.recentError_$eq(false);
        this.queryResult().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final void apply(QueryResult result) {
                this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(result);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", new Object[]{m});
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery())));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        this.parameterStatus().put((Object)m.key(), (Object)m.value());
        String string = m.key();
        if (!("server_version" != null ? !"server_version".equals(string) : string != null)) {
            this.version_$eq(Version$.MODULE$.apply(m.value()));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[Predef$.MODULE$.refArrayOps((Object[])m.values()).size()];
        int x = 0;
        while (true) {
            Object object;
            if (x >= Predef$.MODULE$.refArrayOps((Object[])m.values()).size()) {
                ((MutableResultSet)this.currentQuery().get()).addRow(items);
                return;
            }
            ByteBuf buf = m.values()[x];
            if (buf == null) {
                object = null;
            } else {
                try {
                    PostgreSQLColumnData columnType = (PostgreSQLColumnData)((MutableResultSet)this.currentQuery().get()).columnTypes().apply(x);
                    object = this.decoderRegistry.decode((ColumnData)columnType, buf, this.configuration.charset());
                }
                catch (Throwable throwable) {
                    void var4_4;
                    var4_4.release();
                    throw throwable;
                }
                buf.release();
            }
            items[x] = object;
            ++x;
        }
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])m.columnDatas()))));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(PostgreSQLColumnData[] columnDatas) {
        this.currentPreparedStatement().foreach((Function1)new Serializable(this, columnDatas){
            public static final long serialVersionUID = 0L;
            private final PostgreSQLColumnData[] columnDatas$1;

            public final void apply(PreparedStatementHolder holder) {
                holder.columnDatas_$eq(this.columnDatas$1);
            }
            {
                this.columnDatas$1 = columnDatas$1;
            }
        });
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage;
        block5: {
            block3: {
                block4: {
                    block2: {
                        authenticationMessage = message;
                        if (!(authenticationMessage instanceof AuthenticationOkMessage)) break block2;
                        PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
                        this.authenticated_$eq(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(authenticationMessage instanceof AuthenticationChallengeCleartextMessage)) break block4;
                    AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
                    this.write(this.credential(authenticationChallengeCleartextMessage));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(authenticationMessage instanceof AuthenticationChallengeMD5)) break block5;
                AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
                this.write(this.credential(authenticationChallengeMD5));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)authenticationMessage);
    }

    @Override
    public void onNotificationResponse(NotificationResponse message) {
        Iterator<Function1<NotificationResponse, BoxedUnit>> iterator = this.notifyListeners().iterator();
        while (iterator.hasNext()) {
            iterator.next().apply((Object)message);
        }
    }

    public void registerNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().add(listener);
    }

    public void unregisterNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().remove(listener);
    }

    public void clearNotifyListeners() {
        this.notifyListeners().clear();
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() != null && this.configuration.password().isDefined()) {
            return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
        }
        throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
    }

    private Nothing$ notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnection$.MODULE$.log().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.currentCount(), race);
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            throw this.notReadyForQueryError(errorMessage, false);
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            return;
        }
        throw this.notReadyForQueryError("Can't run query due to a race with another started query", true);
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> promise) {
                PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", new Object[]{promise});
                return promise.failure(this.t$1);
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public void com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(QueryResult result) {
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)None$.MODULE$);
        this.clearQueryPromise().foreach((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final QueryResult result$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> x$1) {
                return x$1.success((Object)this.result$1);
            }
            {
                this.result$1 = result$1;
            }
        });
    }

    private void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "{counter=", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToLong((long)this.currentCount())}));
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        this.group = group;
        this.executionContext = executionContext;
        Connection.class.$init$((Connection)this);
        TimeoutScheduler.class.$init$((TimeoutScheduler)this);
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, group, executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter = new AtomicInteger();
        this.parameterStatus = new HashMap();
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements = new HashMap();
        this.authenticated = false;
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.notifyListeners = new CopyOnWriteArrayList();
        this.queryResult = None$.MODULE$;
    }
}

