/*
 * Decompiled with CFR 0.152.
 */
package com.github.matsluni.akkahttpspi;

import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.HttpCharset$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaType$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.Uri$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.github.matsluni.akkahttpspi.AkkaHttpClient;
import com.github.matsluni.akkahttpspi.AkkaHttpClient$AkkaHttpClientBuilder$;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.Nothing$;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

public final class AkkaHttpClient$ {
    public static final AkkaHttpClient$ MODULE$;
    private final Logger logger;
    private ContentType.Binary xAmzJson;
    private ContentType.Binary xAmzJson11;
    private ContentType.WithCharset formUrlEncoded;
    private ContentType.Binary applicationXml;
    private volatile byte bitmap$0;

    static {
        new AkkaHttpClient$();
    }

    private ContentType.Binary xAmzJson$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.xAmzJson = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.0", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.xAmzJson;
        }
    }

    private ContentType.Binary xAmzJson11$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.xAmzJson11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.xAmzJson11;
        }
    }

    private ContentType.WithCharset formUrlEncoded$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.formUrlEncoded = ContentType$.MODULE$.apply(MediaType$.MODULE$.applicationWithOpenCharset("x-www-form-urlencoded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), HttpCharset$.MODULE$.custom("utf-8", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.formUrlEncoded;
        }
    }

    private ContentType.Binary applicationXml$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.applicationXml = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "xml", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.applicationXml;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public HttpRequest toAkkaRequest(SdkHttpRequest request, SdkHttpContentPublisher contentPublisher) {
        List<HttpHeader> headers = this.convertHeaders(request.headers());
        HttpMethod method = this.convertMethod(request.method().name());
        return HttpRequest$.MODULE$.apply(method, Uri$.MODULE$.apply(request.getUri().toString()), this.filterContentTypeAndContentLengthHeader((Seq<HttpHeader>)headers), this.entityForMethodAndContentType(method, this.contentTypeHeaderToContentType(headers), contentPublisher), HttpProtocols$.MODULE$.HTTP$div1$u002E1());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestEntity entityForMethodAndContentType(HttpMethod method, ContentType contentType, SdkHttpContentPublisher contentPublisher) {
        HttpEntity.Chunked chunked;
        RequestEntityAcceptance requestEntityAcceptance = method.requestEntityAcceptance();
        if (!RequestEntityAcceptance.Expected$.MODULE$.equals(requestEntityAcceptance)) return HttpEntity$.MODULE$.empty(HttpEntity$.MODULE$.Empty().contentType());
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(contentPublisher.contentLength()));
        if (option instanceof Some) {
            Some some = (Some)option;
            Long length = (Long)some.x();
            chunked = HttpEntity$.MODULE$.apply(contentType, Predef$.MODULE$.Long2long(length), (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ByteString apply(ByteBuffer x$1) {
                    return ByteString$.MODULE$.apply(x$1);
                }
            }));
            return chunked;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            chunked = HttpEntity$.MODULE$.apply(contentType, (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ByteString apply(ByteBuffer x$2) {
                    return ByteString$.MODULE$.apply(x$2);
                }
            }));
        }
        return chunked;
    }

    public HttpMethod convertMethod(String method) {
        return (HttpMethod)HttpMethods$.MODULE$.getForKeyCaseInsensitive(method, Predef$.MODULE$.$conforms()).getOrElse((Function0)new Serializable(method){
            public static final long serialVersionUID = 0L;
            private final String method$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Method not configured: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$1})));
            }
            {
                this.method$1 = method$1;
            }
        });
    }

    public ContentType contentTypeHeaderToContentType(List<HttpHeader> headers) {
        Option option;
        block9: {
            ContentType.Binary binary;
            block3: {
                block8: {
                    Some some;
                    boolean bl;
                    block7: {
                        String string;
                        block6: {
                            String string2;
                            block5: {
                                String string3;
                                block4: {
                                    String string4;
                                    block2: {
                                        bl = false;
                                        some = null;
                                        option = headers.find((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(HttpHeader x$3) {
                                                String string = x$3.lowercaseName();
                                                String string2 = "content-type";
                                                return !(string != null ? !string.equals(string2) : string2 != null);
                                            }
                                        }).map((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(HttpHeader x$4) {
                                                return x$4.value();
                                            }
                                        });
                                        if (!(option instanceof Some)) break block2;
                                        bl = true;
                                        some = (Some)option;
                                        String string5 = (String)some.x();
                                        if (!"application/x-amz-json-1.0".equals(string5)) break block2;
                                        binary = this.xAmzJson();
                                        break block3;
                                    }
                                    if (!bl || !"application/x-amz-json-1.1".equals(string4 = (String)some.x())) break block4;
                                    binary = this.xAmzJson11();
                                    break block3;
                                }
                                if (!bl || !"application/x-www-form-urlencoded; charset=UTF-8".equals(string3 = (String)some.x())) break block5;
                                binary = this.formUrlEncoded();
                                break block3;
                            }
                            if (!bl || !"application/x-www-form-urlencoded".equals(string2 = (String)some.x())) break block6;
                            binary = this.formUrlEncoded();
                            break block3;
                        }
                        if (!bl || !"application/xml".equals(string = (String)some.x())) break block7;
                        binary = this.applicationXml();
                        break block3;
                    }
                    if (!bl) break block8;
                    String s = (String)some.x();
                    binary = this.tryCreateCustomContentType(s);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block9;
                binary = this.formUrlEncoded();
            }
            return binary;
        }
        throw new MatchError((Object)option);
    }

    public List<HttpHeader> convertHeaders(Map<String, java.util.List<String>> headers) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(headers).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HttpHeader apply(Tuple2<String, java.util.List<String>> x0$1) {
                Tuple2<String, java.util.List<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    java.util.List value = (java.util.List)tuple2._2();
                    if (value.size() > 1 || value.size() == 0) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found invalid header: key: ", ", Value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(value).asScala()).toList()})));
                    }
                    HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse(key, (String)value.get(0), HttpHeader$.MODULE$.parse$default$3());
                    if (parsingResult instanceof HttpHeader.ParsingResult$.Ok) {
                        HttpHeader httpHeader;
                        HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                        HttpHeader httpHeader2 = httpHeader = ok.header();
                        return httpHeader2;
                    }
                    if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
                        HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found invalid header: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error.errors()})));
                    }
                    throw new MatchError((Object)parsingResult);
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public scala.collection.immutable.Seq<HttpHeader> filterContentTypeAndContentLengthHeader(Seq<HttpHeader> headers) {
        return ((TraversableOnce)headers.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(HttpHeader h) {
                String string = h.lowercaseName();
                String string2 = "content-type";
                if (string == null) {
                    if (string2 == null) return true;
                } else if (string.equals(string2)) return true;
                String string3 = h.lowercaseName();
                String string4 = "content-length";
                if (string3 != null) {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
                if (string4 == null) return true;
                return false;
            }
        })).toList();
    }

    public ContentType tryCreateCustomContentType(String contentTypeStr) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to parse content type from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{contentTypeStr})));
        String[] mainAndsubType = new StringOps(Predef$.MODULE$.augmentString(contentTypeStr)).split('/');
        if (mainAndsubType.length == 2) {
            return ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary(mainAndsubType[0], mainAndsubType[1], (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse custom content type '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{contentTypeStr})));
    }

    public AkkaHttpClient.AkkaHttpClientBuilder builder() {
        return new AkkaHttpClient.AkkaHttpClientBuilder(AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$1(), AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$2());
    }

    public ContentType.Binary xAmzJson() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.xAmzJson$lzycompute() : this.xAmzJson;
    }

    public ContentType.Binary xAmzJson11() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.xAmzJson11$lzycompute() : this.xAmzJson11;
    }

    public ContentType.WithCharset formUrlEncoded() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.formUrlEncoded$lzycompute() : this.formUrlEncoded;
    }

    public ContentType.Binary applicationXml() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.applicationXml$lzycompute() : this.applicationXml;
    }

    private AkkaHttpClient$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

