/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.DataTableException$;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class IndexedSeqExtensions$ {
    public static IndexedSeqExtensions$ MODULE$;

    static {
        new IndexedSeqExtensions$();
    }

    public <T> Try<IndexedSeq<T>> addItem(IndexedSeq<T> items, T value) {
        return new Success(items.$colon$plus(value, IndexedSeq$.MODULE$.canBuildFrom()));
    }

    public <T> Try<IndexedSeq<T>> removeItem(IndexedSeq<T> items, int index) {
        Failure failure;
        boolean bl = this.outOfBounds(items, index);
        if (bl) {
            failure = new Failure((Throwable)new DataTableException("Item index out of bounds for remove.", DataTableException$.MODULE$.apply$default$2()));
        } else if (!bl) {
            Tuple2 tuple2 = items.splitAt(index);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            IndexedSeq dataStart = (IndexedSeq)tuple2._1();
            IndexedSeq dataEnd = (IndexedSeq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)dataStart, (Object)dataEnd);
            Tuple2 tuple23 = tuple22;
            IndexedSeq dataStart2 = (IndexedSeq)tuple23._1();
            IndexedSeq dataEnd2 = (IndexedSeq)tuple23._2();
            failure = new Success(dataStart2.$plus$plus((GenTraversableOnce)dataEnd2.tail(), IndexedSeq$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return failure;
    }

    public <T> Try<IndexedSeq<T>> replaceItem(IndexedSeq<T> items, int index, T value) {
        Failure failure;
        boolean bl = this.outOfBounds(items, index);
        if (bl) {
            failure = new Failure((Throwable)new DataTableException("Item index out of bounds for replace.", DataTableException$.MODULE$.apply$default$2()));
        } else if (!bl) {
            failure = new Success(items.updated(index, value, IndexedSeq$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return failure;
    }

    public <T> Try<IndexedSeq<T>> insertItem(IndexedSeq<T> items, int index, T value) {
        Failure failure;
        boolean bl = this.outOfBounds(items, index);
        if (bl) {
            failure = new Failure((Throwable)new DataTableException("Item index out of bounds for insert.", DataTableException$.MODULE$.apply$default$2()));
        } else if (!bl) {
            Tuple2 tuple2 = items.splitAt(index);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            IndexedSeq dataStart = (IndexedSeq)tuple2._1();
            IndexedSeq dataEnd = (IndexedSeq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)dataStart, (Object)dataEnd);
            Tuple2 tuple23 = tuple22;
            IndexedSeq dataStart2 = (IndexedSeq)tuple23._1();
            IndexedSeq dataEnd2 = (IndexedSeq)tuple23._2();
            T t = value;
            failure = new Success(dataStart2.$plus$plus((GenTraversableOnce)dataEnd2.$plus$colon(t, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return failure;
    }

    public <T> boolean outOfBounds(IndexedSeq<T> items, int index) {
        return this.outOfBounds(items.length(), index);
    }

    public boolean outOfBounds(int itemCount, int index) {
        return itemCount == 0 || index < 0 || index >= itemCount;
    }

    private IndexedSeqExtensions$() {
        MODULE$ = this;
    }
}

