/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.DataTableFormatter;
import com.github.martincooper.datatable.DataView;
import com.github.martincooper.datatable.GenericColumn;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class DataTableFormatter$ {
    public static DataTableFormatter$ MODULE$;
    private final String lineSeparator;

    static {
        new DataTableFormatter$();
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    public String prettyPrint(DataView view) {
        return this.prettyPrint(view.table(), view.rows());
    }

    public String prettyPrint(DataTable table) {
        return this.prettyPrint(table, table);
    }

    private String prettyPrint(DataTable table, IndexedSeq<DataRow> dataRows) {
        IndexedSeq colDetails = (IndexedSeq)((TraversableLike)table.columns().zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GenericColumn column = (GenericColumn)tuple2._1();
            int index = tuple2._2$mcI$sp();
            DataTableFormatter.ColumnDetails columnDetails = new DataTableFormatter.ColumnDetails(index, column.name(), MODULE$.colWidth(index, column.name(), dataRows));
            return columnDetails;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        StringBuilder builder = new StringBuilder();
        this.printHeader(builder, (Seq<DataTableFormatter.ColumnDetails>)colDetails);
        this.printRows(builder, dataRows, (Seq<DataTableFormatter.ColumnDetails>)colDetails);
        return builder.mkString();
    }

    private void printRows(StringBuilder builder, IndexedSeq<DataRow> dataRows, Seq<DataTableFormatter.ColumnDetails> colDetails) {
        dataRows.foreach((Function1 & Serializable & scala.Serializable)dataRow -> MODULE$.printRow(builder, (DataRow)dataRow, colDetails));
    }

    private StringBuilder printRow(StringBuilder builder, DataRow dataRow, Seq<DataTableFormatter.ColumnDetails> colDetails) {
        Seq formattedValues = (Seq)colDetails.map((Function1 & Serializable & scala.Serializable)details -> {
            String textValue = dataRow.apply(details.colIdx()).toString();
            return "|" + MODULE$.colDataString(textValue, details.width());
        }, Seq$.MODULE$.canBuildFrom());
        return this.writelnExt(builder, (Traversable<Object>)formattedValues);
    }

    private StringBuilder printHeader(StringBuilder builder, Seq<DataTableFormatter.ColumnDetails> colDetails) {
        int totalLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)colDetails.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.width()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + colDetails.length() * 2;
        String headerFooter = this.padString("", totalLength, '-');
        this.writeln(builder);
        this.writelnExt(builder, (Traversable<Object>)Predef$.MODULE$.wrapString(headerFooter));
        Seq formattedHeaders = (Seq)colDetails.map((Function1 & Serializable & scala.Serializable)col -> "|" + MODULE$.colDataString(col.colName(), col.width()), Seq$.MODULE$.canBuildFrom());
        this.writelnExt(builder, (Traversable<Object>)formattedHeaders);
        return this.writelnExt(builder, (Traversable<Object>)Predef$.MODULE$.wrapString(headerFooter));
    }

    private String colDataString(String data, int width) {
        return this.padString(data, width, ' ');
    }

    private int colWidth(int colIdx, String colName, IndexedSeq<DataRow> dataRows) {
        IndexedSeq columnData = (IndexedSeq)dataRows.map((Function1 & Serializable & scala.Serializable)row -> row.apply(colIdx), IndexedSeq$.MODULE$.canBuildFrom());
        String string = colName;
        return this.maxValueLength((Iterable<Object>)((Iterable)columnData.$plus$colon((Object)string, IndexedSeq$.MODULE$.canBuildFrom()))) + 2;
    }

    private int maxValueLength(Iterable<Object> values) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)values.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DataTableFormatter$.$anonfun$maxValueLength$1(x$3)), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    private StringBuilder writeln(StringBuilder builder) {
        return builder.$plus$plus$eq(this.lineSeparator());
    }

    private StringBuilder writelnExt(StringBuilder builder, Traversable<Object> value) {
        builder.$plus$plus$eq(value.mkString());
        return builder.$plus$plus$eq(this.lineSeparator());
    }

    private String padString(String value, int width, char padString) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(value)).padTo(width, (Object)BoxesRunTime.boxToCharacter((char)padString), Predef$.MODULE$.StringCanBuildFrom()))).mkString();
    }

    public static final /* synthetic */ int $anonfun$maxValueLength$1(Object x$3) {
        return x$3.toString().length();
    }

    private DataTableFormatter$() {
        MODULE$ = this;
        this.lineSeparator = System.getProperty("line.separator");
    }
}

