/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable.DataSort;

import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataSort.DataRowSorter$;
import com.github.martincooper.datatable.DataSort.SortItem;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.DataTableException$;
import com.github.martincooper.datatable.DataView;
import com.github.martincooper.datatable.DataView$;
import com.github.martincooper.datatable.GenericColumn;
import com.github.martincooper.datatable.ItemByIndex;
import com.github.martincooper.datatable.ItemByName;
import com.github.martincooper.datatable.ItemIdentity;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Sorting$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DataSort$ {
    public static DataSort$ MODULE$;

    static {
        new DataSort$();
    }

    public Try<DataView> quickSort(DataTable table, SortItem sortItem) {
        return this.quickSort(table, (Iterable<SortItem>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{sortItem}))));
    }

    public Try<DataView> quickSort(DataTable table, Iterable<SortItem> sortItems) {
        return this.quickSort(table, (Iterable<DataRow>)table, sortItems);
    }

    public Try<DataView> quickSort(DataView dataView, SortItem sortItem) {
        return this.quickSort(dataView, (Iterable<SortItem>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{sortItem}))));
    }

    public Try<DataView> quickSort(DataView dataView, Iterable<SortItem> sortItems) {
        return this.quickSort(dataView.table(), (Iterable<DataRow>)dataView.rows(), sortItems);
    }

    public Try<DataView> quickSort(DataTable table, Iterable<DataRow> dataRows, Iterable<SortItem> sortItems) {
        Failure failure;
        Try<BoxedUnit> try_ = this.validateSortColumns(table, sortItems);
        if (try_ instanceof Success) {
            failure = this.performQuickSort(table, dataRows, sortItems);
        } else if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable ex = failure2.exception();
            failure = new Failure(ex);
        } else {
            throw new MatchError(try_);
        }
        return failure;
    }

    private Try<DataView> performQuickSort(DataTable table, Iterable<DataRow> dataRows, Iterable<SortItem> sortItems) {
        DataRow[] dataRowArray = (DataRow[])dataRows.toArray(ClassTag$.MODULE$.apply(DataRow.class));
        Ordering<DataRow> dataRowOrdering = DataRowSorter$.MODULE$.dataRowOrdering(sortItems);
        Sorting$.MODULE$.quickSort((Object)dataRowArray, dataRowOrdering);
        return DataView$.MODULE$.apply(table, (Iterable<DataRow>)Predef$.MODULE$.wrapRefArray((Object[])dataRowArray));
    }

    private Try<BoxedUnit> validateSortColumns(DataTable table, Iterable<SortItem> sortItems) {
        Failure failure;
        Try<Iterable<GenericColumn>> try_ = this.validateSortColumnIdentity(table, sortItems);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Iterable cols = (Iterable)success.value();
            failure = this.validateColumnsAreComparable((Iterable<GenericColumn>)cols);
        } else if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable ex = failure2.exception();
            failure = new Failure(ex);
        } else {
            throw new MatchError(try_);
        }
        return failure;
    }

    private Try<Iterable<GenericColumn>> validateSortColumnIdentity(DataTable table, Iterable<SortItem> sortItems) {
        Iterable columns = (Iterable)sortItems.map((Function1 & Serializable & scala.Serializable)item -> MODULE$.columnFromIdentity(table, item.columnIdentity()), Iterable$.MODULE$.canBuildFrom());
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Iterable)columns.map((Function1 & Serializable & scala.Serializable)x$1 -> (GenericColumn)x$1.get(), Iterable$.MODULE$.canBuildFrom()));
    }

    private Try<BoxedUnit> validateColumnsAreComparable(Iterable<GenericColumn> columns) {
        Success success;
        Option option = columns.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataSort$.$anonfun$validateColumnsAreComparable$1(x$2)));
        if (None$.MODULE$.equals(option)) {
            success = new Success((Object)BoxedUnit.UNIT);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            GenericColumn invalidCol = (GenericColumn)some.value();
            success = new Failure((Throwable)new DataTableException("Column '" + invalidCol.name() + "' doesn't support comparable.", DataTableException$.MODULE$.apply$default$2()));
        } else {
            throw new MatchError((Object)option);
        }
        return success;
    }

    private Try<GenericColumn> columnFromIdentity(DataTable dataTable, ItemIdentity itemIdentity) {
        Try<GenericColumn> try_;
        ItemIdentity itemIdentity2 = itemIdentity;
        if (itemIdentity2 instanceof ItemByName) {
            ItemByName itemByName = (ItemByName)itemIdentity2;
            String name = itemByName.columnName();
            try_ = dataTable.columns().get(name);
        } else if (itemIdentity2 instanceof ItemByIndex) {
            ItemByIndex itemByIndex = (ItemByIndex)itemIdentity2;
            int index = itemByIndex.columnIndex();
            try_ = dataTable.columns().get(index);
        } else {
            throw new MatchError((Object)itemIdentity2);
        }
        return try_;
    }

    public static final /* synthetic */ boolean $anonfun$validateColumnsAreComparable$1(GenericColumn x$2) {
        return !x$2.isComparable();
    }

    private DataSort$() {
        MODULE$ = this;
    }
}

