/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.utils;

import com.github.markusbernhardt.xmldoclet.xjc.AnnotationInstance;
import com.github.markusbernhardt.xmldoclet.xjc.Class;
import com.github.markusbernhardt.xmldoclet.xjc.Constructor;
import com.github.markusbernhardt.xmldoclet.xjc.Method;
import com.github.markusbernhardt.xmldoclet.xjc.ObjectFactory;
import com.github.markusbernhardt.xmldoclet.xjc.Package;
import com.github.markusbernhardt.xmldoclet.xjc.Root;
import com.github.markusbernhardt.xmldoclet.xjc.TagInfo;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class Javadoc2Libdoc {
    protected final Map<String, String> keywordDocumentationMap;

    public Javadoc2Libdoc(java.lang.Class<?> clazz) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.valueOf(clazz.getName().replace('.', '/')) + ".javadoc");
        Root root = this.loadJavadocRoot(inputStream);
        this.keywordDocumentationMap = this.loadKeywordDocumentationMap(root, clazz.getName());
    }

    public String getKeywordDocumentation(String keywordName) {
        return this.keywordDocumentationMap.get(keywordName);
    }

    protected Root loadJavadocRoot(InputStream inputStream) {
        try {
            JAXBContext context = JAXBContext.newInstance((java.lang.Class[])new java.lang.Class[]{Root.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (Root)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException jAXBException) {
            return new ObjectFactory().createRoot();
        }
    }

    protected Map<String, String> loadKeywordDocumentationMap(Root root, String className) {
        HashMap<String, String> keywordDocumentation = new HashMap<String, String>();
        for (Package packageNode : root.getPackage()) {
            for (Class classNode : packageNode.getClazz()) {
                if (className.equals(classNode.getQualified())) {
                    keywordDocumentation.put("__intro__", this.formatComment(classNode));
                    Constructor constructorNodeWithComment = null;
                    for (Constructor constructorNode : classNode.getConstructor()) {
                        if (constructorNode.getComment() == null || constructorNode.getComment().trim().length() <= 0) continue;
                        constructorNodeWithComment = constructorNode;
                    }
                    keywordDocumentation.put("__init__", this.formatComment(constructorNodeWithComment));
                }
                block3: for (Method methodNode : classNode.getMethod()) {
                    for (AnnotationInstance annotationInstanceNode : methodNode.getAnnotation()) {
                        if (!annotationInstanceNode.getName().equals("RobotKeyword")) continue;
                        keywordDocumentation.put(methodNode.getName(), this.formatComment(methodNode));
                        continue block3;
                    }
                }
            }
        }
        return keywordDocumentation;
    }

    protected String formatComment(Class classNode) {
        if (classNode.getComment() != null) {
            return classNode.getComment();
        }
        return "";
    }

    protected String formatComment(Constructor constructorNode) {
        if (constructorNode.getComment() != null) {
            return constructorNode.getComment();
        }
        return "";
    }

    protected String formatComment(Method methodNode) {
        StringBuilder stringBuilder = new StringBuilder();
        if (methodNode.getComment() != null) {
            stringBuilder.append(methodNode.getComment());
        }
        stringBuilder.append(this.formatParam(methodNode));
        stringBuilder.append(this.formatReturn(methodNode));
        stringBuilder.append(this.formatSee(methodNode));
        return stringBuilder.toString();
    }

    protected String formatParam(Method methodNode) {
        boolean hasTag = false;
        StringBuilder stringBuilderParam = new StringBuilder();
        stringBuilderParam.append("<br><b>Parameters:</b><br>");
        for (TagInfo tagInfo : methodNode.getTag()) {
            if (!tagInfo.getName().equals("@param")) continue;
            hasTag = true;
            String text = tagInfo.getText();
            int index = text.indexOf(10);
            stringBuilderParam.append("&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            stringBuilderParam.append(text.substring(0, index));
            stringBuilderParam.append("</b>&nbsp;");
            stringBuilderParam.append(text.substring(index + 1).trim());
            stringBuilderParam.append("<br>");
        }
        if (hasTag) {
            return stringBuilderParam.toString();
        }
        return "";
    }

    protected String formatReturn(Method methodNode) {
        boolean hasTag = false;
        StringBuilder stringBuilderParam = new StringBuilder();
        stringBuilderParam.append("<br><b>Returns:</b><br>");
        for (TagInfo tagInfo : methodNode.getTag()) {
            if (!tagInfo.getName().equals("@return")) continue;
            hasTag = true;
            String text = tagInfo.getText();
            stringBuilderParam.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilderParam.append(text);
            stringBuilderParam.append("<br>");
        }
        if (hasTag) {
            return stringBuilderParam.toString();
        }
        return "";
    }

    protected String formatSee(Method methodNode) {
        boolean hasTag = false;
        StringBuilder stringBuilderParam = new StringBuilder();
        stringBuilderParam.append("<br><b>See Also:</b><br>");
        for (TagInfo tagInfo : methodNode.getTag()) {
            if (!tagInfo.getName().equals("@see")) continue;
            hasTag = true;
            String camelCasedKeyword = tagInfo.getText();
            int index = camelCasedKeyword.indexOf(35);
            if (index >= 0) {
                camelCasedKeyword = camelCasedKeyword.substring(index + 1);
            }
            camelCasedKeyword = camelCasedKeyword.trim();
            stringBuilderParam.append("&nbsp;&nbsp;&nbsp;&nbsp;`");
            char[] camelCasedKeywordArray = camelCasedKeyword.toCharArray();
            stringBuilderParam.append(Character.toUpperCase(camelCasedKeywordArray[0]));
            int i = 1;
            while (i < camelCasedKeywordArray.length) {
                if (camelCasedKeywordArray[i] >= 'A' && camelCasedKeywordArray[i] <= 'Z') {
                    stringBuilderParam.append(' ');
                }
                stringBuilderParam.append(camelCasedKeywordArray[i]);
                ++i;
            }
            stringBuilderParam.append("`<br>");
        }
        if (hasTag) {
            return stringBuilderParam.toString();
        }
        return "";
    }
}

