/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.BrowserManagement;
import com.github.markusbernhardt.selenium2library.keywords.Logging;
import com.github.markusbernhardt.selenium2library.locators.TableElementFinder;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class TableElement
extends RunOnFailureKeywordsAdapter {
    @Autowired
    protected BrowserManagement browserManagement;
    @Autowired
    protected Logging logging;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    @RobotKeywordOverload
    public String getTableCell(String tableLocator, int row, int column) {
        String string = tableLocator;
        int n = row;
        int n2 = column;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        try {
            return this.getTableCell(tableLocator, row, column, "INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"tableLocator", "row", "column", "logLevel=INFO"})
    public String getTableCell(String tableLocator, int row, int column, String logLevel) {
        String string = tableLocator;
        int n = row;
        int n2 = column;
        String string2 = logLevel;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        try {
            int rowIndex = row - 1;
            int columnIndex = column - 1;
            WebElement table = TableElementFinder.find(this.browserManagement.getCurrentWebDriver(), tableLocator);
            if (table != null) {
                List rows = table.findElements(By.xpath((String)"./thead/tr"));
                if (rowIndex >= rows.size()) {
                    rows.addAll(table.findElements(By.xpath((String)"./tbody/tr")));
                }
                if (rowIndex >= rows.size()) {
                    rows.addAll(table.findElements(By.xpath((String)"./tfoot/tr")));
                }
                if (rowIndex < rows.size()) {
                    List columns = ((WebElement)rows.get(rowIndex)).findElements(By.tagName((String)"th"));
                    if (columnIndex >= columns.size()) {
                        columns.addAll(((WebElement)rows.get(rowIndex)).findElements(By.tagName((String)"td")));
                    }
                    if (columnIndex < columns.size()) {
                        return ((WebElement)columns.get(columnIndex)).getText();
                    }
                }
            }
            this.logging.logSource(logLevel);
            throw new Selenium2LibraryNonFatalException(String.format("Cell in table %s in row #%d and column #%d could not be found.", tableLocator, row, column));
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void tableCellShouldContain(String tableLocator, int row, int column, String text) {
        String string = tableLocator;
        int n = row;
        int n2 = column;
        String string2 = text;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.tableCellShouldContain(tableLocator, row, column, text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"tableLocator", "row", "column", "text", "logLevel=INFO"})
    public void tableCellShouldContain(String tableLocator, int row, int column, String text, String logLevel) {
        String string = tableLocator;
        int n = row;
        int n2 = column;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String message = String.format("Cell in table '%s' in row #%d and column #%d should have contained text '%s'.", tableLocator, row, column, text);
            String content = "";
            try {
                content = this.getTableCell(tableLocator, row, column, logLevel);
            }
            catch (Selenium2LibraryNonFatalException e) {
                this.logging.info(e.getMessage());
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Cell contains %s.", content));
            if (!content.contains(text)) {
                this.logging.logSource(logLevel);
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void tableColumnShouldContain(String tableLocator, int col, String text) {
        String string = tableLocator;
        int n = col;
        String string2 = text;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.tableColumnShouldContain(tableLocator, col, text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"tableLocator", "col", "text", "logLevel=INFO"})
    public void tableColumnShouldContain(String tableLocator, int col, String text, String logLevel) {
        String string = tableLocator;
        int n = col;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        try {
            WebElement element = TableElementFinder.findByCol(this.browserManagement.getCurrentWebDriver(), tableLocator, col, text);
            if (element == null) {
                this.logging.logSource(logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Column #%d in table identified by '%s' should have contained text '%s'.", col, tableLocator, text));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void tableFooterShouldContain(String tableLocator, String text) {
        String string = tableLocator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.tableFooterShouldContain(tableLocator, text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"tableLocator", "text", "logLevel=INFO"})
    public void tableFooterShouldContain(String tableLocator, String text, String logLevel) {
        String string = tableLocator;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        try {
            WebElement element = TableElementFinder.findByFooter(this.browserManagement.getCurrentWebDriver(), tableLocator, text);
            if (element == null) {
                this.logging.logSource(logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Footer in table identified by '%s' should have contained text '%s'.", tableLocator, text));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void tableHeaderShouldContain(String tableLocator, String text) {
        String string = tableLocator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.tableHeaderShouldContain(tableLocator, text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"tableLocator", "text", "logLevel=INFO"})
    public void tableHeaderShouldContain(String tableLocator, String text, String logLevel) {
        String string = tableLocator;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        try {
            WebElement element = TableElementFinder.findByHeader(this.browserManagement.getCurrentWebDriver(), tableLocator, text);
            if (element == null) {
                this.logging.logSource(logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Header in table identified by '%s' should have contained text '%s'.", tableLocator, text));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void tableRowShouldContain(String tableLocator, int row, String text) {
        String string = tableLocator;
        int n = row;
        String string2 = text;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.tableRowShouldContain(tableLocator, row, text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"tableLocator", "row", "text", "logLevel=INFO"})
    public void tableRowShouldContain(String tableLocator, int row, String text, String logLevel) {
        String string = tableLocator;
        int n = row;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        try {
            WebElement element = TableElementFinder.findByRow(this.browserManagement.getCurrentWebDriver(), tableLocator, row, text);
            if (element == null) {
                this.logging.logSource(logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Row #%d in table identified by '%s' should have contained text '%s'.", row, tableLocator, text));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void tableShouldContain(String tableLocator, String text) {
        String string = tableLocator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.tableShouldContain(tableLocator, text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"tableLocator", "text", "logLevel=INFO"})
    public void tableShouldContain(String tableLocator, String text, String logLevel) {
        String string = tableLocator;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        try {
            WebElement element = TableElementFinder.findByContent(this.browserManagement.getCurrentWebDriver(), tableLocator, text);
            if (element == null) {
                this.logging.logSource(logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Table identified by '%s' should have contained text '%s'.", tableLocator, text));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        TableElement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TableElement.java", TableElement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableCell", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:int", "tableLocator:row:column", "", "java.lang.String"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableCell", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:int:java.lang.String", "tableLocator:row:column:logLevel", "", "java.lang.String"), 64);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableRowShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:java.lang.String", "tableLocator:row:text", "", "void"), 257);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableRowShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:java.lang.String:java.lang.String", "tableLocator:row:text:logLevel", "", "void"), 287);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:java.lang.String", "tableLocator:text", "", "void"), 298);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:java.lang.String:java.lang.String", "tableLocator:text:logLevel", "", "void"), 318);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableCellShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:int:java.lang.String", "tableLocator:row:column:text", "", "void"), 92);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableCellShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:int:java.lang.String:java.lang.String", "tableLocator:row:column:text:logLevel", "", "void"), 121);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableColumnShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:java.lang.String", "tableLocator:col:text", "", "void"), 141);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableColumnShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:int:java.lang.String:java.lang.String", "tableLocator:col:text:logLevel", "", "void"), 184);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableFooterShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:java.lang.String", "tableLocator:text", "", "void"), 195);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableFooterShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:java.lang.String:java.lang.String", "tableLocator:text:logLevel", "", "void"), 215);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableHeaderShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:java.lang.String", "tableLocator:text", "", "void"), 226);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tableHeaderShouldContain", "com.github.markusbernhardt.selenium2library.keywords.TableElement", "java.lang.String:java.lang.String:java.lang.String", "tableLocator:text:logLevel", "", "void"), 246);
    }
}

