/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.BrowserManagement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class Logging
extends RunOnFailureKeywordsAdapter {
    protected static final Map<String, String[]> VALID_LOG_LEVELS;
    protected static String logDir;
    @Autowired
    protected BrowserManagement browserManagement;
    protected static ThreadLocal<PythonInterpreter> loggingPythonInterpreter;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    static {
        Logging.ajc$preClinit();
        logDir = null;
        VALID_LOG_LEVELS = new HashMap<String, String[]>();
        VALID_LOG_LEVELS.put("debug", new String[]{"debug", ""});
        VALID_LOG_LEVELS.put("html", new String[]{"info", ", True, False"});
        VALID_LOG_LEVELS.put("info", new String[]{"info", ""});
        VALID_LOG_LEVELS.put("trace", new String[]{"trace", ""});
        VALID_LOG_LEVELS.put("warn", new String[]{"warn", ""});
        loggingPythonInterpreter = new ThreadLocal<PythonInterpreter>(){

            @Override
            protected PythonInterpreter initialValue() {
                PythonInterpreter pythonInterpreter = new PythonInterpreter();
                pythonInterpreter.exec("from robot.variables import GLOBAL_VARIABLES; from robot.api import logger;");
                return pythonInterpreter;
            }
        };
    }

    @RobotKeywordOverload
    public List<String> logWindowIdentifiers() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            return this.logWindowIdentifiers("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public List<String> logWindowIdentifiers(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        try {
            List<String> windowIdentifiers = this.browserManagement.getWindowIdentifiers();
            for (String windowIdentifier : windowIdentifiers) {
                this.log(windowIdentifier, logLevel);
            }
            return windowIdentifiers;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public List<String> logWindowNames() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            return this.logWindowNames("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public List<String> logWindowNames(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        try {
            List<String> windowIdentifiers = this.browserManagement.getWindowNames();
            for (String windowIdentifier : windowIdentifiers) {
                this.log(windowIdentifier, logLevel);
            }
            return windowIdentifiers;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public List<String> logWindowTitles() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            return this.logWindowTitles("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public List<String> logWindowTitles(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        try {
            List<String> windowIdentifiers = this.browserManagement.getWindowTitles();
            for (String windowIdentifier : windowIdentifiers) {
                this.log(windowIdentifier, logLevel);
            }
            return windowIdentifiers;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String logLocation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            return this.logLocation("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public String logLocation(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.browserManagement.getLocation();
            this.log(actual, logLevel);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String logSource() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            return this.logSource("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public String logSource(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.browserManagement.getSource();
            this.log(actual, logLevel);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String logTitle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        try {
            return this.logTitle("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public String logTitle(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.browserManagement.getTitle();
            this.log(actual, logLevel);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String logSystemInfo() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            return this.logSystemInfo("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public String logSystemInfo(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.browserManagement.getSystemInfo();
            this.log(actual, logLevel);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String logRemoteCapabilities() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        try {
            return this.logRemoteCapabilities("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public String logRemoteCapabilities(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.browserManagement.getRemoteCapabilities();
            this.log(actual, logLevel);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String logRemoteSessionId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        try {
            return this.logRemoteSessionId("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logLevel=INFO"})
    public String logRemoteSessionId(String logLevel) {
        String string = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.browserManagement.getRemoteSessionId();
            this.log(actual, logLevel);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"logDirectory"})
    public void setLogDirectory(String logDirectory) throws Exception {
        String string = logDirectory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string);
        try {
            File file = new File(logDirectory);
            if (!(file.exists() && file.isDirectory() && file.canWrite())) {
                throw new Exception("Location given as parameter: " + logDirectory + " must exist and must be a writeable directory!");
            }
            Logging.setLogDir(file.getAbsolutePath());
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void trace(String msg) {
        this.log(msg, "trace");
    }

    protected void debug(String msg) {
        this.log(msg, "debug");
    }

    protected void info(String msg) {
        this.log(msg, "info");
    }

    protected void html(String msg) {
        this.log(msg, "html");
    }

    protected void warn(String msg) {
        this.log(msg, "warn");
    }

    protected void log(String msg, String logLevel) {
        String[] methodParameters = VALID_LOG_LEVELS.get(logLevel.toLowerCase());
        if (methodParameters == null) {
            throw new Selenium2LibraryNonFatalException(String.format("Given log level %s is invalid.", logLevel));
        }
        this.log0(msg, methodParameters[0], methodParameters[1]);
    }

    protected void log0(String msg, String methodName, String methodArguments) {
        if (msg.length() > 1024) {
            try {
                File tempFile = File.createTempFile("Selenium2Library-", ".log");
                tempFile.deleteOnExit();
                FileWriter writer = new FileWriter(tempFile);
                writer.write(msg);
                writer.close();
                loggingPythonInterpreter.get().exec(String.format("from __future__ import with_statement\n\nwith open('%s', 'r') as msg_file:\n    msg = msg_file.read()\n    logger.%s(msg%s)", tempFile.getAbsolutePath().replace("\\", "\\\\"), methodName, methodArguments));
            }
            catch (IOException e) {
                throw new Selenium2LibraryNonFatalException("Error in handling temp file for long log message.", e);
            }
        } else {
            loggingPythonInterpreter.get().exec(String.format("logger.%s('%s'%s)", methodName, msg.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n"), methodArguments));
        }
    }

    protected File getLogDir() {
        if (logDir == null) {
            PyString logDirName = (PyString)loggingPythonInterpreter.get().eval("GLOBAL_VARIABLES['${LOG FILE}']");
            if (logDirName != null && !logDirName.asString().toUpperCase().equals("NONE")) {
                return new File(logDirName.asString()).getParentFile();
            }
            logDirName = (PyString)loggingPythonInterpreter.get().eval("GLOBAL_VARIABLES['${OUTPUTDIR}']");
            return new File(logDirName.asString()).getParentFile();
        }
        return new File(logDir);
    }

    public static void setLogDir(String logDirectory) {
        String string = logDirectory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, null, null, (Object)string);
        try {
            logDir = logDirectory;
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Logging.java", Logging.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logWindowIdentifiers", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.util.List"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logWindowIdentifiers", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.util.List"), 63);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logTitle", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.lang.String"), 174);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logTitle", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.lang.String"), 191);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logSystemInfo", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.lang.String"), 198);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logSystemInfo", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.lang.String"), 216);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logRemoteCapabilities", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.lang.String"), 223);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logRemoteCapabilities", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.lang.String"), 251);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logRemoteSessionId", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.lang.String"), 258);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logRemoteSessionId", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.lang.String"), 275);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLogDirectory", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logDirectory", "java.lang.Exception", "void"), 293);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "setLogDir", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logDirectory", "", "void"), 380);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logWindowNames", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.util.List"), 72);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logWindowNames", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.util.List"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logWindowTitles", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.util.List"), 99);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logWindowTitles", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.util.List"), 117);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logLocation", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.lang.String"), 126);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logLocation", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.lang.String"), 143);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logSource", "com.github.markusbernhardt.selenium2library.keywords.Logging", "", "", "", "java.lang.String"), 150);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logSource", "com.github.markusbernhardt.selenium2library.keywords.Logging", "java.lang.String", "logLevel", "", "java.lang.String"), 167);
    }
}

