/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.BrowserManagement;
import com.github.markusbernhardt.selenium2library.keywords.FormElement;
import com.github.markusbernhardt.selenium2library.keywords.Logging;
import com.github.markusbernhardt.selenium2library.locators.ElementFinder;
import com.github.markusbernhardt.selenium2library.utils.Python;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class Element
extends RunOnFailureKeywordsAdapter {
    @Autowired
    protected BrowserManagement browserManagement;
    @Autowired
    protected FormElement formElement;
    @Autowired
    protected Logging logging;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;

    @RobotKeywordOverload
    @ArgumentNames(value={"text"})
    public void currentFrameContains(String text) {
        String string = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            this.currentFrameContains(text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"text", "logLevel=INFO"})
    public void currentFrameContains(String text, String logLevel) {
        String string = text;
        String string2 = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            if (!this.isTextPresent(text)) {
                this.logging.log(String.format("Current Frame Contains: %s => FAILED", text), logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Page should have contained text '%s', but did not.", text));
            }
            this.logging.log(String.format("Current Frame Contains: %s => OK", text), logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void currentFrameShouldNotContain(String text) {
        String string = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        try {
            this.currentFrameShouldNotContain(text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"text", "logLevel=INFO"})
    public void currentFrameShouldNotContain(String text, String logLevel) {
        String string = text;
        String string2 = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            if (this.isTextPresent(text)) {
                this.logging.log(String.format("Current Frame Should Not Contain: %s => FAILED", text), logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Page should have not contained text '%s', but did.", text));
            }
            this.logging.log(String.format("Current Frame Should Not Contain: %s => OK", text), logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldContain(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.elementShouldContain(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void elementShouldContain(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.getText(locator);
            if (!actual.toLowerCase().contains(text.toLowerCase())) {
                this.logging.info(String.format("Element Should Contain: %s => FAILED", text));
                throw new Selenium2LibraryNonFatalException(String.format("Element should have contained text '%s', but its text was %s.", text, actual));
            }
            this.logging.info(String.format("Element Should Contain: %s => OK", text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldNotContain(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.elementShouldNotContain(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void elementShouldNotContain(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.getText(locator);
            if (actual.toLowerCase().contains(text.toLowerCase())) {
                this.logging.info(String.format("Element Should Not Contain: %s => FAILED", text));
                throw new Selenium2LibraryNonFatalException(String.format("Element should not have contained text '%s', but its text was %s.", text, actual));
            }
            this.logging.info(String.format("Element Should Not Contain: %s => OK", text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void frameShouldContain(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.frameShouldContain(locator, text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "logLevel=INFO"})
    public void frameShouldContain(String locator, String text, String logLevel) {
        String string = locator;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (!this.frameContains(locator, text)) {
                this.logging.log(String.format("Frame Should Contain: %s => FAILED", text), logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Frame should have contained text '%s', but did not.", text));
            }
            this.logging.log(String.format("Frame Should Contain: %s => OK", text), logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "logLevel=INFO"})
    public void frameShouldNotContain(String locator, String text, String logLevel) {
        String string = locator;
        String string2 = text;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (this.frameContains(locator, text)) {
                this.logging.log(String.format("Frame Should Not Contain: %s => FAILED", text), logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Frame should not have contained text '%s', but did.", text));
            }
            this.logging.log(String.format("Frame Should Not Contain: %s => OK", text), logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContain(String text) {
        String string = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContain(text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"text", "logLevel=INFO"})
    public void pageShouldContain(String text, String logLevel) {
        String string = text;
        String string2 = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            if (!this.pageContains(text)) {
                this.logging.log(String.format("Page Should Contain: %s => FAILED", text), logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Page should have contained text '%s' but did not.", text));
            }
            this.logging.log(String.format("Page Should Contain: %s => OK", text), logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContain(String text) {
        String string = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContain(text, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"text", "logLevel=INFO"})
    public void pageShouldNotContain(String text, String logLevel) {
        String string = text;
        String string2 = logLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            if (this.pageContains(text)) {
                this.logging.log(String.format("Page Should Not Contain: %s => FAILED", text), logLevel);
                throw new Selenium2LibraryNonFatalException(String.format("Page should not have contained text '%s' but did.", text));
            }
            this.logging.log(String.format("Page Should Not Contain: %s => OK", text), logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainElement(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainElement(locator, "", "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainElement(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainElement(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainElement(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.pageShouldContainElement(locator, null, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void pageShouldContainElement(String locator, String tag, String message, String logLevel) {
        String name;
        String string = name = tag != null ? tag : "element";
        if (!this.isElementPresent(locator, tag)) {
            if (message == null || message.equals("")) {
                message = String.format("Page should have contained %s '%s' but did not", name, locator);
            }
            this.logging.log(message, logLevel);
            throw new Selenium2LibraryNonFatalException(message);
        }
        this.logging.log(String.format("Current page contains %s '%s'.", name, locator), logLevel);
    }

    @RobotKeywordOverload
    public void pageShouldNotContainElement(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainElement(locator, "", "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainElement(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainElement(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainElement(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.pageShouldNotContainElement(locator, null, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void pageShouldNotContainElement(String locator, String tag, String message, String logLevel) {
        String name;
        String string = name = tag != null ? tag : "element";
        if (this.isElementPresent(locator, tag)) {
            if (message == null || message.equals("")) {
                message = String.format("Page should not have contained %s '%s' but did", name, locator);
            }
            this.logging.log(message, logLevel);
            throw new Selenium2LibraryNonFatalException(message);
        }
        this.logging.log(String.format("Current page does not contain %s '%s'.", name, locator), logLevel);
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "id"})
    public void assignIdToElement(String locator, String id) {
        String string = locator;
        String string2 = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Assigning temporary id '%s' to element '%s'", id, locator));
            List<WebElement> elements = this.elementFind(locator, true, true);
            ((JavascriptExecutor)this.browserManagement.getCurrentWebDriver()).executeScript(String.format("arguments[0].id = '%s';", id), new Object[]{elements.get(0)});
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void elementShouldBeEnabled(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string);
        try {
            if (!this.isEnabled(locator)) {
                throw new Selenium2LibraryNonFatalException(String.format("Element %s is disabled.", locator));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void elementShouldBeDisabled(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string);
        try {
            if (this.isEnabled(locator)) {
                throw new Selenium2LibraryNonFatalException(String.format("Element %s is enabled.", locator));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldBeSelected(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string);
        try {
            this.elementShouldBeSelected(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE"})
    public void elementShouldBeSelected(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Verifying element '%s' is selected.", locator));
            boolean selected = this.isSelected(locator);
            if (!selected) {
                if (message == null || message.equals("")) {
                    message = String.format("Element '%s' should be selected, but it is not.", locator);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldNotBeSelected(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)string);
        try {
            this.elementShouldNotBeSelected(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE"})
    public void elementShouldNotBeSelected(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Verifying element '%s' is not selected.", locator));
            boolean selected = this.isSelected(locator);
            if (selected) {
                if (message == null || message.equals("")) {
                    message = String.format("Element '%s' should not be selected, but it is.", locator);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldBeVisible(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string);
        try {
            this.elementShouldBeVisible(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE"})
    public void elementShouldBeVisible(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Verifying element '%s' is visible.", locator));
            boolean visible = this.isVisible(locator);
            if (!visible) {
                if (message == null || message.equals("")) {
                    message = String.format("Element '%s' should be visible, but it is not.", locator);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldNotBeVisible(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string);
        try {
            this.elementShouldNotBeVisible(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE"})
    public void elementShouldNotBeVisible(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Verifying element '%s' is not visible.", locator));
            boolean visible = this.isVisible(locator);
            if (visible) {
                if (message == null || message.equals("")) {
                    message = String.format("Element '%s' should not be visible, but it is.", locator);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldBeClickable(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)string);
        try {
            this.elementShouldBeClickable(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE"})
    public void elementShouldBeClickable(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Verifying element '%s' is clickable.", locator));
            boolean clickable = this.isClickable(locator);
            if (!clickable) {
                if (message == null || message.equals("")) {
                    message = String.format("Element '%s' should be clickable, but it is not.", locator);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementShouldNotBeClickable(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string);
        try {
            this.elementShouldNotBeClickable(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE"})
    public void elementShouldNotBeClickable(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Verifying element '%s' is not clickable.", locator));
            boolean clickable = this.isClickable(locator);
            if (clickable) {
                if (message == null || message.equals("")) {
                    message = String.format("Element '%s' should not be clickable, but it is.", locator);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementTextShouldBe(String locator, String expected) {
        String string = locator;
        String string2 = expected;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.elementTextShouldBe(locator, expected, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void elementTextShouldBe(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object[])objectArray);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true);
            String actual = elements.get(0).getText();
            if (!text.equals(actual)) {
                if (message == null || message.equals("")) {
                    message = String.format("The text of element '%s' should have been '%s', but it was '%s'.", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void elementTextShouldNotBe(String locator, String expected) {
        String string = locator;
        String string2 = expected;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.elementTextShouldNotBe(locator, expected, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void elementTextShouldNotBe(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object[])objectArray);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true);
            String actual = elements.get(0).getText();
            if (text.equals(actual)) {
                if (message == null || message.equals("")) {
                    message = String.format("The text of element '%s' should have been '%s', but it was '%s'.", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"attributeLocator"})
    public String getElementAttribute(String attributeLocator) {
        String string = attributeLocator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)string);
        try {
            String[] parts = this.parseAttributeLocator(attributeLocator);
            List<WebElement> elements = this.elementFind(parts[0], true, false);
            if (elements.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("Element '%s' not found.", parts[0]));
            }
            return elements.get(0).getAttribute(parts[1]);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void clearElementText(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true);
            elements.get(0).clear();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public int getHorizontalPosition(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, false);
            if (elements.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("Could not determine position for '%s'.", locator));
            }
            return elements.get(0).getLocation().getX();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public String getValue(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)string);
        try {
            return this.getValue(locator, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String getValue(String locator, String tag) {
        List<WebElement> elements = this.elementFind(locator, true, false, tag);
        if (elements.size() == 0) {
            return null;
        }
        return elements.get(0).getAttribute("value");
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public String getText(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true);
            if (elements.size() == 0) {
                return null;
            }
            return elements.get(0).getText();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public int getVerticalPosition(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, false);
            if (elements.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("Could not determine position for '%s'.", locator));
            }
            return elements.get(0).getLocation().getY();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void clickElement(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Clicking element '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, true);
            elements.get(0).click();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "xOffset", "yOffset"})
    public void clickElementAtCoordinates(String locator, String xOffset, String yOffset) {
        String string = locator;
        String string2 = xOffset;
        String string3 = yOffset;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.logging.info(String.format("Clicking element '%s'in coordinates '%s', '%s'.", locator, xOffset, yOffset));
            List<WebElement> elements = this.elementFind(locator, true, true);
            WebElement element = elements.get(0);
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.moveToElement(element).moveByOffset(Integer.parseInt(xOffset), Integer.parseInt(yOffset)).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void doubleClickElement(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Double clicking element '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, true);
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.doubleClick(elements.get(0)).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void focus(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true);
            ((JavascriptExecutor)this.browserManagement.getCurrentWebDriver()).executeScript("arguments[0].focus();", new Object[]{elements.get(0)});
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"source", "target"})
    public void dragAndDrop(String source, String target) {
        String string = source;
        String string2 = target;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            List<WebElement> sourceElements = this.elementFind(source, true, true);
            List<WebElement> targetElements = this.elementFind(target, true, true);
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.dragAndDrop(sourceElements.get(0), targetElements.get(0)).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"source", "xOffset", "yOffset"})
    public void dragAndDropByOffset(String source, int xOffset, int yOffset) {
        String string = source;
        int n = xOffset;
        int n2 = yOffset;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object[])objectArray);
        try {
            List<WebElement> elements = this.elementFind(source, true, true);
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.dragAndDropBy(elements.get(0), xOffset, yOffset).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void mouseDown(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Simulating Mouse Down on element '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, false);
            if (elements.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("ERROR: Element %s not found.", locator));
            }
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.clickAndHold(elements.get(0)).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void mouseOut(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Simulating Mouse Out on element '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, false);
            if (elements.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("ERROR: Element %s not found.", locator));
            }
            WebElement element = elements.get(0);
            Dimension size = element.getSize();
            int offsetX = size.getWidth() / 2 + 1;
            int offsetY = size.getHeight() / 2 + 1;
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.moveToElement(element).moveByOffset(offsetX, offsetY).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void mouseOver(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Simulating Mouse Over on element '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, false);
            if (elements.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("ERROR: Element %s not found.", locator));
            }
            WebElement element = elements.get(0);
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.moveToElement(element).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void mouseUp(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Simulating Mouse Up on element '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, false);
            if (elements.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("ERROR: Element %s not found.", locator));
            }
            WebElement element = elements.get(0);
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.release(element).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void openContextMenu(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true);
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.contextClick(elements.get(0)).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "event"})
    public void simulate(String locator, String event) {
        String string = locator;
        String string2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true);
            String script = "element = arguments[0];eventName = arguments[1];if (document.createEventObject) {return element.fireEvent('on' + eventName, document.createEventObject());}var evt = document.createEvent(\"HTMLEvents\");evt.initEvent(eventName, true, true);return !element.dispatchEvent(evt);";
            ((JavascriptExecutor)this.browserManagement.getCurrentWebDriver()).executeScript(script, new Object[]{elements.get(0), event});
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "key"})
    public void pressKey(String locator, String key) {
        String string = locator;
        String string2 = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            if (key.startsWith("\\") && key.length() > 1) {
                key = this.mapAsciiKeyCodeToKey(Integer.parseInt(key.substring(1))).toString();
            }
            List<WebElement> element = this.elementFind(locator, true, true);
            element.get(0).sendKeys(new CharSequence[]{key});
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void clickLink(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Clicking link '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, true, "a");
            elements.get(0).click();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public ArrayList<String> getAllLinks() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this);
        try {
            ArrayList<String> ret = new ArrayList<String>();
            List<WebElement> elements = this.elementFind("tag=a", false, false, "a");
            for (WebElement element : elements) {
                ret.add(element.getAttribute("id"));
            }
            return ret;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void mouseDownOnLink(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true, "link");
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.clickAndHold(elements.get(0)).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"locator"})
    public void pageShouldContainLink(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainLink(locator, "", "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"locator", "message=NONE"})
    public void pageShouldContainLink(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainLink(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainLink(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.pageShouldContainElement(locator, "link", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainLink(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainLink(locator, "", "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainLink(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainLink(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainLink(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.pageShouldNotContainElement(locator, "link", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void clickImage(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Clicking image '%s'.", locator));
            List<WebElement> elements = this.elementFind(locator, true, false, "image");
            if (elements.size() == 0) {
                elements = this.elementFind(locator, true, true, "input");
            }
            WebElement element = elements.get(0);
            element.click();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void mouseDownOnImage(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> elements = this.elementFind(locator, true, true, "image");
            Actions action = new Actions(this.browserManagement.getCurrentWebDriver());
            action.clickAndHold(elements.get(0)).perform();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"locator"})
    public void pageShouldContainImage(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainImage(locator, "", "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"locator", "message=NONE"})
    public void pageShouldContainImage(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainImage(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainImage(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.pageShouldContainElement(locator, "image", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"locator"})
    public void pageShouldNotContainImage(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainImage(locator, "", "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"locator", "message=NONE"})
    public void pageShouldNotContainImage(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_74, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainImage(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainImage(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_75, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.pageShouldNotContainElement(locator, "image", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"xpath"})
    public int getMatchingXpathCount(String xpath) {
        String string = xpath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_76, (Object)this, (Object)this, (Object)string);
        try {
            if (!xpath.startsWith("xpath=")) {
                xpath = "xpath=" + xpath;
            }
            List<WebElement> elements = this.elementFind(xpath, false, false);
            return elements.size();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"xpath", "expectedXpathCount"})
    public void xpathShouldMatchXTimes(String xpath, int expectedXpathCount) {
        String string = xpath;
        int n = expectedXpathCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_77, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        try {
            this.xpathShouldMatchXTimes(xpath, expectedXpathCount, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"xpath", "expectedXpathCount", "message=NONE"})
    public void xpathShouldMatchXTimes(String xpath, int expectedXpathCount, String message) {
        String string = xpath;
        int n = expectedXpathCount;
        String string2 = message;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_78, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.xpathShouldMatchXTimes(xpath, expectedXpathCount, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"xpath", "expectedXpathCount", "message=NONE", "logLevel=INFO"})
    public void xpathShouldMatchXTimes(String xpath, int expectedXpathCount, String message, String logLevel) {
        String string = xpath;
        int n = expectedXpathCount;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_79, (Object)this, (Object)this, (Object[])objectArray);
        try {
            List<WebElement> elements;
            int actualXpathCount;
            if (!xpath.startsWith("xpath=")) {
                xpath = "xpath=" + xpath;
            }
            if ((actualXpathCount = (elements = this.elementFind(xpath, false, false)).size()) != expectedXpathCount) {
                if (message == null || message.equals("")) {
                    message = String.format("Xpath %s should have matched %s times but matched %s times.", xpath, expectedXpathCount, actualXpathCount);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.log(String.format("Current page contains %s elements matching '%s'.", actualXpathCount, xpath), logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected List<WebElement> elementFind(String locator, boolean firstOnly, boolean required) {
        return this.elementFind(locator, firstOnly, required, null);
    }

    protected List<WebElement> elementFind(String locator, boolean firstOnly, boolean required, String tag) {
        List<WebElement> elements = ElementFinder.find(this.browserManagement.getCurrentWebDriver(), locator, tag);
        if (required && elements.size() == 0) {
            throw new Selenium2LibraryNonFatalException(String.format("Element locator '%s' did not match any elements.", locator));
        }
        if (firstOnly && elements.size() > 1) {
            ArrayList<WebElement> tmp = new ArrayList<WebElement>();
            tmp.add(elements.get(0));
            elements = tmp;
        }
        return elements;
    }

    protected boolean frameContains(String locator, String text) {
        WebDriver current = this.browserManagement.getCurrentWebDriver();
        List<WebElement> elements = this.elementFind(locator, true, true);
        current.switchTo().frame(elements.get(0));
        this.logging.info(String.format("Searching for text from frame '%s'.", locator));
        boolean found = this.isTextPresent(text);
        current.switchTo().defaultContent();
        return found;
    }

    protected boolean isTextPresent(String text) {
        String locator = String.format("xpath=//*[contains(., %s)]", Element.escapeXpathValue(text));
        return this.isElementPresent(locator);
    }

    protected boolean isEnabled(String locator) {
        List<WebElement> elements = this.elementFind(locator, true, true);
        WebElement element = elements.get(0);
        if (!this.formElement.isFormElement(element)) {
            throw new Selenium2LibraryNonFatalException(String.format("ERROR: Element %s is not an input.", locator));
        }
        if (!element.isEnabled()) {
            return false;
        }
        String readonly = element.getAttribute("readonly");
        return !readonly.equals("readonly") && !readonly.equals("true");
    }

    protected boolean isVisible(String locator) {
        List<WebElement> elements = this.elementFind(locator, true, false);
        if (elements.size() == 0) {
            return false;
        }
        WebElement element = elements.get(0);
        return element.isDisplayed();
    }

    protected boolean isClickable(String locator) {
        List<WebElement> webElements = this.elementFind(locator, true, false);
        if (webElements.size() == 0) {
            return false;
        }
        WebElement element = webElements.get(0);
        return element.isDisplayed() && element.isEnabled();
    }

    protected boolean isSelected(String locator) {
        List<WebElement> webElements = this.elementFind(locator, true, false);
        if (webElements.size() == 0) {
            return false;
        }
        WebElement element = webElements.get(0);
        return element.isSelected();
    }

    protected String[] parseAttributeLocator(String attributeLocator) {
        int index = attributeLocator.lastIndexOf(64);
        if (index <= 0) {
            throw new Selenium2LibraryNonFatalException(String.format("Attribute locator '%s' does not contain an element locator.", attributeLocator));
        }
        if (index + 1 == attributeLocator.length()) {
            throw new Selenium2LibraryNonFatalException(String.format("Attribute locator '%s' does not contain an attribute name.", attributeLocator));
        }
        String[] parts = new String[]{attributeLocator.substring(0, index), attributeLocator.substring(index + 1)};
        return parts;
    }

    protected boolean isElementPresent(String locator) {
        return this.isElementPresent(locator, null);
    }

    protected boolean isElementPresent(String locator, String tag) {
        return this.elementFind(locator, true, false, tag).size() != 0;
    }

    protected boolean pageContains(String text) {
        WebDriver current = this.browserManagement.getCurrentWebDriver();
        current.switchTo().defaultContent();
        if (this.isTextPresent(text)) {
            return true;
        }
        List<WebElement> elements = this.elementFind("xpath=//frame|//iframe", false, false);
        Iterator<WebElement> it = elements.iterator();
        while (it.hasNext()) {
            current.switchTo().frame(it.next());
            boolean found = this.isTextPresent(text);
            current.switchTo().defaultContent();
            if (!found) continue;
            return true;
        }
        return false;
    }

    protected CharSequence mapAsciiKeyCodeToKey(int keyCode) {
        switch (keyCode) {
            case 0: {
                return Keys.NULL;
            }
            case 8: {
                return Keys.BACK_SPACE;
            }
            case 9: {
                return Keys.TAB;
            }
            case 10: {
                return Keys.RETURN;
            }
            case 13: {
                return Keys.ENTER;
            }
            case 24: {
                return Keys.CANCEL;
            }
            case 27: {
                return Keys.ESCAPE;
            }
            case 32: {
                return Keys.SPACE;
            }
            case 42: {
                return Keys.MULTIPLY;
            }
            case 43: {
                return Keys.ADD;
            }
            case 44: {
                return Keys.SEPARATOR;
            }
            case 45: {
                return Keys.SUBTRACT;
            }
            case 56: {
                return Keys.DECIMAL;
            }
            case 57: {
                return Keys.DIVIDE;
            }
            case 59: {
                return Keys.SEMICOLON;
            }
            case 61: {
                return Keys.EQUALS;
            }
            case 127: {
                return Keys.DELETE;
            }
        }
        return new StringBuffer((char)keyCode);
    }

    public static String escapeXpathValue(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_80, null, null, (Object)string);
        try {
            if (value.contains("\"") && value.contains("'")) {
                String[] partsWoApos = value.split("'");
                return String.format("concat('%s')", Python.join("', \"'\", '", Arrays.asList(partsWoApos)));
            }
            if (value.contains("'")) {
                return String.format("\"%s\"", value);
            }
            return String.format("'%s'", value);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Element.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Element.java", Element.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "currentFrameContains", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "text", "", "void"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "currentFrameContains", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "text:logLevel", "", "void"), 68);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "frameShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:text:logLevel", "", "void"), 212);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "text", "", "void"), 223);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "text:logLevel", "", "void"), 239);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "text", "", "void"), 250);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "text:logLevel", "", "void"), 266);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 277);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 282);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 302);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 320);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 325);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "currentFrameShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "text", "", "void"), 79);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 345);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assignIdToElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:id", "", "void"), 394);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeEnabled", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 413);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeDisabled", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 430);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeSelected", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 437);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeSelected", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 454);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotBeSelected", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 467);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotBeSelected", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 484);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeVisible", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 497);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeVisible", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 519);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "currentFrameShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "text:logLevel", "", "void"), 95);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotBeVisible", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 532);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotBeVisible", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 554);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeClickable", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 567);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldBeClickable", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 584);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotBeClickable", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 597);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotBeClickable", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 614);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementTextShouldBe", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:expected", "", "void"), 627);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementTextShouldBe", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 650);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementTextShouldNotBe", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:expected", "", "void"), 664);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementTextShouldNotBe", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 687);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:text", "", "void"), 106);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getElementAttribute", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "attributeLocator", "", "java.lang.String"), 715);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearElementText", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 747);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHorizontalPosition", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "int"), 768);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "java.lang.String"), 791);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getText", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "java.lang.String"), 817);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getVerticalPosition", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "int"), 842);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clickElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 868);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clickElementAtCoordinates", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:xOffset:yOffset", "", "void"), 898);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doubleClickElement", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 918);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "focus", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 938);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 124);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dragAndDrop", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "source:target", "", "void"), 969);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dragAndDropByOffset", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:int:int", "source:xOffset:yOffset", "", "void"), 1009);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mouseDown", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1032);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mouseOut", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1056);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mouseOver", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1084);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mouseUp", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1109);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openContextMenu", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1133);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simulate", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:event", "", "void"), 1157);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pressKey", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:key", "", "void"), 1200);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clickLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1223);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:text", "", "void"), 137);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllLinks", "com.github.markusbernhardt.selenium2library.keywords.Element", "", "", "", "java.util.ArrayList"), 1238);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mouseDownOnLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1265);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1274);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 1280);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 1300);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1305);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 1310);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainLink", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 1330);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clickImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1349);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mouseDownOnImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1377);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "elementShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 156);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1386);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 1392);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 1412);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "locator", "", "void"), 1418);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:message", "", "void"), 1424);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainImage", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 1444);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMatchingXpathCount", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "xpath", "", "int"), 1464);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "xpathShouldMatchXTimes", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:int", "xpath:expectedXpathCount", "", "void"), 1475);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "xpathShouldMatchXTimes", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:int:java.lang.String", "xpath:expectedXpathCount:message", "", "void"), 1481);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "xpathShouldMatchXTimes", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:int:java.lang.String:java.lang.String", "xpath:expectedXpathCount:message:logLevel", "", "void"), 1500);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "frameShouldContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String", "locator:text", "", "void"), 169);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "escapeXpathValue", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String", "value", "", "java.lang.String"), 1697);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "frameShouldContain", "com.github.markusbernhardt.selenium2library.keywords.Element", "java.lang.String:java.lang.String:java.lang.String", "locator:text:logLevel", "", "void"), 187);
    }
}

