/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.BrowserManagement;
import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class Cookie
extends RunOnFailureKeywordsAdapter {
    @Autowired
    protected BrowserManagement browserManagement;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    @RobotKeyword
    public void deleteAllCookies() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            this.browserManagement.getCurrentWebDriver().manage().deleteAllCookies();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"name"})
    public void deleteCookie(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        try {
            this.browserManagement.getCurrentWebDriver().manage().deleteCookieNamed(name);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getCookies() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            StringBuffer ret = new StringBuffer();
            ArrayList cookies = new ArrayList(this.browserManagement.getCurrentWebDriver().manage().getCookies());
            int i = 0;
            while (i < cookies.size()) {
                ret.append(String.valueOf(((org.openqa.selenium.Cookie)cookies.get(i)).getName()) + "=" + ((org.openqa.selenium.Cookie)cookies.get(i)).getValue());
                if (i != cookies.size() - 1) {
                    ret.append("; ");
                }
                ++i;
            }
            return ret.toString();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"name"})
    public String getCookieValue(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        try {
            org.openqa.selenium.Cookie cookie = this.browserManagement.getCurrentWebDriver().manage().getCookieNamed(name);
            if (cookie != null) {
                return cookie.getValue();
            }
            throw new Selenium2LibraryNonFatalException(String.format("Cookie with name %s not found.", name));
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void addCookie(String name, String value) {
        String string = name;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.addCookie(name, value, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void addCookie(String name, String value, String path) {
        String string = name;
        String string2 = value;
        String string3 = path;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.addCookie(name, value, path, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void addCookie(String name, String value, String path, String domain) {
        String string = name;
        String string2 = value;
        String string3 = path;
        String string4 = domain;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.addCookie(name, value, path, domain, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void addCookie(String name, String value, String path, String domain, String secure) {
        String string = name;
        String string2 = value;
        String string3 = path;
        String string4 = domain;
        String string5 = secure;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.addCookie(name, value, path, domain, secure, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"name", "value", "path=NONE", "domain=NONE", "secure=NONE", "expiry=NONE"})
    public void addCookie(String name, String value, String path, String domain, String secure, String expiry) {
        String string = name;
        String string2 = value;
        String string3 = path;
        String string4 = domain;
        String string5 = secure;
        String string6 = expiry;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        try {
            org.openqa.selenium.Cookie cookie = new org.openqa.selenium.Cookie(name, value, domain, path, null, "true".equals(secure.toLowerCase()));
            this.browserManagement.getCurrentWebDriver().manage().addCookie(cookie);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Cookie.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Cookie.java", Cookie.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAllCookies", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "", "", "", "void"), 31);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteCookie", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "java.lang.String", "name", "", "void"), 45);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCookies", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "", "", "", "java.lang.String"), 55);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCookieValue", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "java.lang.String", "name", "", "java.lang.String"), 81);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookie", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "java.lang.String:java.lang.String", "name:value", "", "void"), 92);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookie", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "java.lang.String:java.lang.String:java.lang.String", "name:value:path", "", "void"), 97);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookie", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "name:value:path:domain", "", "void"), 102);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookie", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "name:value:path:domain:secure", "", "void"), 107);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookie", "com.github.markusbernhardt.selenium2library.keywords.Cookie", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "name:value:path:domain:secure:expiry", "", "void"), 130);
    }
}

