/*
 * Decompiled with CFR 0.152.
 */
import com.github.markusbernhardt.selenium2library.keywords.BrowserManagement;
import com.github.markusbernhardt.selenium2library.keywords.Cookie;
import com.github.markusbernhardt.selenium2library.keywords.Element;
import com.github.markusbernhardt.selenium2library.keywords.FormElement;
import com.github.markusbernhardt.selenium2library.keywords.JavaScript;
import com.github.markusbernhardt.selenium2library.keywords.Logging;
import com.github.markusbernhardt.selenium2library.keywords.RunOnFailure;
import com.github.markusbernhardt.selenium2library.keywords.Screenshot;
import com.github.markusbernhardt.selenium2library.keywords.SelectElement;
import com.github.markusbernhardt.selenium2library.keywords.TableElement;
import com.github.markusbernhardt.selenium2library.keywords.Waiting;
import com.github.markusbernhardt.selenium2library.utils.Javadoc2Libdoc;
import java.io.File;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.library.AnnotationLibrary;

public class Selenium2Library
extends AnnotationLibrary {
    public static final String KEYWORD_PATTERN = "com/github/markusbernhardt/selenium2library/keywords/**/*.class";
    public static final Javadoc2Libdoc JAVADOC_2_LIBDOC = new Javadoc2Libdoc(Selenium2Library.class);
    public static final String ROBOT_LIBRARY_DOC_FORMAT = "HTML";
    public static final String ROBOT_LIBRARY_SCOPE = "GLOBAL";
    public static final String ROBOT_LIBRARY_VERSION = Selenium2Library.loadRobotLibraryVersion();
    @Autowired
    protected BrowserManagement browserManagement;
    @Autowired
    protected Cookie cookie;
    @Autowired
    protected Element element;
    @Autowired
    protected FormElement formElement;
    @Autowired
    protected JavaScript javaScript;
    @Autowired
    protected Logging logging;
    @Autowired
    protected RunOnFailure runOnFailure;
    @Autowired
    protected Screenshot screenshot;
    @Autowired
    protected SelectElement selectElement;
    @Autowired
    protected TableElement tableElement;
    @Autowired
    protected Waiting waiting;

    private static String loadRobotLibraryVersion() {
        try {
            return ResourceBundle.getBundle(Selenium2Library.class.getCanonicalName().replace(".", File.separator)).getString("version");
        }
        catch (RuntimeException runtimeException) {
            return "unknown";
        }
    }

    public Selenium2Library() {
        this("5.0");
    }

    public Selenium2Library(String timeout) {
        this(timeout, "0.0");
    }

    public Selenium2Library(String timeout, String implicitWait) {
        this(timeout, implicitWait, "Capture Page Screenshot");
    }

    public Selenium2Library(String timeout, String implicitWait, String runOnFailure) {
        this.addKeywordPattern(KEYWORD_PATTERN);
        this.createKeywordFactory();
        this.browserManagement.setSeleniumTimeout(timeout);
        this.browserManagement.setSeleniumImplicitWait(implicitWait);
        this.runOnFailure.registerKeywordToRunOnFailure(runOnFailure);
    }

    public BrowserManagement getBrowserManagement() {
        return this.browserManagement;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public Element getElement() {
        return this.element;
    }

    public FormElement getFormElement() {
        return this.formElement;
    }

    public JavaScript getJavaScript() {
        return this.javaScript;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public RunOnFailure getRunOnFailure() {
        return this.runOnFailure;
    }

    public Screenshot getScreenshot() {
        return this.screenshot;
    }

    public SelectElement getSelectElement() {
        return this.selectElement;
    }

    public TableElement getTableElement() {
        return this.tableElement;
    }

    public Waiting getWaiting() {
        return this.waiting;
    }

    public Object runKeyword(String keywordName, Object[] args) {
        return super.runKeyword(keywordName, this.toStrings(args));
    }

    public String getKeywordDocumentation(String keywordName) {
        String keywordDocumentation = JAVADOC_2_LIBDOC.getKeywordDocumentation(keywordName);
        if (keywordDocumentation == null) {
            try {
                return super.getKeywordDocumentation(keywordName);
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }
        return keywordDocumentation;
    }

    public static Selenium2Library getLibraryInstance() throws ScriptException {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("python");
        engine.put("library", "Selenium2Library");
        engine.eval("from robot.libraries.BuiltIn import BuiltIn");
        engine.eval("instance = BuiltIn().get_library_instance(library)");
        return (Selenium2Library)((Object)engine.get("instance"));
    }

    protected Object[] toStrings(Object[] args) {
        Object[] newArgs = new Object[args.length];
        int i = 0;
        while (i < newArgs.length) {
            newArgs[i] = args[i].getClass().isArray() ? args[i] : args[i].toString();
            ++i;
        }
        return newArgs;
    }
}

