/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.utils;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.utils.Python;
import com.github.markusbernhardt.selenium2library.utils.TimestrHelper;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public abstract class Robotframework {
    public static String getLinkPath(File target, File base) {
        String path = Robotframework.getPathname(target, base);
        return Robotframework.encodeURLComponent(path);
    }

    public static String encodeURLComponent(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~') {
                    sb.append(c);
                } else {
                    byte[] bytes;
                    byte[] byArray = bytes = ("" + c).getBytes("UTF-8");
                    int n = bytes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        sb.append('%');
                        int upper = b >> 4 & 0xF;
                        sb.append(Integer.toHexString(upper).toUpperCase(Locale.US));
                        int lower = b & 0xF;
                        sb.append(Integer.toHexString(lower).toUpperCase(Locale.US));
                        ++n2;
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException uee) {
            throw new Selenium2LibraryNonFatalException(uee);
        }
    }

    public static String getPathname(File target, File base) {
        String targetName = target.getAbsolutePath();
        String baseName = base.getAbsolutePath();
        if (base.isFile()) {
            baseName = Python.osPathDirname(baseName);
        }
        if (baseName.equals(targetName)) {
            return Python.osPathBasename(targetName);
        }
        String[] splittedBaseName = Python.osPathSplitDrive(baseName);
        if (!Python.osPathSplitDrive(targetName)[0].equals(splittedBaseName[0])) {
            return targetName;
        }
        int commonLen = Robotframework.commonPath(baseName, targetName).length();
        if (splittedBaseName[1].equals(File.separator)) {
            return targetName.substring(commonLen);
        }
        if (commonLen == splittedBaseName[0].length() + File.separator.length()) {
            commonLen -= File.separator.length();
        }
        baseName = baseName.substring(commonLen);
        StringBuilder builder = new StringBuilder();
        int index = -1;
        while ((index = baseName.indexOf(File.separatorChar, index + 1)) != -1) {
            builder.append("..");
            builder.append(File.separator);
        }
        builder.append(targetName.substring(commonLen + 1));
        return builder.toString();
    }

    public static String commonPath(String p1, String p2) {
        while (p1.length() > 0 && p2.length() > 0) {
            if (p1.equals(p2)) {
                return p1;
            }
            if (p1.length() > p2.length()) {
                p1 = Python.osPathDirname(p1);
                continue;
            }
            p2 = Python.osPathDirname(p2);
        }
        return "";
    }

    public static String secsToTimestr(double double_secs) {
        TimestrHelper secsToTimestrHelper = new TimestrHelper(double_secs);
        return secsToTimestrHelper.getValue();
    }

    /*
     * Unable to fully structure code
     */
    public static double timestrToSecs(String timestr) {
        if ((timestr = Robotframework.normalizeTimestr(timestr)).length() == 0) {
            throw new Selenium2LibraryNonFatalException("Invalid timestr: " + timestr);
        }
        try {
            return Double.parseDouble(timestr);
        }
        catch (NumberFormatException v0) {
            millis = 0;
            secs = 0;
            mins = 0;
            hours = 0;
            days = 0;
            sign = 0;
            if (timestr.charAt(0) == '-') {
                sign = -1;
                timestr = timestr.substring(1);
            } else {
                sign = 1;
            }
            stringBuilder = new StringBuilder();
            var11_8 = timestr.toCharArray();
            var10_9 = var11_8.length;
            var9_10 = 0;
            ** while (var9_10 < var10_9)
        }
lbl-1000:
        // 1 sources

        {
            c = var11_8[var9_10];
            switch (c) {
                case 'x': {
                    millis = Integer.parseInt(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    break;
                }
                case 's': {
                    secs = Integer.parseInt(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    break;
                }
                case 'm': {
                    mins = Integer.parseInt(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    break;
                }
                case 'h': {
                    hours = Integer.parseInt(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    break;
                }
                case 'p': {
                    days = Integer.parseInt(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            ++var9_10;
            continue;
        }
lbl49:
        // 1 sources

        if (stringBuilder.length() != 0) {
            throw new Selenium2LibraryNonFatalException("Invalid timestr: " + timestr);
        }
        return sign * (millis / 1000 + secs + mins * 60 + hours * 60 * 60 + days * 60 * 60 * 24);
    }

    public static String normalizeTimestr(String timestr) {
        timestr = timestr.toLowerCase().replace(" ", "");
        timestr = timestr.replace("milliseconds", "ms");
        timestr = timestr.replace("millisecond", "ms");
        timestr = timestr.replace("millis", "ms");
        timestr = timestr.replace("seconds", "s");
        timestr = timestr.replace("second", "s");
        timestr = timestr.replace("secs", "s");
        timestr = timestr.replace("sec", "s");
        timestr = timestr.replace("minutes", "m");
        timestr = timestr.replace("minute", "m");
        timestr = timestr.replace("mins", "m");
        timestr = timestr.replace("min", "m");
        timestr = timestr.replace("hours", "h");
        timestr = timestr.replace("hour", "h");
        timestr = timestr.replace("days", "d");
        timestr = timestr.replace("day", "d");
        timestr = timestr.replace("ms", "x");
        timestr = timestr.replace("d", "p");
        return timestr;
    }
}

