/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.BrowserManagement;
import com.github.markusbernhardt.selenium2library.keywords.Element;
import com.github.markusbernhardt.selenium2library.utils.Robotframework;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.JavascriptExecutor;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class Waiting
extends RunOnFailureKeywordsAdapter {
    @Autowired
    protected BrowserManagement browserManagement;
    @Autowired
    protected Element element;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;

    @RobotKeywordOverload
    public void waitForCondition(String condition) {
        String string = condition;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            this.waitForCondition(condition, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitForCondition(String condition, String timeout) {
        String string = condition;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitForCondition(condition, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"condition", "timeout=NONE", "message=NONE"})
    public void waitForCondition(final String condition, String timeout, String message) {
        String string = condition;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Condition '%s' did not become true in <TIMEOUT>", condition);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return Boolean.TRUE.equals(((JavascriptExecutor)Waiting.this.browserManagement.getCurrentWebDriver()).executeScript(condition, new Object[0]));
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageContains(String condition) {
        String string = condition;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilPageContains(condition, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageContains(String condition, String timeout) {
        String string = condition;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilPageContains(condition, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"condition", "timeout=NONE", "message=NONE"})
    public void waitUntilPageContains(final String text, String timeout, String message) {
        String string = text;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Text '%s' did not appear in <TIMEOUT>", text);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return Waiting.this.element.isTextPresent(text);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageNotContains(String condition, String timeout) {
        String string = condition;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilPageNotContains(condition, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageNotContains(String condition) {
        String string = condition;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilPageNotContains(condition, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"text", "timeout=NONE", "message=NONE"})
    public void waitUntilPageNotContains(final String text, String timeout, String message) {
        String string = text;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Text '%s' did not disappear in <TIMEOUT>", text);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return !Waiting.this.element.isTextPresent(text);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageContainsElement(String condition) {
        String string = condition;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilPageContainsElement(condition, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageContainsElement(String condition, String timeout) {
        String string = condition;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilPageContainsElement(condition, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilPageContainsElement(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' did not appear in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return Waiting.this.element.isElementPresent(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageNotContainsElement(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilPageNotContainsElement(locator, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilPageNotContainsElement(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilPageNotContainsElement(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilPageNotContainsElement(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' did not disappear in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return !Waiting.this.element.isElementPresent(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsVisible(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilElementIsVisible(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsVisible(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilElementIsVisible(locator, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilElementIsVisible(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' not visible in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return Waiting.this.element.isVisible(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsNotVisible(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilElementIsNotVisible(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsNotVisible(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilElementIsNotVisible(locator, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilElementIsNotVisible(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' still visible in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return !Waiting.this.element.isVisible(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsClickable(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilElementIsClickable(locator, null, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsClickable(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilElementIsClickable(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilElementIsClickable(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' not clickable in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return Waiting.this.element.isClickable(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsNotClickable(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilElementIsNotClickable(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsNotClickable(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilElementIsNotClickable(locator, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilElementIsNotClickable(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' still clickable in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return !Waiting.this.element.isClickable(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsSuccessfullyClicked(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilElementIsSuccessfullyClicked(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsSuccessfullyClicked(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilElementIsSuccessfullyClicked(locator, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilElementIsSuccessfullyClicked(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' not successfully clicked in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    Waiting.this.element.clickElement(locator);
                    return true;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsSelected(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilElementIsSelected(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsSelected(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilElementIsSelected(locator, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilElementIsSelected(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' not selected in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return Waiting.this.element.isSelected(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsNotSelected(String locator, String timeout) {
        String string = locator;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilElementIsNotSelected(locator, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilElementIsNotSelected(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilElementIsNotSelected(locator, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "timeout=NONE", "message=NONE"})
    public void waitUntilElementIsNotSelected(final String locator, String timeout, String message) {
        String string = locator;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Element '%s' still selected in <TIMEOUT>", locator);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    return !Waiting.this.element.isSelected(locator);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleContains(String title, String timeout) {
        String string = title;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilTitleContains(title, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleContains(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilTitleContains(title, null, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title", "timeout=NONE", "message=NONE"})
    public void waitUntilTitleContains(final String title, String timeout, String message) {
        String string = title;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Title '%s' did not appear in <TIMEOUT>", title);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    String currentTitle = Waiting.this.browserManagement.getTitle();
                    return currentTitle != null && currentTitle.contains(title);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleNotContains(String title, String timeout) {
        String string = title;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilTitleNotContains(title, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleNotContains(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilTitleNotContains(title, null, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title", "timeout=NONE", "message=NONE"})
    public void waitUntilTitleNotContains(final String title, String timeout, String message) {
        String string = title;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Title '%s' did not appear in <TIMEOUT>", title);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    String currentTitle = Waiting.this.browserManagement.getTitle();
                    return currentTitle == null || !currentTitle.contains(title);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleIs(String title, String timeout) {
        String string = title;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilTitleIs(title, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleIs(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilTitleIs(title, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title", "timeout=NONE", "message=NONE"})
    public void waitUntilTitleIs(final String title, String timeout, String message) {
        String string = title;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Title '%s' did not appear in <TIMEOUT>", title);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    String currentTitle = Waiting.this.browserManagement.getTitle();
                    return currentTitle != null && currentTitle.equals(title);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleIsNot(String title, String timeout) {
        String string = title;
        String string2 = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.waitUntilTitleIsNot(title, timeout, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void waitUntilTitleIsNot(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)string);
        try {
            this.waitUntilTitleIsNot(title, null, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title", "timeout=NONE", "message=NONE"})
    public void waitUntilTitleIsNot(final String title, String timeout, String message) {
        String string = title;
        String string2 = timeout;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (message == null) {
                message = String.format("Title '%s' did not appear in <TIMEOUT>", title);
            }
            this.waitUntil(timeout, message, new WaitUntilFunction(){

                @Override
                public boolean isFinished() {
                    String currentTitle = Waiting.this.browserManagement.getTitle();
                    return currentTitle == null || !currentTitle.equals(title);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void waitUntil(String timestr, String message, WaitUntilFunction function) {
        double timeout = timestr != null ? Robotframework.timestrToSecs(timestr) : this.browserManagement.getTimeout();
        message = message.replace("<TIMEOUT>", Robotframework.secsToTimestr(timeout));
        long maxtime = System.currentTimeMillis() + (long)(timeout * 1000.0);
        while (true) {
            try {
                if (function.isFinished()) {
                    break;
                }
            }
            catch (Throwable throwable) {}
            if (System.currentTimeMillis() > maxtime) {
                throw new Selenium2LibraryNonFatalException(message);
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        Waiting.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Waiting.java", Waiting.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitForCondition", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "condition", "", "void"), 34);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitForCondition", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "condition:timeout", "", "void"), 39);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageContainsElement", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "condition:timeout", "", "void"), 166);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageContainsElement", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 187);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageNotContainsElement", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 201);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageNotContainsElement", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 206);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageNotContainsElement", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 227);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsVisible", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 241);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsVisible", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 246);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsVisible", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 266);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotVisible", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 280);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotVisible", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 285);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitForCondition", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "condition:timeout:message", "", "void"), 68);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotVisible", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 305);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsClickable", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 319);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsClickable", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 324);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsClickable", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 344);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotClickable", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 358);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotClickable", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 363);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotClickable", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 383);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsSuccessfullyClicked", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 397);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsSuccessfullyClicked", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 402);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsSuccessfullyClicked", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 423);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "condition", "", "void"), 83);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsSelected", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 438);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsSelected", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 443);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsSelected", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 463);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotSelected", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "locator:timeout", "", "void"), 477);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotSelected", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "locator", "", "void"), 482);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilElementIsNotSelected", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "locator:timeout:message", "", "void"), 502);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "title:timeout", "", "void"), 516);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "title", "", "void"), 521);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "title:timeout:message", "", "void"), 540);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleNotContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "title:timeout", "", "void"), 555);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "condition:timeout", "", "void"), 88);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleNotContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "title", "", "void"), 560);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleNotContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "title:timeout:message", "", "void"), 579);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleIs", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "title:timeout", "", "void"), 594);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleIs", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "title", "", "void"), 599);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleIs", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "title:timeout:message", "", "void"), 618);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleIsNot", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "title:timeout", "", "void"), 633);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleIsNot", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "title", "", "void"), 638);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilTitleIsNot", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "title:timeout:message", "", "void"), 657);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "text:timeout:message", "", "void"), 108);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageNotContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String", "condition:timeout", "", "void"), 122);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageNotContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "condition", "", "void"), 127);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageNotContains", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String:java.lang.String:java.lang.String", "text:timeout:message", "", "void"), 147);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilPageContainsElement", "com.github.markusbernhardt.selenium2library.keywords.Waiting", "java.lang.String", "condition", "", "void"), 161);
    }

    protected static interface WaitUntilFunction {
        public boolean isFinished();
    }
}

